%include "lmacros3.mac"

REPCHAR equ 255
					;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Read Compressed Panel file
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
					;

	cpu 8086
	org 256
start:
	mov si, 81h
@@:
	lodsb
	cmp al, 32
	je @B
	cmp al, 9
	je @B
	dec si
	mov dx, si
@@:
	lodsb
	cmp al, 13
	jne @B
	mov byte [si - 1], 0
	mov bx, paras(size + 2 * 64 * 1024)
	mov ah, 4Ah
	int 21h
	jc error
	mov sp, stack.end

	mov bx, cs
	add bx, paras(size)
	mov es, bx
	mov word [inbuffer], bx
	xor di, di
	xor ax, ax
	mov cx, words(64 * 1024)
	rep stosw
	add bx, paras(64 * 1024)
	mov es, bx
	mov word [outbuffer], bx
	xor di, di
	xor ax, ax
	mov cx, words(64 * 1024)
	rep stosw

	XOR  AL,AL			;AN024;
	MOV  AH,3DH			;AN024;
	INT  21H			;AN024;open file
					;AN024;
	MOV  BX,AX			;AN024;get file handle
	PUSH BX 			;AN024;save it
	XOR  CX,CX			;AN024;
	XOR  DX,DX			;AN024;
	MOV  AL,2			;AN024;move ptr to end of file
	MOV  AH,42H			;AN024;LSEEK
	INT  21H			;AN024;
					;AN024;
	PUSH AX 			;AN024;save length
	XOR  CX,CX			;AN024;zero file offset
	XOR  DX,DX			;AN024;      "
	MOV  AL,0			;AN024;move ptr to start of file
	MOV  AH,42H			;AN024;LSEEK
	INT  21H			;AN024;
	POP  BX 			;AN024;restore length
	PUSH BX 			;AN024;save it again
	SHR  BX,1			;AN024;convert to paragraph
	SHR  BX,1			;AN024;
	SHR  BX,1			;AN024;
	SHR  BX,1			;AN024;
	INC  BX 			;AN024;ensure enough room
	MOV  AX,BX			;AN024;
					;AN024;
	POP  CX 			;AN024;restore length
	POP  BX 			;AN024;restore file handle

	MOV  DS, word [cs:inbuffer]	;AN024;get segment of read buffer
	XOR  DX,DX			;AN024;get offset to read into
	MOV  AH,3FH			;AN024;read it
	INT  21H			;AN024;
					;AN024;
	MOV  AH,3EH			;AN024;close it
	INT  21H			;AN024;
					;AN024;
	PUSH DS 			;AN024;save source segment
	MOV  ES, word [cs:outbuffer]	;AN024;
	MOV  DI, 0			;AN024;
	POP  DS 			;AN024;restore source segment
	XOR  SI,SI			;AN024;offset is zero
					;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Expand Panel file
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
					;
	MOV  DX,0			;AN024;initialize result string
EC1:	CMP  CX,0			;AN024;any characters left?
	JNE  EC2			;AN024;yes
	JMP  DONE1			;AN024;no
					;AN024;
EC2:	LODSB				;AN024;get character
	DEC  CX 			;AN024;adjust character count
	MOV  BL,1			;AN024;set default repeat
	CMP  AL,REPCHAR 		;AN024;is it a repeat character
	JNE  EC4			;AN024;no
					;AN024;
	CMP  CX,0			;AN024;any characters left?
	JNE  EC2_4			;AN024;
	JMP  DONE1			;AN024;no
					;AN024;
EC2_4:	LODSB				;AN024;get number of characters
	DEC  CX 			;AN024;Adjust character count
	CMP  AL,REPCHAR 		;AN024;is it still the repeat character
	JNE  EC2_1			;AN024;no
	JMP  EC4			;AN024;
					;AN024;
EC2_1:	CMP  AL,1			;AN024;code <CR>?
	JNE  EC2_2			;AN024;no
					;AN024;
	MOV  AL,13			;AN024;
	JMP  EC4			;AN024;
					;AN024;
EC2_2:	CMP  AL,2			;AN024;code <EOF>?
	JNE  EC3			;AN024;no
					;AN024;
	MOV  AL,26			;AN024;
	JMP  EC4			;AN024;
					;AN024;
EC3:	MOV  BL,AL			;AN024;save number of repeats
					;AN024;
	CMP  CX,0			;AN024;any characters left?
	JNE  EC3_6			;AN024;
	JMP  DONE1			;AN024;no
					;AN024;
EC3_6:	LODSB				;AN024;get actual character
	DEC  CX 			;AN024;adjust character count
	CMP  AL,REPCHAR 		;AN024;coded character?
	JNE  EC4			;AN024;no
					;AN024;
	CMP  CX,0			;AN024;any characters left?
	JNE  EC3_8			;AN024;
	JMP  DONE1			;AN024;no
					;AN024;
EC3_8:	LODSB				;AN024;yes
	DEC  CX 			;AN024;adjust character count
	CMP  AL,REPCHAR 		;AN024;coded repchar?
	JE   EC4			;AN024;yes
					;AN024;
	CMP  AL,1			;AN024;coded <CR>?
	JNE  EC3_1			;AN024;no
					;AN024;
	MOV  AL,13			;AN024;yes
	JMP  EC4			;AN024;
					;AN024;
EC3_1:	CMP  AL,2			;AN024;coded <EOF>?
	JNE  EC3_2			;AN024;no
					;AN024;
	MOV  AL,26			;AN024;
	JMP  EC4			;AN024;
					;AN024;
EC3_2:	INC  CX 			;AN024;unknown, restore
	DEC  SI 			;AN024;
	MOV  AL,REPCHAR 		;AN024;
					;AN024;
EC4:	ADD  DL,BL			;AN024;adjust length
	ADC  DH,0			;AN024;
					;AN024;
EC7:	PUSH CX 			;AN024;save CX
	XOR  CX,CX			;AN024;zero CX
	MOV  CL,BL			;AN024;set repeat number
					;AN024;
EC8:	REP  STOSB			;AN024;store char
	POP  CX 			;AN024;recover CX
	JMP  EC1			;AN024;
					;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Finished expanding panel file
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
					;
DONE1:					;AN024;

	push cs
	pop ds
	MOV  di, 0			;AN024;
	ADD  DX,16			;AN024;add paragraph to expanded length
	push dx
	mov ah, 3Ch
	xor cx, cx
	mov dx, outname
	int 21h
	jc error
	xchg bx, ax
	pop cx
	MOV  ds, word [cs:outbuffer]	;AN024;
	mov dx, di
	mov ah, 40h
	int 21h
	jc error
	push cs
	pop ds
	mov dx, msggood
	mov ah, 09h
	int 21h
	mov ax, 4C00h
	int 21h

error:
	push cs
	pop ds
	mov dx, msgbad
	mov ah, 09h
	int 21h
	mov ax, 4C01h
	int 21h

outname:	asciz "selout.dat"
msggood:	ascic "Good, content written to selout.dat",13,10
msgbad:		ascic "Bad",13,10

	absolute $
	alignb 2
inbuffer:	resw 1
outbuffer:	resw 1
stack:
		resb 512
.end:

size: equ $ - start + 256
