; assembly routines for LZSS compression (C) 1989 F. Bellard

%include "lmacros3.mac"

%ifidni BUILD, FPC
	addsection DATA, class=DATA public
group DGROUP DATA
%elifidni BUILD, TPC
	addsection DATA, public
%elifidni BUILD, DAT
	addsection DATA, public
 %assign _LONGLITERAL 1		; force enable
 %assign _4 1			; force enable
%else
 %error Invalid build selected
%endif

	numdef TEST, 0
	numdef LONGLITERAL, 0
	numdef 4, 0

; constants
BUFSIZE equ 2000h
RIEN    equ BUFSIZE*2
LENMAX  equ 253
TABSIZE equ 4096
TABAND  equ 0FFFh
%if _LONGLITERAL
LONGESTLITERAL	equ 512
%endif

TBUF		db (BUFSIZE+LENMAX+1) dup(?)
	alignb 2
RSON		dw (BUFSIZE+TABSIZE+1) dup(?)
DAD    		dw BUFSIZE+1 dup(?)
MATCHLEN 	dw ?
LENREST		dw ?
MATCHPOS 	dw ?
MATCHNPOS 	dw ?
%if _LONGLITERAL
literalbuffer	resb LONGESTLITERAL
.end:
	alignb 2
.after:		resw 1		; must be even to avoid xchg split lock !
%endif

; for the EXE
SEGSIZE     dw ?
ECART		dw ?
%if _4
indirectbufsize:	dw ?
indirectbufsizeminus:	dw ?
indirectrien:		dw ?
%endif
	extrn ECARTMAX:word
	extrn SEGMENTCHANGEDONE:byte
	extrn switch4k:byte
	extrn switchlongliteral:byte
	extrn switchtest:byte
	extrn switchcompatible:byte

CODEPTR		dw ?
MASQUE		dw ?
CODEBUF		dw ?
%if _LONGLITERAL
CODEBUF1	resb (3 + LONGESTLITERAL) * 8 + 1
%else
CODEBUF1	resb 3 * 8 + 1
%endif
	; We do now check for CODEBUF1 overflow in PutCh, but we
	;  don't want that to happen. The following commands store
	;  immediates into the CODEBUF1 here:
	;
	; Single literal: 1 bit tags, 1 byte immediate
	; Short match: 4 bit tags, 1 byte immediate
	; Medium match: 2 bit tags, 2 bytes immediate
	; Long match: 2 bit tags, 3 bytes immediate
	; Segment change: 2 bit tags, 3 bytes immediate (seldom)
	; End of stream: 2 bit tags, 3 bytes immediate (once)
	; Long literal: 2 bit tags, 3 + N bytes immediate
	;
	; So 16 tag bits can at most contain:
	;
	; 16 single literals
	; 4 short matches
	; 8 medium or long commands,
	;  or 7 medium or long commands and 1 single literal

%if 0

Example of overflowing 24 bytes (no -l):

	bytes	bits	index
	2 bits	14	0
putcodebuf	0
3 bytes			0
	2 bits	2	1
3 bytes 6		1
	2 bits	4	2
3 bytes 9		2
	2 bits	6	3
3 bytes 12		3
	2 bits	8	4
3 bytes 15		4
	2 bits	10	5
3 bytes 18		5
	2 bits	12	6
3 bytes 21		6
	2 bits	14	7
3 bytes 24		7
	1 bit	15	8
1 bytes 25		8

%endif
	;
	; Prior to the long literal support, 2 tag bits could at
	;  most encode 3 immediate bytes. The first 3 bytes can be
	;  emitted immediately after flushing the tag word. Thus
	;  we have to account for 8 3-byte commands and then the
	;  possibility of a single literal command which leaves us
	;  with 7 times 2 tag bits (the 0th command already flushed
	;  its tag bits) plus 1 tag bit, fitting in the 16-bit tag
	;  word with the last command emitting its immediate byte
	;  with 15 tag bits stored.
	; This indicates that (8 * 3) + 1 = 25 bytes were needed in
	;  the CODEBUF1. However, 128 bytes were originally used.
	;  This appears to have been an oversight.
	;
	; The long literal command allows to encode 515 bytes for
	;  every 2 tag bits, so the buffer needs to hold eight
	;  times that number plus 1 for the single-literal byte.
	;  This is what is calculated above.
.end:


; disk buffer I/O
	extrn GETBUFIN:dword
	extrn PUTBUFOUT:dword

	extrn SEGBUFIN:word
	extrn SEGBUFOUT:word
	extrn OFSBUFIN:word
	extrn OFSBUFOUT:word

    extrn BUFINSIZEM:word
   	extrn BUFOUTSIZEM:word

BUFINPTR 	dw ?
BUFOUTPTR 	dw ?
BUFINSIZE 	dw ?
BUFOUTSIZE  dw ?

; (no prior section) ; DATA ends


addsection CODE, public align=16

	assume cs:CODE,ds:DATA

	public LZCOMP


PUTBUF proc near
	push bx
	push cx
	push dx
	push si
	push di
	push es
	mov ax,[BUFOUTSIZEM]
	mov [BUFOUTSIZE],ax
	mov ax,[BUFOUTPTR]
	mov bx,[OFSBUFOUT]
	sub ax,bx
	mov [BUFOUTPTR],bx
	push ax
	call far [PUTBUFOUT]
	pop es
	pop di
	pop si
	pop dx
	pop cx
	pop bx
	ret
PUTBUF endp

GETBUF proc near
	push bx
	push cx
	push dx
	push si
	push di
	push es
	mov ax,[OFSBUFIN]
	mov [BUFINPTR],ax
	call far [GETBUFIN]
	inc ax
	mov [BUFINSIZE],ax
	dec ax
	pop es
	pop di
	pop si
	pop dx
	pop cx
	pop bx
	ret
GETBUF endp

OPENIO proc near
	mov word [BUFINSIZE],1
	mov ax,[OFSBUFOUT]
	mov [BUFOUTPTR],ax
	mov ax,[BUFOUTSIZEM]
	mov [BUFOUTSIZE],ax
	ret
OPENIO endp

CLOSEIO proc near
	call PUTBUF
	ret
CLOSEIO endp



; management of bit and byte output buffer
PutCodeBuf proc near
	push si
	push ax
	push bx

	mov si,offset CODEBUF
	mov es,[SEGBUFOUT]
PUTCODE05:
	inc word [ECART]
	lodsb
	mov BX,[BUFOUTPTR]
	inc word [BUFOUTPTR]
	mov [es:bx],al
	dec word [BUFOUTSIZE]
	jne PUTCODE10
	call PUTBUF
PUTCODE10:
	cmp si,[CODEPTR]
	jne PUTCODE05

	mov word [MASQUE],1
	and word [CODEBUF],0
	mov word [CODEPTR],offset CODEBUF1

	pop bx
	pop ax
	pop si

	ret
PutCodeBuf endp


; one-bit output
PutBit proc near
%if _LONGLITERAL
	call flush_literal_buffer
%endif
.noflush:
	test al, al
	je PUTBIT05
	mov ax,[MASQUE]
	or [CODEBUF],ax
PUTBIT05:
	shl word [MASQUE], 1
	jnz PUTBIT10
	call PutCodeBuf
PUTBIT10:
	ret
PutBit endp


		; Put the segment change command's combined word.
		;  This has to encode a zero in the 3 or 4 bit length.
		;  If not -l then all other bits are don't cares and
		;  we'll encode 0F000h for now. If -l, then all bits
		;  must be encoded as zeroes to distinguish the command.
put_segchange_combined:
	mov al, 00h
	call PutCh
	rol byte [switchcompatible], 1
	jc .zero
%if _LONGLITERAL
	rol byte [switchlongliteral], 1
	jc .zero
%endif
	mov al, 0F0h
.zero:
	jmp PutCh


		; Put the end of stream command's combined word.
		;  This has to encode a zero in the 3 or 4 bit length.
		;  As yet all other bits are don't cares and we'll
		;  encode 0F000h for now.
put_eos_combined:
	mov al, 00h
	call PutCh
	rol byte [switchcompatible], 1
	jc .zero
	mov al, 0F0h
.zero:
	jmp PutCh


%if _LONGLITERAL
		; INP:	literalbuffer -> first stored literal
		;	word [literalbuffer.after] -> behind last stored literal
		;	word [literalbuffer.after] <= literalbuffer.end
		;	 (LONGESTLITERAL literals at most)
		;	word [literalbuffer.after] == literalbuffer, if empty
		; OUT:	literals stored, either using long literals commands
		;	 or 1-byte literal commands
		;	word [literalbuffer.after] = literalbuffer
flush_literal_buffer:
	push si
	push di
	push cx
	push bx
	push ax
	mov si, literalbuffer
	mov cx, si		; reset the buffer
	xchg cx, word [literalbuffer.after]
				; cx -> behind last
	sub cx, si		; cx = amount
	jz .done		; none -->
	cmp cx, 26		; long literals command needs 26 bits
				;  (2 bits + 16 combined + 8 escaped)
	jb .loop_single		; would be shorter to encode as 1-bytes
.long:
	mov al, 0
	call PutBit.noflush	; non-literal
	mov al, 1
	call PutBit.noflush	; not short match
		; 0000h as the combined word and a trailing escape byte
		;  equal to 1 is used for segment change in -l format.
		;  The high byte 3 or 4 low bits are used for length,
		;  and must be encoded as zeroes for a long command.
		;  (Including long match and long literal.) The remaining
		;  13 or 12 bits encode what would be a distance for a
		;  medium or long match command. A value of 26 or higher
		;  with an escape byte 1 indicates a long literal command.
		; Values 1 to 25 are explicitly reserved. Values beyond
		;  512 are unused in practice as yet. (The 26 is because a
		;  long literal needs 2 + 16 + 8 bits in the compressed
		;  stream, so fewer than 26 bytes are shorter to encode as
		;  a number of single literals.)
	push cx
	xchg ax, cx
	mov cl, 3		; how many bits for length, 3 bits default
	rol byte [switch4k], 1
	adc cl, 0		; 4 bits if 4 KiB window
	shl ah, cl		; fill length bits with zeroes
	call PutCh
	mov al, ah		; get high byte
	call PutCh
	mov al, 1
	call PutCh		; following byte is 1 (segment change or
				;  long literals, distinguished by displacement)
	pop cx			; restore length of long literal command
.loop_long:
	lodsb			; load from literalbuffer
	call PutCh		; store literal
	loop .loop_long
	jmp .done

.loop_single:
	lodsb			; load from literalbuffer
	call store_single_literal
				; store literal in 9 bit single-literal command
	loop .loop_single
.done:
	pop ax
	pop bx
	pop cx
	pop di
	pop si
	retn
%endif


store_single_literal:
	push di
	push ax
	mov al, 1
	call PutBit.noflush
	pop ax
	call PutCh
	pop di
	retn

; one-byte output
PutCh proc near
	mov di,[CODEPTR]
	cmp di, CODEBUF1.end
	jae .abort
	inc word [CODEPTR]
	mov [di],al
	ret

.abort:
	mov ax, 1
	jmp ..@abort
PutCh endp

; **************************************************************************
; subroutines for compression
; **************************************************************************



; **************************************************************************
; store the byte pointed to by R in the tree
; **************************************************************************
; R=di
; S=si
;	q:=BufSize+1+byte(TBuf[r]);
;	rson[r]:=rson[q];
;	dad[rson[q]]:=r;
;	rson[q]:=r;
;	dad[r]:=q;

InsertNode proc near
	push si
	push di
	mov ax,[di+offset TBUF]
	and ax,TABAND
	shl ax,1
%if _4
	add ax, word [indirectrien]
	inc ax
	inc ax
%else
	add ax, RIEN + 2
%endif
	mov si,ax
	shl di,1
	mov bx,[si+offset RSON]
	mov [di+offset RSON],bx
	mov [bx+offset DAD],di
	mov [si+offset RSON],di
	mov [di+offset DAD],si
	pop di
	pop si
	ret
InsertNode endp


; **************************************************************************
; test the string pointed to by R with the buffer then put it in the tree
; **************************************************************************

TestMatch proc near
	push bp
	push si
	push di

	push di
	add di,offset TBUF
	mov dx,di
	inc dx
	mov bx,[di]
	and bx,TABAND
	shl bx,1
%if _4
	add bx, word [indirectrien]
	inc bx
	inc bx
%else
	add bx, RIEN + 2
%endif
	push bx
	mov ax,LENMAX-1
	push ds
	pop es
TEST05:
	mov bx,[bx+offset RSON]
%if _4
	cmp bx, word [indirectrien]
%else
	cmp bx, RIEN
%endif
	jz TEST15
	mov si,bx
	shr si,1
	add si,(offset TBUF)+1
    mov di,dx
	mov cx,LENMAX-1
    repz cmpsb
	je TEST10
	cmp cx,ax
	jae TEST05
	mov bp,bx
	mov ax,cx
	jmp TEST05
TEST10:
	mov bp,bx
	mov ax,0FFFFh
TEST15:
	pop si
	pop di
	shl di,1
; calcul de matchlen
	mov cx,LENMAX
	sub cx,ax
	dec cx
	mov [MATCHLEN],cx
; calcul de matchpos
	mov ax,di
	sub ax,bp
	shr ax,1
BufSize equ BUFSIZE	; NASM port equate
%if _4
	and ax, word [indirectbufsizeminus]
%else
	and ax, BUFSIZE - 1
%endif
	mov [MATCHPOS],ax
	not ax
	inc ax
	mov [MATCHNPOS],ax

; insertion du noeud
	mov bx,[si+offset RSON]
	mov [di+offset RSON],bx
	mov [bx+offset DAD],di
	mov [si+offset RSON],di
	mov [di+offset DAD],si
; fin
	pop di
	pop si
	pop bp
	ret
TestMatch endp


; **************************************************************************
; delete a node in SI
; **************************************************************************
;procedure DeleteNode(p:word);
;var q:word;
;begin
;	if dad[p]=Rien then exit;
;	rson[dad[p]]:=rson[p];
;	dad[rson[p]]:=dad[p];
;	dad[p]:=rien;
;end;

DeleteNode proc near
	shl si,1
	mov bx,[si+offset DAD]
%if _4
	push ax
	mov ax, word [indirectrien]
	cmp bx, ax
	je DEL90
	mov word [bx+offset RSON], ax
	mov word [si+offset DAD], ax
DEL90:
	pop ax
%else
	cmp bx, RIEN
	je DEL90
	mov word [bx+offset RSON], RIEN
	mov word [si+offset DAD], RIEN
DEL90:
%endif
	shr si,1
	ret
DeleteNode endp



; **************************************************************************
; main compression program
; **************************************************************************

LZCOMP proc far
	push bp
	mov bp,sp

	rol byte [switch4k], 1
	jnc .8k
.4k:
%if _4
	mov word [indirectbufsize], 4096
	mov word [indirectbufsizeminus], 4096 - 1
	mov word [indirectrien], 4096 * 2
	jmp .common

.8k:
	mov word [indirectbufsize], BUFSIZE
	mov word [indirectbufsizeminus], BUFSIZE - 1
	mov word [indirectrien], RIEN
%else
	mov ax, 3
	jmp ..@abort

.8k:
%endif

.common:
	push ds
	pop es

	call OPENIO

%if _4
	mov cx, word [indirectbufsize]
	mov ax, word [indirectrien]
%else
	mov cx, BUFSIZE
	mov ax, RIEN
%endif
	mov di,offset DAD
	rep stosw

%if _4
	mov cx, word [indirectbufsize]
	add cx, TABSIZE + 1
%else
	mov cx, BUFSIZE + TABSIZE + 1
%endif
	mov di,offset RSON
	rep stosw

	mov di,offset TBUF
LenMax equ LENMAX	; NASM port equate
%if _4
	mov cx, word [indirectbufsize]
	add cx, LenMax - 1
%else
	mov cx, BUFSIZE + LenMax - 1
%endif
	mov al,00h
	rep stosb

%ifn _LONGLITERAL
	mov ax, 2
	rol byte [switchlongliteral], 1
	jc ..@abort
%endif

; codebuf
	mov word [MASQUE],1
	mov word [CODEPTR],offset CODEBUF1
	xor ax,ax
	mov [CODEBUF],ax
	mov [SEGSIZE],ax
	mov [ECART],ax
	mov [ECARTMAX],ax
%if _LONGLITERAL
	mov word [literalbuffer.after], literalbuffer
%endif
%if _TEST
	mov word [nexttest], testtable
%endif

; reading the first bytes
%if _4
	mov di, word [indirectbufsize]
	add di, (offset TBUF) - LENMAX
%else
	mov di, BUFSIZE + (offset TBUF) - LENMAX
%endif
	mov cx,LENMAX
	mov es,[SEGBUFIN]
S3A0F:
	dec word [BUFINSIZE]
	jnz S3A24
	call GETBUF
	test ax, ax
	jz S3A2E
	jmp S3A0F
S3A24:
	mov BX,[BUFINPTR]
	inc word [BUFINPTR]
	mov al,[es:BX]
	mov [di],al
	inc di
	loop S3A0F

S3A2E:
	mov AX,LENMAX
	sub AX,CX
	mov [LENREST],AX

%if _4
	mov di, word [indirectbufsize]
	add di, - LENMAX
%else
	mov di, BUFSIZE - LENMAX
%endif
	xor SI,SI
TESTMATCH equ TestMatch	; NASM port label
	call TESTMATCH



; compression loop

S3A55:
%if _TEST
testloop:
	rol byte [switchtest], 1
	jnc testdone
	push si
	push bx
	mov si, [nexttest]
	cs lodsw
	xchg bx, ax
	cs lodsw
	push ax
	cs lodsw
	mov word [nexttest], si
	pop si
	jmp si
testnext:
	pop bx
	pop si
	jc testloop
	jmp testdone

	align 2
testtable:
	dw skiptest
	dw settestword_CY
	dw 8192

	dw skiptest
	dw testdecrement
	dw 1

	dw 0
	dw testbp
	dw 0

	dw MATCHLEN
	dw iftag_NC
	dw 1

.1:	dw counttest
	dw settestword_CY
	dw LONGESTLITERAL

	dw MATCHLEN
	dw settestwordloop_NC
	dw 1

.2:	dw counttest
	dw settestword_CY
	dw LONGESTLITERAL

	dw MATCHLEN
	dw settestwordloop_NC
	dw 1

.3:	dw counttest
	dw settestword_CY
	dw LONGESTLITERAL

	dw MATCHLEN
	dw settestwordloop_NC
	dw 1

.4:	dw counttest
	dw settestword_CY
	dw LONGESTLITERAL

	dw MATCHLEN
	dw settestwordloop_NC
	dw 1

.5:	dw counttest
	dw settestword_CY
	dw LONGESTLITERAL

	dw MATCHLEN
	dw settestwordloop_NC
	dw 1

.6:	dw counttest
	dw settestword_CY
	dw LONGESTLITERAL

	dw MATCHLEN
	dw settestwordloop_NC
	dw 1

.7:	dw counttest
	dw settestword_CY
	dw LONGESTLITERAL

	dw MATCHLEN
	dw settestwordloop_NC
	dw 1

	dw 0
	dw testbp
	dw 0

.8:	dw counttest
	dw settestword_CY
	dw LONGESTLITERAL

	dw MATCHLEN
	dw settestwordloop_NC
	dw 1

.9:	dw counttest
	dw settestword_CY
	dw 1

	dw MATCHLEN
	dw settestwordloop_NC
	dw 1

	dw MATCHLEN
	dw settestword_NC
	dw 32

	dw 0
	dw testbp
	dw 0

	dw switchtest
	dw settestbyte_CY
	dw 0

settestword_CY:
	mov word [bx], ax
	stc
	jmp testnext

settestwordloop_NC:
	dec word [counttest]
	js testnext_CY
	sub word [nexttest], 6

settestword_NC:
	mov word [bx], ax
	clc
	jmp testnext

settestbyte_CY:
	mov byte [bx], al
testnext_CY:
	stc
	jmp testnext

settestbyte_NC:
	mov byte [bx], al
testnext_NC:
	clc
	jmp testnext

iftag_NC:
	cmp word [MASQUE], 4000h
	je testnext_CY
	mov word [bx], ax
	sub word [nexttest], 6
	jmp testnext_NC

testbp:
	int3
	stc
	jmp testnext

usesection DATA
	alignb 2
nexttest:	resw 1
skiptest:	resw 1
counttest:	resw 1

usesection CODE

testdecrement:
	sub word [bx], ax
	jnz @F
	stc
	jmp testnext
@@:
	sub word [nexttest], 6
	pop bx
	pop si
testdone:
%endif

	mov ax,[MATCHLEN]
	cmp ax,[LENREST]
	jle S3A67
	mov ax,[LENREST]
	mov [MATCHLEN],ax

S3A67:
	push SI
	push DI
	cmp ax,2
	jb LB26
	ja L30
MatchPos equ MATCHPOS	; NASM port label
	cmp word [MatchPos],256
	jb L30
LB26:
; copy the uncoded literal byte
MatchLen equ MATCHLEN	; NASM port label
	mov word [MatchLen],1

%if _LONGLITERAL
	rol byte [switchlongliteral], 1
	jc .storelong
%endif
	mov al,[di+offset TBUF]
	call store_single_literal
	jmp L35

%if _LONGLITERAL
.storelong:
	push bx
.reload:
	mov bx, [literalbuffer.after]	; -> next literal slot
	cmp bx, literalbuffer.end	; no more space ?
	jb .spaceleft			; no -->
	call flush_literal_buffer	; yes, emit maximum length long literal
	jmp .reload			; reload bx after
.spaceleft:
	mov al, [di+offset TBUF]	; get byte
	mov byte [bx], al		; store in buffer
	inc word [literalbuffer.after]	; poiny past stored byte
	pop bx
	jmp L35
%endif

L30:
	mov al, 0
	call PutBit		; non-literal

	cmp word [MatchLen],5
	ja LA05
	cmp word [MATCHPOS],256
	jae LA05
; matchpos with 1 byte
	mov al,0
	call PutBit		; short match
	mov ax,[MatchLen]
	dec ax
	dec ax
	push ax
	and al,2
	call PutBit		; high bit
	pop ax
	and al,1
	call PutBit		; low bit
MatchNpos equ MATCHNPOS	; NASM port label
	mov ax,[MatchNpos]
	call PutCh		; distance byte
	jmp L35
LA05:
	mov al,1
	call PutBit		; not short match
	mov ax,[MATCHNPOS]
	call PutCh		; low byte of distance (part of combined word)
	mov al,ah		; high 5/4 bits of distance
	mov cl,3
%if _4
	rol byte [switch4k], 1
	adc cl, 0		; shift by 4 if 4 KiB window
%endif
	shl al,cl		; shift up the high bits, low bits = all-0s
	mov bx,[MatchLen]	; bx = length
%if _4
	rol byte [switch4k], 1
	jnc .8k
.4k:
	cmp bx, 17		; can encode 1..15 meaning length 3..17
	jmp .common
.8k:
%endif
	cmp bx, 9		; can encode 1..7 meaning length 3..9
.common:
	ja LA10
	dec bx
	dec bx			; get value to encode
	or al,bl		; set low bits (NZ), 1..15 or 1..7
	call PutCh		; high byte of combined word
	jmp L35
LA10:
	call PutCh		; high byte of combined word, with low bits all-0s
	mov ax,bx
	dec ax			; 3..256 to 2..255
	call PutCh		; following byte is >= 2 (long match)
L35:
	mov ax,[MATCHLEN]

; for the difference between the 2 codes
	sub [ECART],ax
	jge L36
L37:
	inc word [ECARTMAX]
	add word [ECART],16
	cmp word [ECART],0
	jl L37
L36:

; for the segmentation
	add [SEGSIZE], ax
	cmp word [SEGSIZE], 0A000h
	jb L40
	mov byte [SEGMENTCHANGEDONE], 0FFh
	mov al,0
	call PutBit		; non-literal
	mov al,1
	call PutBit		; not short match
	call put_segchange_combined
				; combined word with length = 0 (escape)
	mov al,1
	call PutCh		; following byte is 1 (segment change or
				;  long literals, distinguished by displacement)
	and word [SEGSIZE], 0
L40:
	pop DI
	pop SI


; reading the following bytes
	mov es,[SEGBUFIN]
	jmp near S3AA0
S3A9D:
INSERTNODE equ InsertNode	; NASM port label
	call INSERTNODE
S3AA0:
DELETENODE equ DeleteNode	; NASM port label
	call DELETENODE

S3ABA:
	dec word [BUFINSIZE]
	jne S3ABB
	call GETBUF
	or ax,ax
	je S3ACE
	jmp S3ABA
S3ABB:
	mov bx,[BUFINPTR]
	inc word [BUFINPTR]
	mov al,[es:BX]
	mov [SI+offset TBUF],AL
	cmp SI,LENMAX-1
	jnb S3ACC
%if _4
	push bx
	mov bx, word [indirectbufsize]
	mov [SI + (offset TBUF) + bx], al
	pop bx
%else
	mov [SI + (offset TBUF) + BUFSIZE], al
%endif
S3ACC:
	jmp near S3AD2
S3ACE:
	dec word [LENREST]
S3AD2:
	inc SI
	inc DI
%if _4
	and si, word [indirectbufsizeminus]
	and di, word [indirectbufsizeminus]
%else
	and si, BUFSIZE - 1
	and di, BUFSIZE - 1
%endif
	dec word [MATCHLEN]
	jnz S3A9D
	call TESTMATCH
	cmp word [LENREST],0
	jle S3AEF
	jmp S3A55

S3AEF:

 mov al,0			; non-literal
 call PutBit
 mov al,1			; not short match
 call PutBit
 call put_eos_combined		; combined word with length = 0 (escape)
 mov al,0
 call PutCh			; following byte is 0 (end of stream)

 call PutCodeBuf

	call CLOSEIO

	xor ax, ax
..@abort:
	mov sp, bp
	pop bp
	ret

LZCOMP endp


; (no prior section) ; CODE ends

end
