
%if 0

LZEXE data file packer/depacker
 by E. C. Masloch, 2008--2025

Usage of the works is permitted provided that this
instrument is retained with the works, so that any entity
that uses the works is notified of this instrument.

DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.

Links to the LZEXE packer, which is under separate
usage conditions (MIT license). Refer to LICENSE file.

%endif

%include "lmacros3.mac"

	cpu 8086

	addsection CODE, PUBLIC align=2
	addsection DATA, PUBLIC align=4
		align 2
table:
	dw msg.done.1
	dw insize
	dw disp_dxax_hex
	dw disp_dxax_dec

	dw msg.done.2
	dw outsize
	dw disp_dxax_hex
	dw disp_dxax_dec

	dw msg.done.3
	dw lzsize
	dw disp_dxax_hex
	dw disp_dxax_dec

	dw msg.done.4
	dw ECARTMAX
	dw disp_ax_hex
	dw disp_ax_dec

	dw msg.done.5
	dw ecartmax_bytes
	dw disp_dxax_hex
	dw disp_dxax_dec

	dw 0


		align 2
table_d:
	dw msg.done.1
	dw insize
	dw disp_dxax_hex
	dw disp_dxax_dec

	dw msg.done.2
	dw outsize
	dw disp_dxax_hex
	dw disp_dxax_dec

	dw 0


msg:
.done:		counted "Done.",13,10
.done.1:	counted "Input size:        "
.done.2:	counted "Output size:       "
.done.3:	counted "LZ size:           "
.done.4:	counted "ECARTMAX:          "
.done.5:	counted "ECARTMAX in bytes: "
.done.6:	counted "Percentage remain: "
.short.1:	counted "Input size: "
.short.2:	counted ", output size: "
.short.3:	counted ", "
.linebreak:	counted 13,10
.percentage_overflow:
		counted "Too large percentage!",13,10

.invalidswitch:	db @F - ($ + 1)
		db "Error: Invalid switch ",'"'
.invalidswitch.letter:
		db 'x"!',13,10
@@:
.toomanyfiles:	counted "Error: Too many files specified!",13,10
.quotedeol:	counted "Error: Missing closing quote mark!",13,10
.noinfile:	counted "Error: No input file specified!",13,10
.nooutfile:	counted "Error: No output file specified!",13,10
.noheatshrink:	counted "Error: Heatshrink only supported for depacking!",13,10
.infileerror:	db @F - ($ + 1)
		db "Error: Input file open, seek, or read error "
.infileerror.code:
		db "----h!",13,10
@@:
.outfileerror:	db @F - ($ + 1)
		db "Error: Output file open or write error "
.outfileerror.code:
		db "----h!",13,10
@@:
.infileshort:	counted "Error: Short read from input file!",13,10
.outfileshort:	counted "Error: Short write to output file! (Disk full?)",13,10
.compresserror:	counted "Error: Compression error!",13,10
.decompresserror:	counted "Error: Decompression error!",13,10


	alignb 4
lzsize:		dd 0
	global GETBUFIN, PUTBUFOUT, ECARTMAX
GETBUFIN:	dw getbuf, CODE
PUTBUFOUT:	dw putbuf, CODE
psp:		dw 0
ECARTMAX:	dw 0
	global SEGBUFIN, SEGBUFOUT, OFSBUFIN, OFSBUFOUT
OFSBUFIN:	dw bufferin
SEGBUFIN:	dw BUFFER
OFSBUFOUT:	dw bufferout
SEGBUFOUT:	dw BUFFER

	global BUFINSIZEM, BUFOUTSIZEM
BUFINSIZEM:	dw bufferinsize
BUFOUTSIZEM:	dw bufferoutsize

	align 2
nextfile:	dw infile
infile:		dw 0
outfile:	dw 0
nomorefile:
switch:		db '-'
verbose:	db 0
exceptional:	db 0
	global SEGMENTCHANGEDONE, switch4k, switchlongliteral, switchtest
	global switchcompatible
SEGMENTCHANGEDONE:	db 0
switch4k:		db 0
switchlongliteral:	db 0
switchtest:		db 0
switchcompatible:	db 0
switchdepack:		db 0
switchheatshrink:	db 0

	; absolute $
	alignb 4
insize:		resd 1		; must be aligned to avoid xchg split lock
codesize:	resd 1
outsize:	resd 1		; must be aligned to avoid xchg split lock
ecartmax_bytes:	resd 1
inhandle:	resw 1
outhandle:	resw 1
format:		resw 1

	addsection BUFFER, align=16

	alignb 16
resultbuffer:
.size: equ 8192
bufferinsize: equ 4096
bufferin:	resb bufferinsize
bufferoutsize: equ 4096
bufferout:	resb bufferoutsize
	_fill resultbuffer.size, ?, resultbuffer
resultbuffer.end:


	addsection STACK, stack align=2
		resb 512

	usesection CODE


		; pascal calling convention:
		; parameters pushed in order of appearance
		; function cleans away the parameters
		; ax, bx, cx, dx, si, di, es may be changed
		; ds => DATA
putbuf:
	lframe far
	lpar word, size
	lenter
	mov bx, [outhandle]
	mov dx, bufferout
	mov cx, word [bp + ?size]
	xor ax, ax
	jcxz .ret
	push ds
	mov ax, BUFFER
	mov ds, ax
	mov ah, 40h
	int 21h
	pop ds
	jc .errorwrite
	cmp ax, cx
	jne .shortwrite
	add word [lzsize], ax
	adc word [lzsize + 2], 0
.ret:
	xor ax, ax
	lleave
	lret

.shortwrite:
	mov dx, msg.outfileshort
	call disp_msg_counted
	mov ax, 4C09h
	int 21h

.errorwrite:
	jmp openoutfile.error


getbuf:
	lframe far
	lframe_needonlyregistered
	lenter

	mov bx, [inhandle]
	mov dx, bufferin

	mov cx, bufferinsize
	cmp word [codesize + 2], 0
	jne .got
	cmp word [codesize], cx
	jae .got
	mov cx, word [codesize]
.got:
	push ds
	mov ax, BUFFER
	mov ds, ax
	mov ah, 3Fh
	int 21h
	pop ds
	jc .errorread
	cmp ax, cx
	jne .shortread

	sub word [codesize], ax
	sbb word [codesize + 2], 0
	lleave
	lret

.shortread:
	mov di, DATA
	mov ds, di
	mov dx, msg.infileshort
	call disp_msg_counted
	mov ax, 4C07h
	int 21h

.errorread:
	jmp openinfile.error


..start:
	mov ax, DATA
	mov es, ax
	mov word [es:psp], ds

	mov si, 81h
cmdloop:
	lodsb
.al:
	cmp al, 9
	je cmdloop
	cmp al, 32
	je cmdloop
	cmp al, 13
	jbe cmdend
	cmp al, [es:switch]
	jne .filename
	lodsb
	call cap
	cmp al, '-'
	jne @F
	mov byte [es:switch], 0
	jmp cmdloop

@@:
	cmp al, 'V'
	jne @F
	mov byte [es:verbose], 0FFh
	jmp cmdloop

@@:
	cmp al, 'E'
	jne @F
	mov byte [es:exceptional], 0FFh
	jmp cmdloop

@@:
	cmp al, 'B'
	jne @F
	mov byte [cs:..@breakpoint], 0CCh
	mov byte [cs:..@breakpoint_d], 0CCh
	jmp cmdloop

@@:
	cmp al, '4'
	jne @F
	mov byte [es:switch4k], 0FFh
	jmp cmdloop

@@:
	cmp al, 'L'
	jne @F
	mov byte [es:switchlongliteral], 0FFh
	jmp cmdloop
@@:

	cmp al, 'T'
	jne @F
	mov byte [es:switchtest], 0FFh
	jmp cmdloop

@@:

	cmp al, 'C'
	jne @F
	mov byte [es:switchcompatible], 0FFh
	jmp cmdloop

@@:
	cmp al, 'D'
	jne @F
	mov byte [es:switchdepack], 0FFh
	jmp cmdloop

@@:
	cmp al, 'H'
	jne @F
	mov byte [es:switchheatshrink], 0FFh
	jmp cmdloop

@@:
.invalidswitch:
	push es
	pop ds
	mov byte [msg.invalidswitch.letter], al
	mov dx, msg.invalidswitch
	call disp_msg_counted
	mov ax, 4C02h
	int 21h

.filename:
	mov bx, [es:nextfile]
	cmp bx, nomorefile
	jb @F
	push es
	pop ds
	mov dx, msg.toomanyfiles
	call disp_msg_counted
	mov ax, 4C03h
	int 21h

@@:
	add word [es:nextfile], 2
	dec si
	mov di, si
	mov word [es:bx], si
	mov ah, 0
.fileloop:
	lodsb
	cmp al, '"'
	jne @F
	not ah
	jmp .fileloop

@@:
	cmp ax, 32
	je .fileend
	cmp ax, 9
	je .fileend
	cmp ax, 0FF00h + 13
	jne @F
	push es
	pop ds
	mov dx, msg.quotedeol
	call disp_msg_counted
	mov ax, 4C04h
	int 21h

@@:
	cmp al, 13
	jbe .fileend

	mov byte [di], al
	inc di
	jmp .fileloop

.fileend:
	push ax
	mov al, 0
	mov byte [di], al
	inc di
	pop ax
	jmp cmdloop.al

cmdend:
	rol byte [es:switchdepack], 1
	jnc .pack
	mov ax, 2			; 2 = heatshrink
	rol byte [es:switchheatshrink], 1
	jc @F
	mov ah, byte [es:switch4k]	; ah = switch4k
	inc ax				; 3 = lzexedat no -l
	rol byte [es:switchlongliteral], 1
	jnc @F
	inc ax				; 4 = lzexedat -l
@@:
	mov word [es:format], ax
	jmp @F

.pack:
	rol byte [es:switchheatshrink], 1
	jnc @F
	push es
	pop ds
	mov dx, msg.noheatshrink
	call disp_msg_counted
	mov ax, 4C05h
	int 21h
@@:

openinfile:
	mov si, word [es:infile]
	test si, si
	jnz @F
	push es
	pop ds
	mov dx, msg.noinfile
	call disp_msg_counted
	mov ax, 4C05h
	int 21h

@@:
	mov ax, 716Ch
	xor cx, cx
	xor di, di
	mov dx, 1		; open existing file
	mov bx, 0_01_00_000_1_010_0_000b
				; no int 24h, no inherit, deny write, read-only
	stc
	int 21h
	jnc gotinfile
	cmp ax, 7100h
	je @F
	cmp ax, 1
	jne .error
@@:
	mov ax, 6C00h
	stc
	int 21h
	jnc gotinfile
	cmp ax, 6C00h
	je @F
	cmp ax, 1
	jne .error
@@:
	xchg ax, bx
	mov ah, 3Dh
	int 21h
	jnc gotinfile
.error:
	mov di, DATA
	mov ds, di
	mov es, di
	mov di, msg.infileerror.code
	call store_hex_word
	mov dx, msg.infileerror
	call disp_msg_counted
	mov ax, 4C05h
	int 21h

gotinfile:
	push es
	pop ds
	mov word [inhandle], ax
	xchg bx, ax
	mov ax, 4202h
	xor cx, cx
	xor dx, dx
	int 21h
	jc openinfile.error

	mov word [insize], ax
	mov word [insize + 2], dx
	mov word [codesize], ax
	mov word [codesize + 2], dx

	mov ax, 4200h
	xor cx, cx
	xor dx, dx
	int 21h
	jc openinfile.error


openoutfile:
	mov si, word [outfile]
	test si, si
	jnz @F
	mov dx, msg.nooutfile
	call disp_msg_counted
	mov ax, 4C05h
	int 21h

@@:
	mov ds, word [psp]
	mov ax, 716Ch
	xor cx, cx
	xor di, di
	mov dx, 12h		; create or truncate file
	mov bx, 0_01_00_000_1_010_0_001b
				; no int 24h, no inherit, deny write, write-only
	stc
	int 21h
	jnc gotoutfile
	cmp ax, 7100h
	je @F
	cmp ax, 1
	jne .error
@@:
	mov ax, 6C00h
	stc
	int 21h
	jnc gotoutfile
	cmp ax, 6C00h
	je @F
	cmp ax, 1
	jne .error
@@:
	xchg ax, bx
	mov ah, 3Ch
	int 21h
	jnc gotoutfile
.error:
	mov di, DATA
	mov ds, di
	mov es, di
	mov di, msg.outfileerror.code
	call store_hex_word
	mov dx, msg.outfileerror
	call disp_msg_counted
	mov ax, 4C08h
	int 21h

gotoutfile:
	push es
	pop ds
	mov word [outhandle], ax

	rol byte [es:switchdepack], 1
	jc datexe_depack

..@breakpoint:
	nop

extern LZCOMP
	call far LZCOMP

	test ax, ax
	jz @F
	mov dx, msg.compresserror
	call disp_msg_counted
	mov ax, 4C0Ah
	int 21h
@@:

	mov bx, word [outhandle]
	mov ax, 4202h
	xor cx, cx
	xor dx, dx
	int 21h
	jc openoutfile.error
	mov word [outsize], ax
	mov word [outsize + 2], dx

	mov ax, [ECARTMAX]
	xor dx, dx
	mov cx, 4
@@:
	add ax, ax
	adc dx, dx
	loop @B
	mov word [ecartmax_bytes], ax
	mov word [ecartmax_bytes + 2], dx

	rol byte [verbose], 1
	jc display_table
display_short:
	mov dx, msg.short.1
	call disp_msg_counted
	mov ax, word [insize]
	mov dx, word [insize + 2]
	call disp_dxax_dec
	mov dx, msg.short.2
	call disp_msg_counted
	mov ax, word [outsize]
	mov dx, word [outsize + 2]
	call disp_dxax_dec
	mov dx, msg.short.3
	call disp_msg_counted
	call disp_percentage
	mov ax, 4C00h
	int 21h


display_table:
	mov si, table
.loop:
	lodsw
	test ax, ax
	jz .done
	xchg dx, ax
	call disp_msg_counted
	lodsw
	xchg bx, ax
	mov cx, [bx]
	mov dx, [bx + 2]
	lodsw
	xchg cx, ax
	call cx
	xchg cx, ax
	mov al, 32
	call disp_al
	lodsw
	xchg cx, ax
	call cx
	mov dx, msg.linebreak
	call disp_msg_counted
	jmp .loop

.done:
	mov dx, msg.done.6
	call disp_msg_counted
	call disp_percentage
	mov dx, msg.done
	call disp_msg_counted
	mov ax, 4C00h
	int 21h


disp_percentage_swapped:
	mov ax, word [insize + 2]
	xchg ax, word [outsize + 2]
	mov word [insize + 2], ax

	mov ax, word [insize]
	xchg ax, word [outsize]
	mov word [insize], ax

disp_percentage:
	lframe
	lenter
	lvar 6, multiple

	mov cx, 10000
	mov ax, word [outsize + 2]
	mul cx
	 push dx
	 push ax
	mov ax, word [outsize]
	mul cx
	 push ax
	add word [bp + ?multiple + 2], dx
	adc word [bp + ?multiple + 4], 0

	xor bx, bx
	lvar 4, high
	 push bx
	 push bx

.difficultdiv16:		; code adapted from Art of Assembly chapter 9
				; refer to http://www.plantation-productions.com/Webster/www.artofasm.com/DOS/ch09/CH09-4.html#HEADING4-99
	mov cx, 48
	mov ax, word [insize]
	mov dx, word [insize + 2]

.bitloop:
	shl word [bp + ?multiple], 1
	rcl word [bp + ?multiple + 2], 1
	rcl word [bp + ?multiple + 4], 1
	rcl word [bp + ?high], 1
	rcl word [bp + ?high + 2], 1
	; rcl word [bp + ?high + 4], 1	; << 1

	; cmp word [bp + ?high + 4], 0
	; jne @F
	cmp word [bp + ?high + 2], dx
	jne @F
	cmp word [bp + ?high], ax
				; does the divisor fit into high here ?
@@:
	jb .trynext		; no -->
.goesinto:
	sub word [bp + ?high], ax
	sbb word [bp + ?high + 2], dx
				; subtract divisor
	inc byte [bp + ?multiple]
		; set a bit of the result (bit was zero before, never carries)
.trynext:
	loop .bitloop		; loop for 48 bits

	mov cx, 100
	xor dx, dx
	mov ax, [bp + ?multiple + 4]
	div cx
	mov [bp + ?multiple + 4], ax
	mov ax, [bp + ?multiple + 2]
	div cx
	mov [bp + ?multiple + 2], ax
	mov ax, [bp + ?multiple]
	div cx
	mov [bp + ?multiple], ax
		; dx = mod, ?multiple = div
	push dx
	cmp word [bp + ?multiple + 4], 0
	je @F
	mov dx, msg.percentage_overflow
	call disp_msg_counted
	jmp .end
@@:
	mov dx, word [bp + ?multiple + 2]
	mov ax, word [bp + ?multiple]
	call disp_dxax_dec

	mov al, '.'
	call disp_al
	pop ax
	xor dx, dx
	cmp al, 10
	jae @F
	push ax
	mov al, '0'
	call disp_al
	pop ax
@@:
	call disp_dxax_dec

	mov al, '%'
	call disp_al
	mov al, 13
	call disp_al
	mov al, 10
	call disp_al
.end:
	lleave
	retn


cap:
	cmp al, 'a'
	jb .ret
	cmp al, 'z'
	ja .ret
	xor al, 20h
.ret:
	retn


disp_msg_counted:
	push ax
	push bx
	push cx
	push dx
	xor cx, cx
	mov bx, dx
	inc dx
	mov cl, [bx]
	mov bx, 1
	mov ah, 40h
	int 21h
	pop dx
	pop cx
	pop bx
	pop ax
	retn


store_hex_word:
	xchg al, ah
	call store_hex_byte
	xchg al, ah

store_hex_byte:
	push cx
	mov cl, 4
	rol al, cl
	call store_hex_nybble
	rol al, cl
	pop cx

store_hex_nybble:
	push ax
	and al, 15
	add al, '0'
	cmp al, '9'
	jbe @F
	add al, - ('9' + 1) + 'A'
@@:
	stosb
	pop ax
	retn


disp_error.loop:
	call disp_al
disp_error:
	lodsb
	test al, al
	jnz .loop
	retn

%if 1
disp_ax_dec:
	xor dx, dx

disp_dxax_dec:
	lframe near
	lequ 10, buffersize
	lvar ?buffersize, buffer
	lenter
	lvar dword, dividend
	 push dx
	 push ax
	push dx
	push ax
	push bx
	push cx
	push es
	push di
	push si
	 push ss
	 pop es
	lea di, [bp + ?buffer + ?buffersize - 1]
	std
.loopouter:
	mov cx, 10
	mov si, 2
	xor bx, bx
	xor dx, dx
.loopinner:
	mov ax, [bp + ?dividend + si]
	div cx
	or bx, ax
	mov word [bp + ?dividend + si], ax
	dec si
	dec si
	jns .loopinner
	xchg ax, dx
	add al, '0'
	stosb
	test bx, bx
	jnz .loopouter
	cld

	mov dx, di
	inc dx
	lea cx, [bp + ?buffer + ?buffersize]
	sub cx, dx
	inc bx		; = 1
	 push ds
	  push ss
	  pop ds
	mov ah, 40h
	int 21h
	 pop ds

	pop si
	pop di
	pop es
	pop cx
	pop bx
	pop ax
	pop dx
	lleave
	lret


disp_dxax_hex:
		xchg ax, dx
		call disp_ax_hex
		xchg ax, dx
disp_ax_hex:			; ax
		xchg al,ah
		call disp_al_hex		; display former ah
		xchg al,ah			;  and fall trough for al
disp_al_hex:			; al
		push cx
		mov cl,4
		ror al,cl
		call disp_al_lownibble_hex	; display former high-nibble
		rol al,cl
		pop cx
						;  and fall trough for low-nibble
disp_al_lownibble_hex:
		push ax			 ; save ax for call return
		and al,00001111b		; high nibble must be zero
		add al,'0'			; if number is 0-9, now it's the correct character
		cmp al,'9'
		jna .decimalnum		 ; if we get decimal number with this, ok -->
		add al,7			;  otherwise, add 7 and we are inside our alphabet
 .decimalnum:
		call disp_al
		pop ax
		retn
%endif


disp_al_for_progress:
disp_al:
	push ax
	push dx

	xchg dx, ax				; dl = input al
	mov ah, 02h
	int 21h
	pop dx
	pop ax
.retn:
disp_error.ret:
	retn


 %assign _LZEXEDAT	1
 %assign _LONGLITERAL	1
 %assign _MULTI		1
 %assign _STANDALONE	1
 %assign _DATEXE	1
	addsection BSSDATA, nobits
%include "depack.asm"
