
; Depacker for LZEXE compressed executable
; Copyright (C) 1989 Fabrice Bellard
; Ported to NASM and extended by E. C. Masloch, 2025
; Under MIT license, refer to LICENSE file

%include "lmacros3.mac"

section CODE PUBLIC

%define STARTCS  word [patchcsip + 2 - EXEPACK]

; macro to take a bit
%imacro GETBITMACRO 0
 shr bp,1			; CY if bit set, NC if bit clear
 dec dx				; 0 if out of bits now
 jnz %%L01			; not yet out of bits -->
 lodsw				; load new word of bits
 xchg bp,ax			; bp = new word of bits, clobber ax
 mov dl,16			; dx = 16 bits left in this word
%%L01:
%endmacro

%ifndef NOINLINE
 %define dogetbit getbitmacro
%else
 %define dogetbit call getbitfunction
%endif

DEPACKER2:
EXEPACK:

entry:
 push ax			; preserve ax input from DOS loader
 push es			; save the PSP segment
 push cs
 pop ds				; => depacker
 mov cx, 0			; = depacker length
lenprog: equ $ - 2
				; byte length of the depacker (including relocations)
 mov si,cx			; -> behind depacker
 dec si				; -> last byte of depacker
 mov di,si			; (same)
 mov bx,ds
 add bx, strict word 0		; => destination for relocating depacker
decalage: equ $ - 2		; how far to relocate the depacker in paragraphs
				;  (packed data is moved to below this)
 mov es,bx			; es:di -> last byte of destination
 std				; move downwards (DN)
 rep movsb			; relocate depacker
 push bx			; => relocated entrypoint
 call retf_instruction

SUITE:
; relocate the packed data to top of our allocation
	; ds => at depacker source (behind packed data)
	; es = cs = bx => at depacker destination (behind data allocation)
 mov bp, 0			; bp = length in paragraphs
lenlz: equ $ - 2		; paragraph length of the packed data
 mov dx,ds			; => at depacker
DEPL10:
 mov ax,bp			; ax = how much to relocate this iteration
 cmp ax,1000h			; more than 64 KiB ?
 jbe DEPL05			; no -->
 mov ax,1000h			; limit to 64 KiB per iteration
DEPL05:
 sub bp,ax			; decrease remaining counter
 sub dx,ax			; => at current chunk of source data
 sub bx,ax			; => at current chunk's destination
 mov ds,dx
 mov es,bx
 mov cl,3
 shl ax,cl			; = how many words in this chunk
 mov cx,ax			; counter for string move operation
 dec ax				; = how many words minus 1
 shl ax,1			; -> at last word of data
 mov si,ax
 xchg di,ax			; set up indices for string move operation
				;  (clobbers ax)
 rep movsw			; move data chunk (still DN)
 test bp,bp			; any data left ?
 jnz DEPL10			; yes, so loop -->


; start of unpacking
 cld
 mov es,dx			; => destination for depacked image
 mov ds,bx			; => source of packed data
 xor si,si
 xor di,di
 mov dx,16			; init bit counter
 lodsw				; get first word of bits
 xchg bp,ax			; bp = word of bits

 db __TEST_IMM8			; skip movsb
moveliteral:
 movsb

DECOMP10:
 dogetbit			; get bit indicating a literal (1)
				;  or match or other (0)
%if 0
 jnc DECOMP20			; 0 so a match or other -->
; for testing
; lodsb
; mov ah,0
; cs sub CRC2,ax
; cs inc SIZE
; stosb
 movsb				; move a literal byte
 jmp DECOMP10			; back to main loop -->
%else
 jc moveliteral
%endif

; reading from the buffer window
DECOMP20:
 xor cx,cx			; = 0
 dogetbit
 jc DECOMP30
; address with 1 byte
 dogetbit
 rcl cx,1
 dogetbit
 rcl cx,1			; read 2 bits for length
 lodsb				; al = displacement
 mov ah,0FFh			; sign-extend
 xchg bx,ax			; bx = displacement, clobbers ax
 ; inc cx
 ; inc cx			; length 0..3 to 2..5
 jmp decomp40_inc_inc_cx	; (does twice inc cx)

retf_instruction:
 retf				; branch to relocated depacker

%ifdef NOINLINE
getbitfunction:
 getbitmacro
 retn
%endif

; address with 2 bytes
DECOMP30:
 lodsw				; ax = displacement/length combined word
 mov bx,ax
 mov cl,3
 shr bh,cl			; get high 5 bits to low 5 bits of bh
 or bh,0E0h			; fill high 3 bits with all-ones
 and ah,7			; isolate low 3 bits of higher byte
 jz DECOMP39			; if zero -->
 mov cl,ah			; cx = 1..7
decomp40_inc_inc_cx:
 inc cx
decomp40_inc_cx:
 inc cx				; length 1..7 to 3..9
DECOMP40:
 es mov al,[bx+di]		; read byte from window
; for testing
; mov ah,0
; cs sub CRC2,ax
; cs inc SIZE
 stosb				; store match byte
 loop DECOMP40			; loop for subsequent match bytes -->
DECOMP10_j1:
 jmp DECOMP10			; back to main loop

; address with 3 bytes
DECOMP39:		; ah = 0
 lodsb				; al = third byte
 cmp al,1			; below or equal to one ?
 jb FINDCMP			; yes below, end marker --> (finish decompression)
 xchg cx,ax			; 2..255, get cx and clobber ax
 ; inc cx			; length 2..255 to 3..256
 ; je DECOMP50			; yes equal, normalise pointers -->
 jne decomp40_inc_cx		; do match copy --> (does inc cx)
	; fall through if al was == 01h, ax and cx both don't matter

; normalise pointers es:di and ds:si
DECOMP50:
%ifndef NOSEGMENTCHANGE
 mov bx,di			; = current destination offset
 and di,000Fh			; = low nybble
 add di,2000h			; after normalisation we want di >= 8 KiB
 mov cl,4
 shr bx,cl			; = 3 high nybbles
 mov ax,es
 add ax,bx			; => after written destination
 sub ax,200h			; allow addressing the 8 KiB of prior window
 mov es,ax			; es:di -> next destination buffer

 mov bx,si
 and si,000Fh			; normalise si (isolate low nybble)
 shr bx,cl			; = 3 high nybbles
 mov ax,ds
 add ax,bx			; => at next yet unread source data
 mov ds,ax			; -> next source data

 jmp DECOMP10_j1		; back to main loop -->
%else
halt:
	int3
	sti
	hlt
	jmp halt
%endif

; process the relocation table (in the format packed by the packer)
FINDCMP:
 push cs
 pop ds				; => relocated depacker segment

%ifndef NORELOCATIONS
RELOC03:
 mov si, RELOC - EXEPACK	; -> relocation table
 pop bx				; => PSP
 add bx,10h			; => image destination
 mov dx,bx			; also => image destination
 xor di,di			; = 0
RELOC04:
 lodsb				; get a byte
 cmp al, 255			; is it 255 ?
 je RELOC10			; yes -->
 mov ah,0			; zero-extend to 0..254
RELOC07:
 add di,ax			; add to offset
 mov ax,di
 and di,000Fh			; isolate low nybble
 mov cl,4
 shr ax,cl			; get upper 3 nybbles
 add dx,ax			; add to current segment
 mov es,dx			; => current segment
 es add [di],bx			; relocate
 jmp RELOC04			; back to relocation loop -->
RELOC10:
 lodsw				; get a word
 cmp ax,1			; is it zero or one ?
 jae RELOC15			; not zero -->
 add dx,0FFFh			; add 64 KiB - 16 Byte to current segment
 jmp RELOC04			; back to relocation loop -->
RELOC15:
 jne RELOC07			; not one -->
				; yes, all relocations done

; launch of the EXE program
RELOC20:
 mov ax,bx			; => depacked image
%else
 pop ax				; => PSP
 add ax,10h			; => image destination
%endif
 mov di, 0
patchsp: equ $ - 2
 mov si, 0			; si:di = entrypoint's ss:sp
patchss: equ $ - 2
 add si,ax			; relocate ss in si
 add STARTCS,ax			; relocate cs in memory
 jmp short flushpipeline
flushpipeline:
 sub ax,10h			; => PSP
 mov ds,ax
 mov es,ax			; restore ds = es => PSP
 pop ax				; preserve ax from DOS loader
 cli
 mov ss,si
 mov sp,di			; set ss:sp
 sti
 jmp 0:0		; jump to program entrypoint -->
patchcsip: equ $ - 4

RELOC:	; relocation table placed here by packer
EXEPACK_size equ $ - EXEPACK


%ifndef NOINLINE
%ifndef NOSEGMENTCHANGE
%ifndef NORELOCATIONS
global PREPARE2
PREPARE2:
%else
global PREPARE3
PREPARE3:
%endif
%else
%ifndef NORELOCATIONS
global PREPARE4
PREPARE4:
%else
global PREPARE5
PREPARE5:
%endif
%endif
%else
%ifndef NOSEGMENTCHANGE
%ifndef NORELOCATIONS
global PREPARE6
PREPARE6:
%else
global PREPARE7
PREPARE7:
%endif
%else
%ifndef NORELOCATIONS
global PREPARE8
PREPARE8:
%else
global PREPARE9
PREPARE9:
%endif
%endif
%endif

 extern depackersize,depackerstartcsip,depackerstartsp,depackerstartss
 extern depackerlenlz,depackerdecalage,depackerlenprog,depackerentry
 extern depackerident,relocformat,depackerallocdelta
 extern depackeroldident
	mov word [depackersize], EXEPACK_size
	mov word [depackerstartcsip], patchcsip - EXEPACK
	mov word [depackerstartsp], patchsp - EXEPACK
	mov word [depackerstartss], patchss - EXEPACK
	mov word [depackerlenlz], lenlz - EXEPACK
	mov word [depackerdecalage], decalage - EXEPACK
	mov word [depackerlenprog], lenprog - EXEPACK
	mov word [depackerentry], entry - EXEPACK
	mov word [depackerident], "X0"
%ifndef NOINLINE
%ifndef NOSEGMENTCHANGE
%ifndef NORELOCATIONS
	; mov word [depackeroldident], "E3"
	mov word [relocformat], 0E1h
%else
	; mov word [depackeroldident], "E4"
	mov word [relocformat], 0E4h
%endif
%else
%ifndef NORELOCATIONS
	; mov word [depackeroldident], "E5"
	mov word [relocformat], 0E1h
%else
	; mov word [depackeroldident], "E6"
	mov word [relocformat], 0E4h
%endif
%endif
%else
%ifndef NOSEGMENTCHANGE
%ifndef NORELOCATIONS
	mov word [relocformat], 0E1h
%else
	mov word [relocformat], 0E4h
%endif
%else
%ifndef NORELOCATIONS
	mov word [relocformat], 0E1h
%else
	mov word [relocformat], 0E4h
%endif
%endif
%endif
	mov dx, cs
	mov ax, DEPACKER2
	retn
