
; Depacker for LZEXE compressed executable
; Copyright (C) 1989 Fabrice Bellard
; Ported to NASM by E. C. Masloch, 2025
; Under MIT license, refer to LICENSE file

section CODE PUBLIC

%define STARTIP  word [patchcsip - EXEPACK]
%define STARTCS  word [patchcsip + 2 - EXEPACK]
%define STARTSP  word [patchsp - EXEPACK]
%define STARTSS  word [patchss - EXEPACK]
%define LENLZ    word [lenlz - EXEPACK]
				; paragraph length of the packed data
%define DECALAGE word [decalage - EXEPACK]
				; how far to relocate the depacker in paragraphs
				;  (packed data is moved to below this)
%define LENPROG  word [lenprog - EXEPACK]
				; byte length of the depacker (including relocations)

; macro to take a bit
%imacro GETBIT 0
 shr bp,1			; CY if bit set, NC if bit clear
 dec dx				; 0 if out of bits now
 jnz %%L01			; not yet out of bits -->
 lodsw				; load new word of bits
 mov bp,ax			; bp = new word of bits
 mov dl,16			; dx = 16 bits left in this word
%%L01:
%endmacro

global PREPARE1
PREPARE1:

 extern depackersize,depackerstartcsip,depackerstartsp,depackerstartss
 extern depackerlenlz,depackerdecalage,depackerlenprog,depackerentry
 extern depackerident,relocformat
	mov word [depackersize], EXEPACK_size
	mov word [depackerstartcsip], patchcsip - EXEPACK
	mov word [depackerstartsp], patchsp - EXEPACK
	mov word [depackerstartss], patchss - EXEPACK
	mov word [depackerlenlz], lenlz - EXEPACK
	mov word [depackerdecalage], decalage - EXEPACK
	mov word [depackerlenprog], lenprog - EXEPACK
	mov word [depackerentry], entry - EXEPACK
	mov word [depackerident], "91"
	mov word [relocformat], 91
	mov dx, cs
	mov ax, DEPACKER1
	retn


DEPACKER1:
EXEPACK:

patchcsip:	dw 0, 0
patchsp:	dw 0
patchss:	dw 0
lenlz:		dw 0
decalage:	dw 0
lenprog:	dw 0

entry:
 push es			; save the PSP segment
 push cs
 pop ds				; => depacker
 mov cx,LENPROG			; = depacker length
 mov si,cx			; -> behind depacker
 dec si				; -> last byte of depacker
 mov di,si			; (same)
 mov bx,ds
 add bx,DECALAGE		; => destination for relocating depacker
 mov es,bx			; es:di -> last byte of destination
 std				; move downwards (DN)
 rep movsb			; relocate depacker
 push bx
 mov ax, SUITE - EXEPACK
 push ax			; -> relocated entrypoint
 retf				; branch to relocated depacker

SUITE:
; relocate the packed data to top of our allocation
	; ds => at depacker source (behind packed data)
	; es = cs = bx => at depacker destination (behind data allocation)
 cs mov bp,LENLZ		; bp = length in paragraphs
 mov dx,ds			; => at depacker
DEPL10:
 mov ax,bp			; ax = how much to relocate this iteration
 cmp ax,1000h			; more than 64 KiB ?
 jbe DEPL05			; no -->
 mov ax,1000h			; limit to 64 KiB per iteration
DEPL05:
 sub bp,ax			; decrease remaining counter
 sub dx,ax			; => at current chunk of source data
 sub bx,ax			; => at current chunk's destination
 mov ds,dx
 mov es,bx
 mov cl,3
 shl ax,cl			; = how many words in this chunk
 mov cx,ax			; counter for string move operation
 shl ax,1			; = how many bytes in this chunk (may overflow)
 dec ax
 dec ax				; -> at last word of data
 mov si,ax
 mov di,ax			; set up indices for string move operation
 rep movsw			; move data chunk (still DN)
 test bp,bp			; any data left ?
 jnz DEPL10			; yes, so loop -->


; start of unpacking
 cld
 mov es,dx			; => destination for depacked image
 mov ds,bx			; => source of packed data
 xor si,si
 xor di,di
 mov dx,16			; init bit counter
 lodsw				; get first word of bits
 mov bp,ax			; bp = word of bits

DECOMP10:
 GetBit				; get bit indicating a literal (1)
				;  or match or other (0)
 jnc DECOMP20			; 0 so a match or other -->
; for testing
; lodsb
; mov ah,0
; cs sub CRC2,ax
; cs inc SIZE
; stosb
 movsb				; move a literal byte
 jmp DECOMP10			; back to main loop -->

; reading from the buffer window
DECOMP20:
 xor cx,cx			; = 0
 GetBit
 jc DECOMP30
; address with 1 byte
 GetBit
 rcl cx,1
 GetBit
 rcl cx,1			; read 2 bits for length
 inc cx
 inc cx				; length 0..3 to 2..5
 lodsb				; al = displacement
 mov bh,0FFh			; sign-extend
 mov bl,al			; bx = displacement
 jmp near DECOMP40

; address with 2 bytes
DECOMP30:
 lodsw				; ax = displacement/length combined word
 mov bx,ax
 mov cl,3
 shr bh,cl			; get high 5 bits to low 5 bits of bh
 or bh,0E0h			; fill high 3 bits with all-ones
 and ah,7			; isolate low 3 bits of higher byte
 jz DECOMP39			; if zero -->
 mov cl,ah			; cx = 1..7
 inc cx
 inc cx				; length 1..7 to 3..9
DECOMP40:
 es mov al,[bx+di]		; read byte from window
; for testing
; mov ah,0
; cs sub CRC2,ax
; cs inc SIZE
 stosb				; store match byte
 loop DECOMP40			; loop for subsequent match bytes -->
 jmp DECOMP10			; back to main loop

; address with 3 bytes
DECOMP39:
 lodsb				; al = third byte
 test al,al			; equal to zero ?
 jz FINDCMP			; yes, end marker --> (finish decompression)
 cmp al,1			; equal to one ?
 je DECOMP50			; yes, normalise pointers -->
 mov cl,al			; 2..255
 inc cx				; length 2..255 to 3..256
 jmp DECOMP40			; do match copy -->

; normalise pointers es:di and ds:si
DECOMP50:
 mov bx,di			; = current destination offset
 and di,000Fh			; = low nybble
 add di,2000h			; after normalisation we want di >= 8 KiB
 mov cl,4
 shr bx,cl			; = 3 high nybbles
 mov ax,es
 add ax,bx			; => after written destination
 sub ax,200h			; allow addressing the 8 KiB of prior window
 mov es,ax			; es:di -> next destination buffer

 mov bx,si
 and si,000Fh			; normalise si (isolate low nybble)
 shr bx,cl			; = 3 high nybbles
 mov ax,ds
 add ax,bx			; => at next yet unread source data
 mov ds,ax			; -> next source data

 jmp DECOMP10			; back to main loop -->

 DB '*FAB*'			; a signature ?

; process the relocation table (in the format packed by the packer)
FINDCMP:
 push cs
 pop ds				; => relocated depacker segment
RELOC03:
 mov si, RELOC - EXEPACK	; -> relocation table
 pop bx				; => PSP
 add bx,10h			; => image destination
 mov dx,bx			; also => image destination
 xor di,di			; = 0
RELOC04:
 lodsb				; get a byte
 test al,al			; is it zero ?
 jz RELOC10			; yes -->
 mov ah,0			; zero-extend to 1..255
RELOC07:
 add di,ax			; add to offset
 mov ax,di
 and di,000Fh			; isolate low nybble
 mov cl,4
 shr ax,cl			; get upper 3 nybbles
 add dx,ax			; add to current segment
 mov es,dx			; => current segment
 es add [di],bx			; relocate
 jmp RELOC04			; back to relocation loop -->
RELOC10:
 lodsw				; get a word
 test ax,ax			; is it zero ?
 jnz RELOC15			; no -->
 add dx,0FFFh			; add 64 KiB - 16 Byte to current segment
 mov es,dx			; => current segment (ecm: why??)
 jmp RELOC04			; back to relocation loop -->
RELOC15:
 cmp ax,1			; is it one ?
 jne RELOC07			; no -->
				; yes, all relocations done

; launch of the EXE program
RELOC20:
 mov ax,bx			; => depacked image
 mov di,STARTSP
 mov si,STARTSS			; si:di = entrypoint's ss:sp
 add si,ax			; relocate ss in si
 add STARTCS,ax			; relocate cs in memory
 sub ax,10h			; => PSP
 mov ds,ax
 mov es,ax			; restore ds = es => PSP
 xor bx,bx			; = 0
 cli
 mov ss,si
 mov sp,di			; set ss:sp
 sti
 cs jmp far [BX]		; jump to program entrypoint -->

RELOC:	; relocation table placed here by packer
EXEPACK_size equ $ - EXEPACK
