{ utilitaires pour grer la ligne de commande }
unit cmdline;

interface

var
	cmd:string[127];
	cmdptr:byte;
{ caractre en cours de traitement }
	CmdCh:char;

{ renvoie true si option trouve }
function IsOption:boolean;
function IsChar(c:char):boolean;

{ prendre un caractre dans cmdch }
procedure NextCmdCh;

{ sauter des espaces ou des tabs }
procedure SkipSpace;

{ pour saisir un nombre, renvoie true si erreur }
function GetNumber(var n:longint):boolean;

{ pour saisir une expression jusqu' espace, ou une option }
function GetName:string;
function GetUpCase:string;

{ sortie d'un message d'erreur }
function ErrorMsg(erreur:integer):string;

implementation

procedure NextCmdCh;
begin
    inc(cmdptr);
	if cmdptr<=length(cmd) then begin
		CmdCh:=cmd[cmdptr];
	end
	else begin
		CmdCh:=#13;
	end;
end;

procedure SkipSpace;
begin
	while (cmdch=' ') or (cmdch=#9) do NextCmdCh;
end;

function GetName:string;
var s:string;
begin
	SkipSpace;
	s:='';
	while  (cmdch<>' ') and (cmdch<>#9) and (cmdch<>#13) do begin
		s:=s+cmdCh;
		NextCmdCh;
	end;
	GetName:=s;
end;

function GetUpcase:string;
var s:string;
begin
	SkipSpace;
	s:='';
	while (cmdch<>' ') and (cmdch<>#9) and (cmdch<>#13) do begin
		s:=s+upcase(cmdCh);
		NextCmdCh;
	end;
	GetUpCase:=s;
end;


function GetNumber(var n:longint):boolean;
var s:string;
	e:integer;
begin
	s:=GetName;
	val(s,n,e);
	GetNumber:=(e<>0);
end;

function IsOption:boolean;
begin
	SkipSpace;
	if CmdCh='/' then begin
		NextCmdCh;
		IsOption:=true;
	end
	else begin
		IsOption:=false;
	end;
end;


function IsChar(c:char):boolean;
begin
	if CmdCh=c then begin
		NextCmdCh;
		IsChar:=true;
	end
	else
		IsChar:=false;
end;


{------------------------------------------------------------}
{             Messages d'erreur                              }
{------------------------------------------------------------}

function ErrorMsg(erreur:integer):string;
begin
	case Erreur of
		0:ErrorMsg:='No error';
		1:ErrorMsg:='Invalid function';
		2:ErrorMsg:='File not found';
		3:ErrorMsg:='Path not found';
		4:ErrorMsg:='No handles available';
		5:ErrorMsg:='Access denied';
		6:ErrorMsg:='Invalid handle';
		7:ErrorMsg:='MCB destroyed';
		8:ErrorMsg:='Out of memory';
		9:ErrorMsg:='MCB invalid';
		10:ErrorMsg:='Environment invalid';
		11:ErrorMsg:='Format invalid';
		12:ErrorMsg:='Access code invalid';
		13:ErrorMsg:='Data invalid';
		14:ErrorMsg:='Fixup overflow';
		15,151:ErrorMsg:='Invalid drive';
		16:ErrorMsg:='Attempted to remove current directory';
		17:ErrorMsg:='Not same device';
		18:ErrorMsg:='No more files';
		100:ErrorMsg:='Read error';
		101:ErrorMsg:='Write error';
		102:ErrorMsg:='File variable not assigned';
		103:ErrorMsg:='File not open';
		104:ErrorMsg:='File not open for reading';
		105:ErrorMsg:='File not open for writing';
		106:ErrorMsg:='Invalid number format';
		150:ErrorMsg:='Disk write-protected';
		152:ErrorMsg:='Disk drive not ready';
		153:ErrorMsg:='Unknown command';
		154:ErrorMsg:='Invalid data read';
		155:ErrorMsg:='Incorrect structure size';
		156:ErrorMsg:='Disk heads not positioned correctly';
		157:ErrorMsg:='Unknown magnetic media';
		158:ErrorMsg:='Sector not found';
		159:ErrorMsg:='End of paper detected';
		160:ErrorMsg:='Device write error';
		161:ErrorMsg:='Device read error';
		162:ErrorMsg:='Hardware error';
				else ErrorMsg:='Unknown error';
    end;
end;


begin
{ chargement de la ligne de commande }
	cmd:=string(ptr(Prefixseg,$80)^);
{ pointeur pour l'analyse de la ligne }
	cmdptr:=0;
	NextCmdCh;
end.
