	PAGE	,132				; 					 ;AN000;
;	SCCSID = @(#)ifsdir.asm 1.0 87/05/11						 ;AN000;
TITLE	IFSFUNC DIRECTORY ROUTINES - Routines for IFS driver dispatch			 ;AN000;
NAME	NETDIR										 ;AN000;
;************************************************************************************	 ;AN000;
;											 ;AN000;
; DIRECTORY related IFS driver calls							 ;AN000;
;											 ;AN000;
;   IFS_RMDIR										 ;AN000;
;   IFS_MKDIR										 ;AN000;
;   IFS_CHDIR										 ;AN000;
;											 ;AN000;
; Programming notes:									 ;AN000;
;   Old redirector segmentation preserved.						 ;AN000;
;   Directory routines do not generate critical errors. 				 ;AN000;
;											 ;AN000;
; REVISION HISTORY:									 ;AN000;
;	A000	Original version  4.00		  May 1987
;	A001	PTM 3671- check for null cds	  3/88 RPS/RMG
;											 ;AN000;
;   LOC -  67										 ;AN000;
;   LOD -   4										 ;AN000;
;											 ;AN000;
;************************************************************************************	 ;AN000;
											 ;AN000;
.xlist											 ;AN000;
.xcref											 ;AN000;
INCLUDE IFSSYM.INC									 ;AN000;
INCLUDE IFSFSYM.INC									 ;AN000;
INCLUDE DOSSYM.INC									 ;AN000;
INCLUDE DEVSYM.INC									 ;AN000;
.cref											 ;AN000;
.list											 ;AN000;
											 ;AN000;
AsmVars <IBM, Installed, Debug> 							 ;AN000;
											 ;AN000;
; define the base code segment of the network support first				 ;AN000;
											 ;AN000;
ifsseg	SEGMENT BYTE PUBLIC 'ifsseg'                                                     ;AN000;
ifsseg	ENDS										 ;AN000;
											 ;AN000;
; include the rest of the segment definitions for normal MSDOS				 ;AN000;
											 ;AN000;
include dosseg.asm									 ;AN000;
											 ;AN000;
DATA		SEGMENT WORD PUBLIC 'DATA'                                               ;AN000;
											 ;AN000;
	; DOSGROUP data 								 ;AN000;
	Extrn	WFP_START:WORD								 ;AN000;
	Extrn	THISCDS:DWORD								 ;AN000;
											 ;AN000;
DATA		ENDS									 ;AN000;
											 ;AN000;
											 ;AN000;
; define our own code segment								 ;AN000;
											 ;AN000;
ifsseg	SEGMENT BYTE PUBLIC 'ifsseg'                                                     ;AN000;
	ASSUME	SS:DOSGROUP,CS:ifsseg							 ;AN000;
											 ;AN000;
	;IFS Data									 ;AN000;
	Extrn	IFSR:WORD								 ;AN000;
	Extrn	DEVICE_CB@_OFFSET:WORD							 ;AN000;
											 ;AN000;
BREAK <IFS_RMDIR Remove an IFS Directory>						 ;AN000;
;************************************************************************************	 ;AN000;
;											 ;AN000;
; IFS_RMDIR										 ;AN000;
;											 ;AN000;
;Called by:										 ;AN000;
;     IFSFUNC Dispatcher								 ;AN000;
;											 ;AN000;
; Routines called:									 ;AN000;
;	CDS_TO_CD									 ;AN000;
;	CALL_IFS									 ;AN000;
;											 ;AN000;
; Inputs:										 ;AN000;
;	[WFP_START] Points to WFP string						 ;AN000;
;	[THISCDS]   Points to CDS being used						 ;AN000;
;											 ;AN000;
; Function:										 ;AN000;
;	Prep IFSRH as follows:	(* indicate which fields set)				 ;AN000;
;	*  IFSR_LENGTH	    DW	   42	    ; Request length				 ;AN000;
;	*  IFSR_FUNCTION    DB	    4	    ; Execute API function			 ;AN000;
;	   IFSR_RETCODE     DW	    ?							 ;AN000;
;	   IFSR_RETCLASS    DB	    ?							 ;AN000;
;	   IFSR_RESV1	    DB	   16 DUP(0)						 ;AN000;
;	*  IFSR_APIFUNC     DB	    4	    ; Remove Directory				 ;AN000;
;	   IFSR_ERROR_CLASS DB	    ?							 ;AN000;
;	   IFSR_ERROR_ACTION DB     ?							 ;AN000;
;	   IFSR_ERROR_LOCUS DB	    ?							 ;AN000;
;	   IFSR_ALLOWED     DB	    ?							 ;AN000;
;	   IFSR_I24_RETRY   DB	    ?							 ;AN000;
;	   IFSR_I24_RESP    DB	    ?							 ;AN000;
;	   IFSR_RESV2	    DB	    ?							 ;AN000;
;	*  IFSR_DEVICE_CB@  DD	    ?	    ; Call CDS_TO_CD to convert CDS to CD	 ;AN000;
;					   ; and set this as pointer to it.		 ;AN000;
;	   IFSR_OPEN_CB@    DD	    ?							 ;AN000;
;	*  IFSR_NAME@	    DD	    ?	    ; [WFP_START]				 ;AN000;
;											 ;AN000;
;	CALL routine, CALL_IFS, with pointer to CURDIR_IFSR_HDR 			 ;AN000;
;	IF IFSR_RETCODE = 0 THEN							 ;AN000;
;	   Call CD_TO_CDS								 ;AN000;
;	   Clear carry									 ;AN000;
;	ELSE										 ;AN000;
;	   Set carry									 ;AN000;
;	   Put error code in AX 							 ;AN000;
;	ENDIF										 ;AN000;
;											 ;AN000;
; Outputs:										 ;AN000;
;	Carry clear:	      CDS FSDA updated						 ;AN000;
;	Carry set on error:   error_path_not_found (bad path)				 ;AN000;
;			      error_access_denied  (file/device not empty)		 ;AN000;
;											 ;AN000;
; Notes: DS preserved, others destroyed 						 ;AN000;
;											 ;AN000;
;************************************************************************************	 ;AN000;
											 ;AN000;
											 ;AN000;
	procedure   IFS_RMDIR,NEAR							 ;AN000;
											 ;AN000;
	entry	IFS_SEQ_RMDIR								 ;AN000;
											 ;AN000;
	ifsr_fcn_def  EXECAPI			; define ifsr fields for rmdir		 ;AN000;
	ifsr_api_def  RMDIR								 ;AN000;
											 ;AN000;
	PUSH	DS				; preserve DS				 ;AN000;
											 ;AN000;
	invoke	PREP_IFSR			; init ifsr, sets es:bx -> ifsr 	 ;AN000;
											 ;AN000;
	MOV	ES:[BX.IFSR_APIFUNC],IFSRMDIR						 ;AN000;
	JMP	SHORT CHDIR_10			; go finish in ifs_chdir		 ;AN000;
											 ;AN000;
EndProc IFS_RMDIR									 ;AN000;
											 ;AN000;
BREAK <IFS_MKDIR Create an IFS Directory>						 ;AN000;
											 ;AN000;
;************************************************************************************	 ;AN000;
;											 ;AN000;
; IFS_MKDIR										 ;AN000;
;											 ;AN000;
; Called by:	   IFSFUNC Dispatcher							 ;AN000;
;											 ;AN000;
; Routines called: CDS_TO_CD								 ;AN000;
;		   CALL_IFS								 ;AN000;
;											 ;AN000;
; Inputs:										 ;AN000;
;	[WFP_START] Points to WFP string						 ;AN000;
;	[THISCDS]   Points to CDS being used.  Not NULL.				 ;AN000;
;											 ;AN000;
; Function:										 ;AN000;
;	Prep IFSRH as follows:	(* indicate which fields set)				 ;AN000;
;	*  IFSR_LENGTH	    DW	   42	    ; Request length				 ;AN000;
;	*  IFSR_FUNCTION    DB	    4	    ; Execute API function			 ;AN000;
;	   IFSR_RETCODE     DW	    ?							 ;AN000;
;	   IFSR_RETCLASS    DB	    ?							 ;AN000;
;	   IFSR_RESV1	    DB	   16 DUP(0)						 ;AN000;
;	*  IFSR_APIFUNC     DB	    3	    ; Create Directory				 ;AN000;
;	   IFSR_ERROR_CLASS DB	    ?							 ;AN000;
;	   IFSR_ERROR_ACTION DB     ?							 ;AN000;
;	   IFSR_ERROR_LOCUS DB	    ?							 ;AN000;
;	   IFSR_ALLOWED     DB	    ?							 ;AN000;
;	   IFSR_I24_RETRY   DB	    ?							 ;AN000;
;	   IFSR_I24_RESP    DB	    ?							 ;AN000;
;	   IFSR_RESV2	    DB	    ?							 ;AN000;
;	*  IFSR_DEVICE_CB@  DD	    ?	    ; Call CDS_TO_CD to convert CDS to CD	 ;AN000;
;					   ; and set this as pointer to it.		 ;AN000;
;	   IFSR_OPEN_CB@    DD	    ?							 ;AN000;
;	*  IFSR_NAME@	    DD	    ?	    ; [WFP_START]				 ;AN000;
;											 ;AN000;
;	CALL routine, CALL_IFS, with pointer to CURDIR_IFSR_HDR 			 ;AN000;
;											 ;AN000;
;	IF IFSR_RETCODE = 0 THEN							 ;AN000;
;	   Call CD_TO_CDS								 ;AN000;
;	   Clear carry									 ;AN000;
;	ELSE										 ;AN000;
;	   Set carry									 ;AN000;
;	   Put error code in AX 							 ;AN000;
;	ENDIF										 ;AN000;
;											 ;AN000;
; Outputs:										 ;AN000;
;	Carry clear:	     CDS FSDA updated						 ;AN000;
;	Carry set on error:  error_path_not_found (bad path)				 ;AN000;
;			     error_access_denied					 ;AN000;
;			      (Attempt to re-create read only file , or 		 ;AN000;
;			       create a second volume id or create a dir)		 ;AN000;
;											 ;AN000;
; Notes: DS preserved, others destroyed 						 ;AN000;
;											 ;AN000;
;************************************************************************************	 ;AN000;
											 ;AN000;
	procedure   IFS_MKDIR,NEAR							 ;AN000;
											 ;AN000;
	entry	IFS_SEQ_MKDIR								 ;AN000;
											 ;AN000;
	ifsr_fcn_def  EXECAPI			; define ifsr fields for mkdir		 ;AN000;
	ifsr_api_def  MKDIR								 ;AN000;
											 ;AN000;
	PUSH	DS				; preserve DS				 ;AN000;
											 ;AN000;
	invoke	PREP_IFSR			; init ifsr, sets es:bx -> ifsr 	 ;AN000;
											 ;AN000;
	MOV	ES:[BX.IFSR_APIFUNC],IFSMKDIR						 ;AN000;
	JMP	SHORT CHDIR_10			; go finish in ifs_chdir		 ;AN000;
											 ;AN000;
EndProc IFS_MKDIR									 ;AN000;
											 ;AN000;
BREAK <IFS_CHDIR Check for validity and change directory>				 ;AN000;
											 ;AN000;
											 ;AN000;
;************************************************************************************	 ;AN000;
;											 ;AN000;
; IFS_CHDIR										 ;AN000;
;											 ;AN000;
; Called by:	   IFSFUNC Dispatcher							 ;AN000;
;											 ;AN000;
; Routines called: CDS_TO_CD								 ;AN000;
;		   CD_TO_CDS								 ;AN000;
;		   CALL_IFS								 ;AN000;
;											 ;AN000;
; Inputs:										 ;AN000;
;	[WFP_START] Points to WFP string						 ;AN000;
;	[THISCDS]   Points to CDS being used.  Not NUL. 				 ;AN000;
;											 ;AN000;
; Function:										 ;AN000;
;	Prep IFSRH as follows:	(* indicate which fields set)				 ;AN000;
;	*  IFSR_LENGTH	    DW	   42	    ; Request length				 ;AN000;
;	*  IFSR_FUNCTION    DB	    4	    ; Execute API function			 ;AN000;
;	   IFSR_RETCODE     DW	    ?							 ;AN000;
;	   IFSR_RETCLASS    DB	    ?							 ;AN000;
;	   IFSR_RESV1	    DB	   16 DUP(0)						 ;AN000;
;	*  IFSR_APIFUNC     DB	    5	    ; Change Directory				 ;AN000;
;	   IFSR_ERROR_CLASS DB	    ?							 ;AN000;
;	   IFSR_ERROR_ACTION DB     ?							 ;AN000;
;	   IFSR_ERROR_LOCUS DB	    ?							 ;AN000;
;	   IFSR_ALLOWED     DB	    ?							 ;AN000;
;	   IFSR_I24_RETRY   DB	    ?							 ;AN000;
;	   IFSR_I24_RESP    DB	    ?							 ;AN000;
;	   IFSR_RESV2	    DB	    ?							 ;AN000;
;	*  IFSR_DEVICE_CB@  DD	    ?	    ; Call CDS_TO_CD to convert CDS to CD	 ;AN000;
;					   ; and set this as pointer to it.		 ;AN000;
;	   IFSR_OPEN_CB@    DD	    ?							 ;AN000;
;	*  IFSR_NAME@	    DD	    ?	    ; [WFP_START]				 ;AN000;
;											 ;AN000;
;	CALL routine, CALL_IFS, with pointer to CURDIR_IFSR_HDR 			 ;AN000;
;											 ;AN000;
;	IF IFSR_RETCODE = 0 THEN							 ;AN000;
;	   Call CD_TO_CDS to update CDS 						 ;AN000;
;	   Clear carry									 ;AN000;
;	ELSE										 ;AN000;
;	   Set carry									 ;AN000;
;	   Put error code in AX 							 ;AN000;
;	ENDIF										 ;AN000;
;											 ;AN000;
; Outputs:										 ;AN000;
;	Carry clear: CDS updated.							 ;AN000;
;	Carry set on error:  error_path_not_found (bad path)				 ;AN000;
;			     error_access_denied					 ;AN000;
;											 ;AN000;
; Notes: DS preserved, others destroyed 						 ;AN000;
;											 ;AN000;
;************************************************************************************	 ;AN000;
											 ;AN000;
	procedure   IFS_CHDIR,NEAR							 ;AN000;
											 ;AN000;
	ifsr_fcn_def  EXECAPI			; define ifsr fields for chdir		 ;AN000;
	ifsr_api_def  CHDIR								 ;AN000;
											 ;AN000;
	PUSH	DS				; preserve DS				 ;AN000;
											 ;AN000;
	invoke	PREP_IFSR			; init ifsr, sets es:bx -> ifsr 	 ;AN000;
											 ;AN000;
	MOV	ES:[BX.IFSR_APIFUNC],IFSCHDIR						 ;AN000;
											 ;AN000;
CHDIR_10:					; Welcome rmdir/mkdir code		 ;AN000;
	MOV	ES:[BX.IFSR_LENGTH],LENGTH_CHDIR					 ;AN000;
	MOV	ES:[BX.IFSR_FUNCTION],IFSEXECAPI					 ;AN000;
						; ds -> dosgroup			 ;AN000;
	MOV	SI,WORD PTR [WFP_START] 	; to access thiscds & wfp		 ;AN000;
	invoke	STRIP_WFP_START 		; ditch leading d:\			 ;AN000;
	MOV	WORD PTR ES:[BX.IFSR_NAME@],SI						 ;AN000;
	MOV	WORD PTR ES:[BX.IFSR_NAME@+2],DS					 ;AN000;
	LDS	SI,[THISCDS]								 ;AN000;
	SaveReg <DS,SI> 								 ;AN000;
	MOV	DEVICE_CB@_OFFSET,IFSR_DEVICE_CB@					 ;AN000;
	CMP	SI,NULL_PTR			; skip cds work if cds null		 ;AN001;
	JE	CHDIR_20								 ;AN001;
	invoke	CDS_TO_CD			; CDS: sets [THISIFS]			 ;AN000;
						;	    IFSR_DEVICE_CB@		 ;AN000;
						;	    ds - ifsseg 		 ;AN000;
CHDIR_20:										 ;AN001;
	SaveReg <CS>				; make sure ds = ifsseg 		 ;AN001;
	RestoreReg <DS> 								 ;AN001;
;************************************************
	invoke	CALL_IFS			; call fs with dir request		 ;AN000;
;************************************************
											 ;AN000;
	RestoreReg <DI,ES>			; restore cds ptr into es:di		 ;AN000;
	JC	CHDIR_1000								 ;AN000;
	CMP	DI,NULL_PTR			; skip cds work if cds null		 ;AN001;
	JE	CHDIR_40								 ;AN001;
	invoke	CD_TO_CDS			; update cds				 ;AN000;

CHDIR_40:										 ;AN001;
	CLC										 ;AN000;
											 ;AN000;
CHDIR_1000:					; finished				 ;AN000;
	POP	DS				; restore DS				 ;AN000;
	return										 ;AN000;
											 ;AN000;
EndProc IFS_CHDIR									 ;AN000;
											 ;AN000;
ifsseg	ENDS										 ;AN000;
    END 										 ;AN000;
