
%include "nasmorg.mac"
%include "amis.mac"

BASE700h equ 256	; DOSENTRY:this value should -> 00700h

section DOSENTRY
;==============================================================================
;REVISION HISTORY:
;AN000 - New for DOS Version 3.4 - J.K.
;AC000 - Changed for DOS Version 3.4 - J.K.
;ANxxx - PTR, DCRs
;==============================================================================
;AN001 - d9  Double word MOV instruction for 80386 based machine.    7/1/87 J.K.
;AN002 - d25 Change DASD ERP to that recommended by Storage Systems. 7/29/87 J.K.
;AN003; d304 Boot record structure change for OS2		     11/9/87 J.K.
;==============================================================================
	EXTRN	INIT:NEAR

	PUBLIC	START$
START$:
 assume ds:nothing, es:nothing, ss:nothing
	JMP	INIT			;START$ PATCH BY INIT TO POINT TO
					;HDRIVE BPB
	align 16, db 26h
;	PUBLIC	FORMAT_PATCH
;FORMAT_PATCH:				 ;ARR 2.42
;	JMP	FMTSET			;MJB001 DISPATCH FOR CALL FROM FORMAT UTILITY


	PATHSTART 001,BIO

;	DB	20 DUP (0)		;IBM WANTS SOME ZEROED AREA (DELETED)


;HEADER  DB	 "Ver 2.45"

global dosentry_xmsentry
%include "codesw.mac"
%include "entrysw.mac"
%include "entry.asm"		; new in lDOS


usesection DOSENTRY

extern conentry, prnentry, auxentry
extern com1entry, com2entry, com3entry, com4entry
extern lpt1entry, lpt2entry, lpt3entry, clockentry, blockentry

	even
 global amis_sign
amis_sign:
.ven:		fill 8, 32, db "ecm"
.prod:		fill 8, 32, db "lDOS"
		asciz

%if ($ - $$) < DOSENTRYDEVICEBASE * 16
 %error Header must be above or equal device base
%endif
	EVENB
	PUBLIC	CONHEADER
CONHEADER LABEL   WORD			  ;HEADER FOR DEVICE "CON"
	dw	AUXDEV2 - DOSENTRYDEVICEBASE * 16, seg AUXDEV2 + DOSENTRYDEVICEBASE
	DW	10000000_00010011B ;CON IN AND CON OUT + SPECIAL
	DW	strategyentry - DOSENTRYDEVICEBASE * 16
	DW	conentry - DOSENTRYDEVICEBASE * 16
	DB	'CON     '

	EVENB
	PUBLIC	AUXDEV2
AUXDEV2  LABEL	 WORD			 ;HEADER FOR DEVICE "AUX"
	dw	PRNDEV2 - DOSENTRYDEVICEBASE * 16, seg PRNDEV2 + DOSENTRYDEVICEBASE
	DW	10000000_00000000B
	DW	strategyentry - DOSENTRYDEVICEBASE * 16
	DW	auxentry - DOSENTRYDEVICEBASE * 16
	DB	'AUX     '

%assign num BASE700h + 0B0h - ($-$$)
%warning num bytes in front of prior old13
	org BASE700h + 0B0h
	EVENB
	dd -1				; prior OLD13

%assign num BASE700h + 0B4h - ($-$$)
%warning num bytes in front of orig13
	org BASE700h + 0B4h	; noted in EDR-DOS sources as being used by some applications
	  PUBLIC ORIG13
ORIG13	label	DWORD
	db	'21',0,0                ;J.K. 11/8/86 This is my employee serial # !!!

	EVENB
	PUBLIC	PTRSAV
PTRSAV	DD	0

%if ($ - $$) < DOSENTRYDEVICEBASE * 16
 %error Entrypoint must be above or equal device base
%endif
conentry:	devicerelocate relocateddeventry, CONTBL
prnentry:	devicerelocate relocateddevprnentry, PRNTBL, 0, 0
auxentry:	devicerelocate relocateddeventry, AUXTBL, 0
com1entry:	devicerelocate relocateddeventry, AUXTBL, 0
com2entry:	devicerelocate relocateddeventry, AUXTBL, 1
com3entry:	devicerelocate relocateddeventry, AUXTBL, 2
com4entry:	devicerelocate relocateddeventry, AUXTBL, 3
lpt1entry:	devicerelocate relocateddevprnentry, PRNTBL, 0, 1
lpt2entry:	devicerelocate relocateddevprnentry, PRNTBL, 1, 2
lpt3entry:	devicerelocate relocateddevprnentry, PRNTBL, 2, 3
clockentry:	devicerelocate relocateddeventry, TIMTBL
blockentry:	devicerelocate relocateddeventry, DSKTBL
strategyentry:	devicerelocate relocatedstrategyentry

;--------------------------------------------------------------
;
;	COMMAND JUMP TABLES
;
;	BEWARE - THESE TABLES OVERLAP SOMEWHAT! -C.P.
;

usesection BIOCODE

	ODD
DSKTBL	LABEL	BYTE
	DB	(.last - .) / 2		; THIS IS THE SIZE OF THE TABLE YUK!!!!
.:	DW	DSK$INIT
	DW	MEDIA$CHK
	DW	GET$BPB
	DW	CMDERR			;RS
	DW	DSK$READ
	DW	BUS$EXIT
	DW	EXIT
	DW	EXIT
	DW	DSK$WRIT
	DW	DSK$WRITV
	DW	EXIT			;ARR 2.41
	DW	EXIT			;ARR 2.41
	DW	CMDERR			;RS
	; PUBLIC TABLE_PATCH
; TABLE_PATCH: equ $			   ;ARR 2.42
	DW	DSK$OPEN		;ARR 2.41
	DW	DSK$CLOSE		;ARR 2.41
	DW	DSK$REM 		;ARR 2.41
	DW	EXIT
	DW	EXIT
	DW	EXIT
	DW	GENERIC$IOCTL		; KGS	3.20
	DW	EXIT
	DW	EXIT
	DW	EXIT
	DW	IOCTL$GETOWN		; RS 3.20
	DW	IOCTL$SETOWN		; RE 3.20
 extern msbio_check_gen_ioctl
.last:	dw msbio_check_gen_ioctl

	ODD
CONTBL	LABEL	BYTE
	DB	(.last - .) / 2
.:	DW	EXIT			;INIT
	DW	EXIT
	DW	EXIT
	DW	CMDERR
	DW	CON$READ
	DW	CON$RDND
	DW	EXIT
	DW	CON$FLSH
	DW	CON$WRIT
	DW	CON$WRIT
.last:	DW	EXIT			;ARR 2.41

;	DW	CMDERR			;J.K. 4/29/86 for CON$GENIOCTL support
;	DW	CMDERR			;J.K. 4/29/86
;	DW	CMDERR			;J.K. 4/29/86
;	DW	CMDERR			;J.K. 4/29/86
;	DW	CMDERR			;J.K. 4/29/86
;	DW	CMDERR			;J.K. 4/29/86
;	DW	CMDERR			;J.K. 4/29/86
;	DW	CMDERR			;J.K. 4/29/86
;	DW	CON$GENIOCTL		;J.K. 4/29/86

	ODD
AUXTBL	LABEL	BYTE
	DB	(.last - .) / 2
.:	DW	EXIT			;INIT
	DW	EXIT
	DW	EXIT
	DW	CMDERR
	DW	AUX$READ
	DW	AUX$RDND
	DW	EXIT
	DW	AUX$FLSH
	DW	AUX$WRIT
	DW	AUX$WRIT
.last:	DW	AUX$WRST

	ODD
TIMTBL	LABEL	BYTE
	DB	(.last - .) / 2
.:	DW	EXIT			;INIT
	DW	EXIT
	DW	EXIT
	DW	CMDERR
	DW	TIM$READ
	DW	BUS$EXIT
	DW	EXIT
	DW	EXIT
	DW	TIM$WRIT
.last:	DW	TIM$WRIT

	ODD
PRNTBL	LABEL	BYTE
	DB	(.last - .) / 2
.:	DW	EXIT			;INIT
	DW	EXIT
	DW	EXIT
	DW	CMDERR
	DW	EXIT$ZER		;INDICATE ZERO CHARS READ
	DW	BUS$EXIT
	DW	EXIT
	DW	EXIT
	DW	PRN$WRIT
	DW	PRN$WRIT
	DW	PRN$STAT
	DW	EXIT
	DW	EXIT			;ARR 2.41
	DW	EXIT			;ARR 2.41
	DW	EXIT			;ARR 2.41
	DW	EXIT			;ARR 2.41
	DW	PRN$TILBUSY
	DW	EXIT			;RS 3.20
	DW	EXIT			;RS 3.20
	DW	PRN$GENIOCTL		;RS 3.20
	DW	EXIT			;RS 3.20
	DW	EXIT			;RS 3.20
	DW	EXIT			;RS 3.20
	DW	EXIT			;RS 3.20
	DW	EXIT			;RS 3.20
 extern prn_check_gen_ioctl
.last:	dw	prn_check_gen_ioctl


usesection DOSBIODATA

	PUBLIC STEP_DRV
STEP_DRV	DB     -2		; ARR 2.20 LAST DRIVE ACCESSED

	PUBLIC PHYS_DRV
PHYS_DRV	DB	0		; USED BY SETDRIVE FOR GETTING BDS FOR
					; LOGICAL DRIVE, OR PHYSICAL DRIVE.
	PUBLIC FHAVE96
FHAVE96 	DB	0		; FLAG TO INDICATE PRESENCE OF
					;   96TPI SUPPORT
	PUBLIC SINGLE
SINGLE		DB	0		; USED TO DETECT SINGLE DRIVE SYSTEMS

	PUBLIC FHAVEK09
FHAVEK09	DB	0		;INDICATES IF THIS IS A K09 OR NOT
					; USED BY CONSOLE DRIVER.
	PUBLIC NEW_ROM
NEW_ROM 	DB	0		;SET TO 1 IF WE HAVE A ROM THAT CAN
					; HANDLE STRANGE MEDIA LAYOUTS.
	PUBLIC FSETOWNER
FSETOWNER	DB	?		;=1 IF WE ARE SETTING THE OWNER OF A
					;DRIVE. (EXAMINED BY CHECKSINGLE).


usesection DOSENTRY

	public	Secrete_Code
Secrete_Code	dw	'kj'            ;J.K. 11/7/86 Secrete code for DOS 3.30 IBMBIO.

usesection DOSBIODATA

	PUBLIC	AUXBUF
AUXBUF	DB	0,0,0,0   ;SET OF 1 BYTE BUFFERS FOR COM 1,2,3, AND 4

	EVENB
	PUBLIC PREVOPER,NUMBER_OF_SEC
PREVOPER	DW	?	; HOLDS INT 13 REQUEST (I.E. REGISTER AX).
NUMBER_OF_SEC	DB	?	; HOLDS NUMBER OF SECTORS TO READ ON AN ECC ERROR


usesection DOSENTRY

	%imacro irtentry 1-2.nolist
db %1
%2 dd 0
	%endmacro


%assign num BASE700h + 256-($-$$)
%warning num bytes in front of IRT

	_fill BASE700h + 256, 0, START$	; fixed address: 60h:200h == 70h:100h
InterruptRestorationTable:
 global InterruptRestorationTable
	irtentry 10h
	irtentry 13h, OLD13:
 PUBLIC OLD13
	irtentry 15h
	irtentry 19h, ORIG19:
 PUBLIC	ORIG19
	irtentry 1Bh
		; Above interrupts are in the order MS-DOS 6.x saves them
		;  (FDEMM386?/Jemm expects Int19 within the first five entries)
	irtentry 00h
	db -1


usesection DOSENTRY

%if ($ - $$) < DOSENTRYDEVICEBASE * 16
 %error Header must be above or equal device base
%endif
	EVENB
	PUBLIC	PRNDEV2
PRNDEV2  LABEL	 WORD			 ;HEADER FOR DEVICE "PRN"
	dw	TIMDEV - DOSENTRYDEVICEBASE * 16, seg TIMDEV + DOSENTRYDEVICEBASE
	DW	CHARDEV + OUTTILBUSY + DEV320
	DW	strategyentry - DOSENTRYDEVICEBASE * 16
	DW	prnentry - DOSENTRYDEVICEBASE * 16
	DB	'PRN     '

	EVENB
	PUBLIC TIMDEV
TIMDEV	LABEL	WORD
	dw	DSKDEV - DOSENTRYDEVICEBASE * 16, seg DSKDEV + DOSENTRYDEVICEBASE
	DW	10000000_00001000B
	DW	strategyentry - DOSENTRYDEVICEBASE * 16
	DW	clockentry - DOSENTRYDEVICEBASE * 16
	DB	'CLOCK$  '

	EVENB
	PUBLIC	DSKDEV
DSKDEV	LABEL	WORD
	dw	COM1DEV - DOSENTRYDEVICEBASE * 16, seg COM1DEV + DOSENTRYDEVICEBASE
	DW	00001000_01000010B	;J.K.I1. 32 bit sector calculation
	DW	strategyentry - DOSENTRYDEVICEBASE * 16
	DW	blockentry - DOSENTRYDEVICEBASE * 16
DRVMAX	DB	4
	PUBLIC DRVMAX


usesection SYSINITTRAIL

	  PUBLIC HARDNUM
HARDNUM 	DB	99			;LOGICAL DRIVE NUMBER OF FIRST HARDFILE


usesection DOSBIODATA

		EVENB
	PUBLIC WRTVERIFY
WRTVERIFY LABEL WORD
	PUBLIC RFLAG
ROMREAD equ ROMRead	; NASM port equate
RFLAG		DB	ROMREAD 		;2 FOR READ, 3 FOR WRITE
VERIFY		DB	0			;1 IF VERIFY AFTER WRITE
	PUBLIC SECCNT
SECCNT		DW	0
	PUBLIC MOTORSTARTUP,SETTLECURRENT,SETTLESLOW
MOTORSTARTUP	DB  ?			; VALUE FROM TABLE
SETTLECURRENT	DB  ?			; VALUE FROM TABLE
SETTLESLOW	DB  ?			; SLOW SETTLE VALUE

NEXTSPEED	DB  ?			; VALUE OF SPEED TO BE USED
save_head_sttl equ Save_head_sttl	; NASM port label
	public	save_head_sttl
Save_head_sttl	db  ?		;used by READ_SECTOR routine

	    PUBLIC EOT
EOT		DB  9

		EVENB
	PUBLIC DPT
DPT		DD  ?

;KEEP THE NEXT TWO ITEMS CONTIGUOUS - SEE IOCTL_BLOCK FOR REASON
	PUBLIC CURSEC,CURHD,CURTRK,SPSAV
CURSEC	DB	0			;CURRENT SECTOR
CURHD	DB	0			;CURRENT HEAD
CURTRK	DW	0			;CURRENT TRACK
SPSAV	DW	0			;SAVE THE STACK POINTER

; THE FOLLOWING ARE USED FOR IOCTL FUNCTION CALLS
	PUBLIC FORMT_EOT,HDNUM,TRKNUM,GAP_PATCH
FORMT_EOT	DB	8		    ; EOT USED FOR FORMAT
HDNUM		DB	0		    ; HEAD NUMBER
TRKNUM		DW	0		    ; TRACK BEING MANIPULATED
GAP_PATCH	DB	50H		    ; FORMAT GAP PATCHED INTO DPT

;DISK ERRORS RETURNED FROM THE IBM ROM
	PUBLIC ERRIN
ERRIN	LABEL	BYTE
	db	0cch			;AN002; Write Fault error
	DB	80H			;NO RESPONSE
	DB	40H			;SEEK FAILURE
	DB	10H			;BAD CRC
	DB	8			;DMA OVERRUN
	DB	6			; MEDIA CHANGE
	DB	4			;SECTOR NOT FOUND
	DB	3			;WRITE ATTEMPT TO WRITE-PROTECT DISK
	PUBLIC LSTERR
LSTERR	DB	0			;ALL OTHER ERRORS

;RETURNED ERROR CODES CORRESPONDING TO ABOVE
	PUBLIC ERROUT
ERROUT	LABEL	BYTE
	db	10			;AN002; Write Fault error
	DB	2			;NO RESPONSE
	DB	6			;SEEK FAILURE
	DB	4			;BAD CRC
	DB	4			;DMA OVERRUN
	DB	15			; INVALID MEDIA CHANGE
	DB	8			;SECTOR NOT FOUND
	DB	0			;WRITE ATTEMPT ON WRITE-PROTECT DISK
	DB	12			;GENERAL ERROR
	PUBLIC NUMERR
NUMERR	equ	ERROUT-ERRIN


;*********************************************************************
;	"BDS" CONTAINS INFORMATION FOR EACH DRIVE IN THE SYSTEM.
;	VARIOUS VALUES ARE PATCHED WHENEVER ACTIONS ARE PERFORMED.
;	SECTORS/ALLOC. UNIT IN BPB INITIALLY SET TO -1 TO SIGNIFY THAT
;	THE BPB HAS NOT BEEN FILLED. LINK ALSO SET TO -1 TO SIGNIFY END
;	OF LIST. # OF CYLINDERS IN MAXPARMS INITIALIZED TO -1 TO INDICATE
;	THAT THE PARAMETERS HAVE NOT BEEN SET.
;

BPBTYPE STRUC
SPF	DB	?
SPT	DB	?
CDIRE	DB	?
CSEC	DW	?
SPA	DB	?
CHEAD	DB	?
BPBTYPE ENDS
	PUBLIC SM92
SM92:
BPBTYPE_size equ BPBTYPE_struc_size	; NASM port equate
istruc BPBTYPE
at SPF
	db 3
at SPT
	db 9
at CDIRE
	db 70H
at CSEC
	dw 2*9*80
at SPA
	db 2
at CHEAD
	db 2
iend


	usesection DOSENTRY

transfer_orig13:
 assume ds:nothing, es:nothing, ss:nothing
	jmp far [cs:ORIG13]		; cs reference in DOSENTRY

%if ($ - $$) < DOSENTRYDEVICEBASE * 16
 %error Header must be above or equal device base
%endif
	EVENB
	PUBLIC COM1DEV
COM1DEV LABEL	WORD
	dw	LPT1DEV - DOSENTRYDEVICEBASE * 16, seg LPT1DEV + DOSENTRYDEVICEBASE
	DW	10000000_00000000B
	DW	strategyentry - DOSENTRYDEVICEBASE * 16
	DW	com1entry - DOSENTRYDEVICEBASE * 16
	DB	'COM1    '

	odd
 global transfer_real13
transfer_real13:
 assume ds:nothing, es:nothing, ss:nothing
	db 0EAh
	PUBLIC REAL13
REAL13	DD  ?

%assign num BASE700h + 16Ch - ($-$$)
%warning num bytes in front of AUXNUM
	org BASE700h + 16Ch	; noted in EDR-DOS sources as a fixed offset
	EVENB
; WARNING!!!  THESE ARE ADDRESSED TOGETHER IN GETDX
AUXNUM	DB	0			;WHICH AUX DEVICE WAS REQUESTED
	DB	0


usesection DOSBIODATA

		EVENB
	PUBLIC DAYCNT
DAYCNT	DW	0


usesection DOSENTRY

%if ($ - $$) < DOSENTRYDEVICEBASE * 16
 %error Header must be above or equal device base
%endif
	EVENB
	PUBLIC LPT1DEV
LPT1DEV LABEL	WORD
	dw	LPT2DEV - DOSENTRYDEVICEBASE * 16, seg LPT2DEV + DOSENTRYDEVICEBASE
	DW	CHARDEV + OUTTILBUSY + DEV320
	DW	strategyentry - DOSENTRYDEVICEBASE * 16
	DW	lpt1entry - DOSENTRYDEVICEBASE * 16
	DB	'LPT1    '

	EVENB
	PUBLIC	LPT2DEV
LPT2DEV LABEL	WORD
	dw	LPT3DEV - DOSENTRYDEVICEBASE * 16, seg LPT3DEV + DOSENTRYDEVICEBASE
	DW	CHARDEV + OUTTILBUSY + DEV320
	DW	strategyentry - DOSENTRYDEVICEBASE * 16
	DW	lpt2entry - DOSENTRYDEVICEBASE * 16
	DB	'LPT2    '

	EVENB
	PUBLIC	LPT3DEV
LPT3DEV LABEL	WORD
	dw	COM2DEV - DOSENTRYDEVICEBASE * 16, seg COM2DEV + DOSENTRYDEVICEBASE
	DW	CHARDEV + OUTTILBUSY + DEV320
	DW	strategyentry - DOSENTRYDEVICEBASE * 16
	DW	lpt3entry - DOSENTRYDEVICEBASE * 16
	DB	'LPT3    '


	EVENB
	PUBLIC	COM2DEV
COM2DEV LABEL	WORD
	dw	COM3DEV - DOSENTRYDEVICEBASE * 16, seg COM3DEV + DOSENTRYDEVICEBASE
	DW	10000000_00000000B
	DW	strategyentry - DOSENTRYDEVICEBASE * 16
	DW	com2entry - DOSENTRYDEVICEBASE * 16
	DB	'COM2    '

	EVENB
	PUBLIC	COM3DEV
COM3DEV LABEL	WORD			;EDK
	dw	COM4DEV - DOSENTRYDEVICEBASE * 16, seg COM4DEV + DOSENTRYDEVICEBASE
	DW	10000000_00000000B
	DW	strategyentry - DOSENTRYDEVICEBASE * 16
	DW	com3entry - DOSENTRYDEVICEBASE * 16
	DB	'COM3    '

	EVENB
	PUBLIC	COM4DEV
COM4DEV LABEL	WORD			;EDK
	DW	-1,DOSENTRY + DOSENTRYDEVICEBASE
	DW	10000000_00000000B
	DW	strategyentry - DOSENTRYDEVICEBASE * 16
	DW	com4entry - DOSENTRYDEVICEBASE * 16
	DB	'COM4    '


usesection DOSBIODATA

	EVENB
	PUBLIC START_BDS
START_BDS LABEL WORD
       dw      -1,-1			; START OF BDS LINKED LIST.

	PUBLIC ACCESSCOUNT
ACCESSCOUNT	DB	0		; NUMBER OF TIMES MEDIA CHECK CALLED
	PUBLIC TIM_DRV
TIM_DRV 	DB	-1		; TIME WHEN LAST DISK I/O PERFORMED
	PUBLIC	MEDBYT
MEDBYT		DB	?

		; end of data that must be after 16Ch.

;-------------------------------------------------------------


usesection DOSENTRY

 global i2D, i2D.amisnumber, amis_intlist
				; used with DOSENTRY adjust
iispentry i2D, 0, i2D, 1, \
  entry_iret + DOSENTRYADJUSTOFFSET, DOSENTRY - DOSENTRYADJUSTSEGMENT
	cmp ah, 0
.amisnumber: equ $ - 1		; imm8 data of cmp instruction
	je .ours
	jmp far [cs:.next + DOSENTRYADJUSTOFFSET]
.ours:
 %if _RELOCATEDOSCODE
	relocate relocatedi2D
.hwreset equ $ - 2		; ! use the trampoline retf for hwreset
 %else
 extern relocatedi2D
	jmp relocatedi2D
.hwreset:
	retf
 %endif
amis_intlist:
	db 2Dh
	dw i2D + DOSENTRYADJUSTOFFSET


	PUBLIC	incompatible_ALTAH
incompatible_ALTAH	DB	0	;SPECIAL KEY HANDLING


;   READ IN BOOT SECTOR HERE,  READ DONE IN READBOOT.
;   ALSO READ SECTOR FOR DMA CHECK FOR HARD DISK.

;J.K. The buffer for a disk sector is going to be at a double word boundary
;     for 80386 machine.

	align 16, db 0		; ! paragraph alignment needed for msinit.nas
DISKSECTOR equ DiskSector	; NASM port label
       PUBLIC DISKSECTOR
DiskSector		DB	11 DUP(?) ; TAKE CARE OF 3 JUMP BYTES PLUS OEM NAME.
BPB_IN_SECTOR equ Bpb_In_Sector	; NASM port label
	PUBLIC BPB_IN_SECTOR
Bpb_In_Sector		DW	?
SECPERCLUSINSECTOR equ SecPerClusInSector	; NASM port label
	PUBLIC SECPERCLUSINSECTOR
SecPerClusInSector	DB	?
			DW	?
	public NumberOfFats
NumberOfFats		DB	?
			DW	?
			DW	?
MEDIABYTE equ MediaByte	; NASM port label
	PUBLIC MEDIABYTE
MediaByte		DB	?
			DW	?
			DW	?
			DW	?
			DW	?
			DW	?	;AN000; Extended Hidden sector (high)
			DW	?	;AN000; Extended Total sector (low)
			DW	?	;AN000; Extended Total sector (high)
			db	?	;AN003; PHYDRV in boot record.
			db	?	;AN003; CURRENT HEAD in boot record.
	public Ext_Boot_Sig
Ext_Boot_Sig		DB	?	;AN000; Extended Boot record sig. (=90h)
	public Boot_Serial_L
Boot_Serial_L		DW	?	;AN000; Boot volume serial number (Low)
	public Boot_Serial_H
Boot_Serial_H		DW	?	;AN000; Boot volume serial number (High)
	public Boot_Volume_Label
Boot_Volume_Label	DB	11 dup (' ') ;AN000; Volume label
	public Boot_System_ID
Boot_System_ID		DB	8  dup (' ') ;AN000; File system Id.
		times	512-($-DiskSector) db 0


	usesection DOSBIODATA

;;Rev 3.30 Modification ------------------------------------------------
; variables for real time clock setting
	public	HaveCMOSClock
HaveCMOSClock	db	0	;set by MSINIT.
	public	base_century
base_century	db	19
	public	base_year
base_year	db	80
	public	month_tab
month_tab	db	31,28,31,30,31,30,31,31,30,31,30,31

;;End of Modification ------------------------------------------------


	usesection DOSBIODATA

Set_ID_Flag	db	0	;AN000; If 1, GETBP routine will set the
				;Vol_Serial and FileSys_ID in BDS table
				;from the media Boot record, if it is > DOS 4.00
				;formatted one. Then Set_ID_flag will be set to 2
				;to signal that volume_label is set from the extended
				;boot record and do not set it from the root
				;directory as done in SET_VOLUME_ID routine.
				;For the old version, Vol_Serial
				;will be set to -1, and FileSys_ID will be set
				;to "FAT12   " if it is a floppy.

	evenb
	public lbapacket
lbapacket:
LBAPACKETSTRUC_size equ LBAPACKETSTRUC_struc_size	; NASM port equate
istruc LBAPACKETSTRUC
at lpSize
	dw 16
iend

	public	Temp_H
Temp_H		dw	0		;AN000; Temporary for 32 bit calculation.

	public	Start_Sec_H
Start_Sec_H	dw	0		;AN000; Starting sector number high word.
					;Used as an input to DISKIO subroutine.
Saved_Word	dw	0		;AN000;  Tempory saving place for a word.

;---------------------------------------
;J.K. 6/29/87 For Multi-track
	public	MulTrk_Flag
MulTrk_Flag	dw	0		;AN001;
;J.K. 6/29/87 End of Multi-track definition.
;---------------------------------------------------------------------
	public EC35_Flag
EC35_Flag	db	0		; flags for electrically compatible 3.5 inch disk drives (mrw 4/88)
;---------------------------------------------------------------------
	evenb
VRetry_Cnt	dw	0		;AN003;
Soft_ECC_Cnt	dw	0		;AN003;

;---------------------------------------------------------------------
MultiTrk_Format_Flag	db	0	;AN007;Testing. If 1, then Multi track format request
;---------------------------------------------------------------------
;
; IF ID IS F9, HAVE A 96TPI DISK ELSE
; IF BIT 2 IS 0 THEN MEDIA IS NOT REMOVABLE AND COULD NOT HAVE CHANGED
;  OTHERWISE IF WITHIN 2 SECS OF LAST DISK OPERATION MEDIA COULD NOT
;    HAVE CHANGED, OTHERWISE DONT KNOW IF MEDIA HAS CHANGED
;


	usesection DOSBIODATA

	align 2, db 0
Prev_DX			DW ?


	global Set_ID_Flag, Saved_Word
	global VRetry_Cnt, Soft_ECC_Cnt, MultiTrk_Format_Flag
	global Prev_DX, dosbiodata_temp_ds
	global transfer_orig13
	global transfer_next2F_13


	usesection DOSBIODATA

	PATHSTART 005,DISK
	EVENB
Model_Byte equ MODEL_BYTE	; NASM port label
	public	Model_Byte
MODEL_BYTE DB	0FFH			; MODEL BYTE. SET UP AT INIT TIME.
					; FF - PC1
					; FE - XT (64/256K PLANAR)
					; FD - PC-JR
					; FC - PC/AT
	public	Secondary_Model_Byte
Secondary_Model_Byte db 0

	PUBLIC	INT19SEM
INT19SEM DB	0			; INDICATE THAT ALL INT 19
					; INITIALIZATION IS COMPLETE


%macro int19old 1-*
 %rep %0
	public	Int19OLD%1
Int19OLD%1	dd	-1		;Orignal hardware int. vectors for INT 19h.
  %rotate 1
 %endrep
%endmacro

	align 2, db 0
	int19old 02,08,09,0A,0B,0C,0D,0E,70,72,73,74,76,77


	PATHEND 005,DISK
; = = = = = = = = = = = = = = = = = = = =

	global SNGMSG
	global DRVLET

;	 INCLUDE BIOMES.INC
;=== Push trace listing source: msbio.cl2
         %include "msbio.cl2" ; NASM included file
;=== Pop trace listing source


	usesection DOSENTRY

;-----------------------------------------------
;
;	C O N - CONSOLE DEVICE DRIVER
;

%if 0
%assign num BASE700h + 61Bh - ($-$$)
%warning num bytes in front of ALTAH

	org BASE700h + 61Bh	; noted in EDR-DOS sources as a fixed offset
%endif

	usesection DOSBIODATA

	align 2, db 0
	global altah_indirect
altah_indirect:		dw incompatible_ALTAH

	public	KEYRD_Func
KEYRD_Func DB	0			;AN000; Default is conventional keyboard read
	public	KEYSTS_Func
KEYSTS_Func DB	1			;AN000; Defualt if conventional keyboard status check.

%if KEYRD_Func + 1 != KEYSTS_Func
 %error msinit.nas assumes KEYSTS_Func directly after KEYRD_Func
%endif

;	 PUBLIC  SAV_SC_INFO		 ;J.K. 4/29/86 FOR CON$GENIOCTL
;	 PUBLIC  SAV_SC_MODE
;	 PUBLIC  SAV_SC_COLORS
;	 PUBLIC  SAV_SC_WIDTH
;	 PUBLIC  SAV_SC_LENGTH
;SAV_SC_INFO	 LABEL	 BYTE
;SAV_SC_MODE	 DB	 0
;SAV_SC_COLORS	 DW	 0
;SAV_SC_WIDTH	 DW	 0
;SAV_SC_LENGTH	 DW	 0		 ;J.K. 4/29/86 FOR CON$GENIOCTL

;-------------------------------------------------------------
;
;	P R N - PRINTER DEVICE
;
	PUBLIC PRINTDEV
PRINTDEV	DB	0		; INDEX INTO ABOVE ARRAY

; THE FOLLOWING VARIABLE CAN BE MODIFIED VIA IOCTL SUB-FUNCTION 16. IN THIS
; WAY, THE WAIT CAN BE SET TO SUIT THE SPEED OF THE PARTICULAR PRINTER BEING
; USED. ONE FOR EACH PRINTER DEVICE.

		EVENB
	PUBLIC WAIT_COUNT
WAIT_COUNT	DW	4 DUP (50H)	; ARRAY OF RETRY COUNTS FOR PRINTER

dosbiodata_temp_ds:	dw 0


	usesection DOSBIODATA

	EVENB
	global dskdrvs_indirect
dskdrvs_indirect:
	dd 0


	%IF	itest		 ;Testing Mode for IBMBIO.
	    PUBLIC  NUMBUF
NUMBUF	    DB	    5 DUP (?)
	    PUBLIC  DIGITS
DIGITS	    DB	    "0123456789ABCDEF"
	    PUBLIC  FTESTBITS
;FTESTBITS   DW      FTESTDISK+FTESTINIT
fTestDISK equ FTESTDISK	; NASM port equate
FTESTBITS   DW	    fTestDISK
;ftestbits dw ftestclock
	%ENDIF


%include "code.asm"

	PATHEND 001,BIO

