;	SCCSID = @(#)crit.asm	1.1 85/04/10
;TITLE CRIT - Critical Section Routines
;NAME  CRIT
;
; Critical Section Routines
;
;   Critical section handlers
;
;   Modification history:
;
;       Created: ARR 30 March 1983
;

[list -]
;
; get the appropriate segment definitions
;
%include "lmacros2.mac"
%include "dosseg.nas"

[list +]
section DOSCODECODE

global ECritDisk
global ECritMem
global ECritSFT
global LCritDisk
global LCritMem
global LCritSFT

ECritDisk:
ECritMem:
ECritSFT:
	push bx
	mov bx, patch_dosdata_EcritDisk
	jmp transfer_doscode_to_dosdata

LCritDisk:
LCritMem:
LCritSFT:
	push bx
	mov bx, patch_dosdata_LcritDisk
	jmp transfer_doscode_to_dosdata

global ECritDevice
global LCritDevice

ECritDevice:
	push bx
	mov bx, patch_dosdata_EcritDevice
	jmp transfer_doscode_to_dosdata

LCritDevice:
	push bx
	mov bx, patch_dosdata_LcritDevice

global transfer_doscode_to_dosdata

transfer_doscode_to_dosdata:
 assume ds:nothing, es:nothing, ss:nothing
	lframe 0
	lpar word, in_ip_out_cs
	lpar word, in_bx_out_ip
	lpar word, in_ax_out_dosdata_retf
	 push ax			; ?in_ax = ax
	call doscode_getdosdata
	lpar dword, transferto
	 push ax			; ?transferto + 2 = DOSDATA
	 push bx			; ?transferto = entrypoint
	lenter
	mov bx, cs
	xchg bx, [bp + ?in_ip_out_cs]	; ?out_cs = cs
	xchg bx, [bp + ?in_bx_out_ip]	; ?out_ip = ip
					; bx = ?in_bx
	mov ax, dosdata_retf
	xchg ax, [bp + ?in_ax_out_dosdata_retf]
					; ?out_dosdata_retf = dosdata_retf
					; ax = ?in_ax
	lleave , optimiserestoresp
	retf				; branch to ?transferto,
					; ?out_dosdata_retf and ?out_csip on stack

global doscode_getdosdata
doscode_getdosdata:
 assume ds:nothing
	push ds
	mov ax, 0
	mov ds, ax			; ds => IVT
 assume ds:IVT
	mov ax, [31h * 4 + 2]		; ds => DOSDATA
	pop ds
 assume ds:nothing
	retn


section DOSDATACODE	; in DOSDATA

dosdata_retf:
	retf

[list -]

;.xcref
%include "dossym.mac"
;.cref
[list +]

	I_need  User_In_AX,WORD
	i_need  CurrentPDB,WORD
%if debug
	I_need  BugLev,WORD
	I_need  BugTyp,WORD
%include "bugtyp.nas"
%endif

Break   <Critical section handlers>

;
;   Each handler must leave everything untouched; including flags!
;
;   Sleaze for time savings:  first instruction is a return.  This is patched
;   by the sharer to be a PUSH AX to complete the correct routines.
;

global patch_dosdata_EcritDisk
patch_dosdata_EcritDisk:
	RETn
;       PUSH    AX
	fmt     TypSect,LevReq,<"PDB $x entering $x">,<CurrentPDB,sect>
	MOV     AX,8000h+critDisk
int_ibm equ int_IBM	; NASM port equate
	INT     int_ibm
	POP     AX
	retn

global patch_dosdata_LcritDisk
patch_dosdata_LcritDisk:
	RETn
;       PUSH    AX
	fmt     TypSect,LevReq,<"PDB $x entering $x">,<CurrentPDB,sect>
	MOV     AX,8100h+critDisk
	INT     int_ibm
	POP     AX
	retn

global patch_dosdata_EcritDevice
patch_dosdata_EcritDevice:
	RETn
;       PUSH    AX
	fmt     TypSect,LevReq,<"PDB $x entering $x">,<CurrentPDB,sect>
	MOV     AX,8000h+critDevice
	INT     int_ibm
	POP     AX
	retn

global patch_dosdata_LcritDevice
patch_dosdata_LcritDevice:
	RETn
;       PUSH    AX
	MOV     AX,8100h+critDevice
	INT     int_ibm
	POP     AX
	retn

    END
