;;****************************************************************************				  ;;AN000;
;;     Assembler MACROS for use with SELECT.								  ;;AN000;
;;     File: MACROS6.INC										  ;;AN000;
;;     Latest Change Date: July 27, 1987								  ;;AN000;
;;													  ;;AN000;
;; These macros define powerful assembler verbs neccessary for SELECT.					  ;;AN000;
;;													  ;;AN000;
;; Note: Many of the macros make use of an ASCII-N string for passing					  ;;AN000;
;;	 parameters.  The string is defined below.							  ;;AN000;
;;		   DW  count										  ;;AN000;
;;		   DB  "string_variable",?                                                                ;;AN000;
;;													  ;;AN000;
;;	 COUNT is the length of the string and is a word.						  ;;AN000;
;;	 It is necessary to follow the string with at least one byte for the				  ;;AN000;
;;	 purpose of changing the ASCII-N string to an ASCII-Z string.					  ;;AN000;
;;													  ;;AN000;
;;****************************************************************************				  ;;AN000;
page					;;AN000;							  ;;AN000;
;;****************************************************************************				  ;;AN000;
;;													  ;;AN000;
;;   SCAN_PARAMETERS: Scan SELECT command line for parameters.						  ;;AN000;
;;													  ;;AN000;
;;   SYNTAX:  SCAN_PARAMETERS	mode									  ;;AN000;
;;													  ;;AN000;
;;   INPUT:												  ;;AN000;
;;	 PSP command line										  ;;AN000;
;;													  ;;AN000;
;;   OUTPUT:												  ;;AN000;
;;	 mode	  = Install mode									  ;;AN000;
;;		  = 0: Parameter is MENU								  ;;AN000;
;;		  = 1: Parameter is FDISK								  ;;AN000;
;;		  = 0FFH: Parameter is invalid								  ;;AN000;
;;													  ;;AN000;
;;   OPERATION:  The SELECT command line is scanned for parameters.  The				  ;;AN000;
;;	 return codes for the various parameters are provided in variables				  ;;AN000;
;;	 defined above. 										  ;;AN000;
;;													  ;;AN000;
;;  Note:												  ;;AN000;
;;	 Before this macro is executed, there must be as ASSUME ES:DATA 				  ;;AN000;
;;	 statement.  If not, the parser will not execute properly and					  ;;AN000;
;;	 either the computer will hang or erroneous values will be returned.				  ;;AN000;
;;													  ;;AN000;
;;****************************************************************************				  ;;AN000;
SCAN_PARAMETERS    MACRO     MODE									  ;;AN000;
													  ;;AN000;
    CALL SCAN_PARAMETERS_ROUTINE									  ;;AN000;
    MOV  MODE, AX											  ;;AN000;
    ENDM												  ;;AN000;
;;****************************************************************************				  ;;AN000;
;;													  ;;AN000;
;;   SCAN_INFO_FILE: Scan SELECT.TMP for parameters.							  ;;AN000;
;;													  ;;AN000;
;;   SYNTAX:  SCAN_INFO_FILE   option_0, option_1, option_2, option_3, path, filename, buffer, buff_size		  ;;AC033;SEH add option_3 parameter
;;													  ;;AN000;
;;   INPUT:												  ;;AN000;
;;	 filename  = The name of the file which contains the FDISK parameters.				  ;;AN000;
;;		     (ASCII-N format)									  ;;AN000;
;;	 buffer    = A buffer where the data read from the file can be stored.				  ;;AN000;
;;	 buff_size = The size of the buffer.								  ;;AN000;
;;													  ;;AN000;
;;   OUTPUT:												  ;;AN000;
;;	 option_1 = 1											  ;;AC033;
;;		  = 2											  ;;AC033;
;;		  = 3											  ;;AC033;
;;		  = 0FFh: Parameter is invalid (not 1, 2, 3)						  ;;AC033;
;;	 option_2 = 1											  ;;AC033;
;;		  = 2											  ;;AC033;
;;		  = 0FFh: Parameter is invalid (not 1, 2)						  ;;AC033;
;;	 option_3 = 1											  ;;AC033;
;;		  = 2											  ;;AC033;
;;		  = 0FFh: Parameter is invalid (not 1, 2)						  ;;AC033;
;;	 path	  = Install path in ASCII-N format							  ;;AN000;
;;													  ;;AN000;
;;   OPERATION: 											  ;;AN000;
;;	 If the parameter on the command line is FDISK, then the					  ;;AN000;
;;	 file specified in FILENAME is opened and additional parameters 				  ;;AN000;
;;	 are read.  If the parameters in the file are invalid, or if the file				  ;;AN000;
;;	 cannot be found, then 0FFh is returned in MODE and OPTION, and the				  ;;AN000;
;;	 path length is set to zero.									  ;;AN000;
;;													  ;;AN000;
;;****************************************************************************				  ;;AN000;
SCAN_INFO_FILE	  MACRO     OPTION_0, OPTION_1, OPTION_2, OPTION_3, PATH, FILENAME, BUFFER, BUFF_SIZE
													  ;;AN000;
    MOV  AX, OFFSET PATH										  ;;AN000;
    PUSH AX												  ;;AN000;
    MOV  AX, OFFSET FILENAME										  ;;AN000;
    PUSH AX												  ;;AN000;
    MOV  AX, OFFSET BUFFER										  ;;AN000;
    PUSH AX												  ;;AN000;
    MOV  AX, BUFF_SIZE											  ;;AN000;
    PUSH AX												  ;;AN000;
    CALL SCAN_INFO_FILE_ROUTINE 									  ;;AN000;
    mov  option_0, ax
    MOV  OPTION_1, BX											  ;;AN000;
    MOV  OPTION_2, CX											  ;;AN000;
    MOV  OPTION_3, DX											  ;;AN033;SEH return OPTION_3, also
    ENDM												  ;;AN000;
;;****************************************************************************				  ;;AN000;
;;													  ;;AN000;
;;   COPY_FILES:  Copy a list of files from the A diskette to either the B				  ;;AN000;
;;	 or C drive.											  ;;AN000;
;;													  ;;AN000;
;;   SYNTAX:  COPY_FILES target_disk, file_table, num_files, path					  ;;AN000;
;;													  ;;AN000;
;;   INPUT:												  ;;AN000;
;;	 target_disk = 1: Copy the files to the B drive 						  ;;AN000;
;;		     = 2: Copy the files to the C drive 						  ;;AN000;
;;													  ;;AN000;
;;	 path	     = The path where the files are to be copied if the 				  ;;AN000;
;;		       destination is the hard disk.							  ;;AN000;
;;													  ;;AN000;
;;	 file_table  = A table listing the files to copy.  It is of the 				  ;;AN000;
;;		       following format.								  ;;AN000;
;;													  ;;AN000;
;;		       db     filename									  ;;AN000;
;;													  ;;AN000;
;;	      - The filename must be padded out to 12 characters.					  ;;AN000;
;;													  ;;AN000;
;;	 num_files   = The number of files in the list. 						  ;;AN000;
;;													  ;;AN000;
;;   OUTPUT:												  ;;AN000;
;;	 None.												  ;;AN000;
;;													  ;;AN000;
;;   OPERATION:  The files listed in the table are copied to the destination				  ;;AN000;
;;	      from the A drive.  If the destination is C, then a path					  ;;AN000;
;;	      path can be specified.									  ;;AN000;
;;													  ;;AN000;
;;****************************************************************************				  ;;AN000;
COPY_FILES    MACRO	DEST, FILE_TABLE, NUM_FILES							  ;;AN000;
													  ;;AN000;
    MOV  AX, DEST											  ;;AN000;
    MOV  BX, OFFSET FILE_TABLE										  ;;AN000;
    MOV  CX, NUM_FILES											  ;;AN000;
    CALL HOOK_INT_24		;AN000;JW								  ;;AN000;JW
    CALL MOD_XCOPY											  ;;AN000;
    CALL  RESTORE_INT_24	;AN000;JW								  ;;AN000;JW
    ENDM												  ;;AN000;
													  ;;AN000;JW
COPY_FILES2   MACRO	DEST, FILE_TABLE, NUM_FILES, PATH						  ;;AN111;JW
													  ;;AN111;JW
    MOV  AX, DEST											  ;;AN111;JW
    MOV  BX, OFFSET FILE_TABLE										  ;;AN111;JW
    MOV  CX, NUM_FILES											  ;;AN111;JW
    MOV  SI, OFFSET PATH										  ;;AN111;JW
    CALL HOOK_INT_24		;AN000;JW								  ;;AN111;JW
    CALL MOD_XCOPY											  ;;AN111;JW
    CALL  RESTORE_INT_24	;AN000;JW								  ;;AN111;JW
    ENDM												  ;;AN111;JW
													  ;;AN000;
;;****************************************************************************				  ;;AN000;
;;													  ;;AN000;
;;   INSTALL_FILES: Install the files from the original diskettes to the				  ;;AN000;
;;	 startup and the operations diskette.								  ;;AN000;
;;													  ;;AN000;
;;   SYNTAX:  INSTALL_FILES  source_disk, target_disk							  ;;AN000;
;;													  ;;AN000;
;;   INPUT:												  ;;AN000;
;;	 source_disk = 1: Read the files from the first diskette					  ;;AN000;
;;		     = 2: Read the files from the second diskette					  ;;AN000;
;;													  ;;AN000;
;;	 target_disk = 1: Copy the files to the start-up diskette					  ;;AN000;
;;		     = 2: Copy the files to the operations diskette					  ;;AN000;
;;		     = 3: Copy the files to the hard disk						  ;;AN000;
;;													  ;;AN000;
;;   OUTPUT:												  ;;AN000;
;;	 None.												  ;;AN000;
;;													  ;;AN000;
;;   OPERATION: 											  ;;AN000;
;;													  ;;AN000;
;;****************************************************************************				  ;;AN000;
INSTALL_FILES MACRO	SOURCE_DISK, TARGET_DISK							  ;;AN000;
													  ;;AN000;
    COPY_FILES	   SOURCE_DISK, TARGET_DISK, S_INSTALL_PATH, DOS_FILES, NUM_DOS_FILES			  ;;AN000;
    ENDM												  ;;AN000;
;;****************************************************************************				  ;;AN000;
;;													  ;;AN000;
;;   GET_PRINTER_TITLES: Read the printer profile file and load the printer				  ;;AN000;
;;	 names into a table.										  ;;AN000;
;;													  ;;AN000;
;;   SYNTAX:  GET_PRINTER_TITLES   filename								  ;;AN000;
;;													  ;;AN000;
;;   INPUT:												  ;;AN000;
;;	 filename = A ASCII-N string containing the name of the file containing 			  ;;AN000;
;;		    the printer profile.								  ;;AN000;
;;													  ;;AN000;
;;   OUTPUT:												  ;;AN000;
;;    If CY = 0, No error was encountered.  The following information is returned:			  ;;AN000;
;;	 SEGMENT_LOCATION	= The segment where the printer names table is held ( 16 bit )		  ;;AN000;
;;	 NAMES_TABLE_OFFSET	= The offset in the segment of the printer names table ( 16 bit )	  ;;AN000;
;;	 LONGEST_NAME		= The longest printer name in the file ( 16 bit )			  ;;AN000;
;;	 SIZE_NAMES_TABLE_ENTRY = The number of bytes between each printer name in the table (abs value ) ;;AN000;
;;	 PRINTER_NAME_INDEX	= The number of names in the table. ( 16 bit )				  ;;AN000;
;;    If CY = 1, An error was encountered.								  ;;AN000;
;;	 BX - Contains an error number as defined below.						  ;;AN000;
;;	 AX - Contains the DOS error number if the error listed in BX is a				  ;;AN000;
;;	      file related error.									  ;;AN000;
;;													  ;;AN000;
;;	 Error number			    Explaination.						  ;;AN000;
;;													  ;;AN000;
;;	      1 	     There is not enough memory to build the names				  ;;AN000;
;;			     table and provide a data buffer for reading the				  ;;AN000;
;;			     file information.								  ;;AN000;
;;													  ;;AN000;
;;	      2 	     There was an error opening the printer profile file.			  ;;AN000;
;;			     AX contains the DOS error code.						  ;;AN000;
;;													  ;;AN000;
;;	      3 	     There was an error reading the printer profile file.			  ;;AN000;
;;			     AX contains the DOS error code.						  ;;AN000;
;;													  ;;AN000;
;;	      4 	     The number at the beginning of the printer profile 			  ;;AN000;
;;			     giving the number of definitions in the file was				  ;;AN000;
;;			     either missing or was greater then 255.					  ;;AN000;
;;													  ;;AN000;
;;	      5 	     A line in the printer profile file was found to				  ;;AN000;
;;			     be longer then allowed in the buffer.					  ;;AN000;
;;													  ;;AN000;
;;	      6 	     There was an error find a printer name in the file 			  ;;AN000;
;;													  ;;AN000;
;;	      7 	     There was an error updating the file pointer				  ;;AN000;
;;													  ;;AN000;
;;	      8 	     There are more then 255 printer definitions in the 			  ;;AN000;
;;			     file.									  ;;AN000;
;;													  ;;AN000;
;;	      9 	     The number of actual definitions in the printer profile			  ;;AN000;
;;			     file did not agree with the number given at the				  ;;AN000;
;;			     beginning of the file.							  ;;AN000;
;;													  ;;AN000;
;;	     10 	     There was an error allocating the memory needed for			  ;;AN000;
;;			     the data.									  ;;AN000;
;;													  ;;AN000;
;;													  ;;AN000;
;;   OPERATION: 											  ;;AN000;
;;													  ;;AN000;
;;****************************************************************************				  ;;AN000;
GET_PRINTER_TITLES MACRO     FILENAME									  ;;AN000;
													  ;;AN000;
    MOV  DI, OFFSET FILENAME	       ; The name of the printer definition file			  ;;AN000;
    CALL GET_PRINTER_TITLES_ROUTINE    ; Subroutine to perform the function.				  ;;AN000;
    ENDM												  ;;AN000;
;;****************************************************************************				  ;;AN000;
;;													  ;;AN000;
;;   GET_PRINTER_INFO:	Given the number of a printer, this routines retrieves				  ;;AN000;
;;	 the information for this printer from the profile file.					  ;;AN000;
;;													  ;;AN000;
;;   SYNTAX:  GET_PRINTER_INFO	 printer_num								  ;;AN000;
;;													  ;;AN000;
;;   INPUT:												  ;;AN000;
;;	 printer_num = The number the printer to get the information on.				  ;;AN000;
;;		       The number is the location of this printer in the				  ;;AN000;
;;		       printer names list.								  ;;AN000;
;;   OUTPUT:												  ;;AN000;
;;	 If CY = 0, there were no errors.								  ;;AN000;
;;	 The following variable are updated with the information found in				  ;;AN000;
;;	 the file:											  ;;AN000;
;;	       I_PRINTER										  ;;AN000;
;;	       N_PRINTER_TYPE										  ;;AN000;
;;	       S_MODE_PARM										  ;;AN000;
;;	       S_CP_DRIVER										  ;;AN000;
;;	       S_CP_PREPARE										  ;;AN000;
;;	       S_GRAPH_PARM										  ;;AN000;
;;													  ;;AN000;
;;	 If CY = 1, There were errors encountered.							  ;;AN000;
;;	      BX = An error code indicating the type of error that occured.				  ;;AN000;
;;													  ;;AN000;
;;		 = 3  There was an error reading the file						  ;;AN000;
;;		 = 7  There was a error accessing the file						  ;;AN000;
;;		 = 11 A printer definition has either a CDP or a CPP					  ;;AN000;
;;			Prefix, but BOTH were not present.						  ;;AN000;
;;		 = 12 There was an error in the printer definition.					  ;;AN000;
;;			- A line was found with an invalid prefix					  ;;AN000;
;;													  ;;AN000;
;;		 If the error was a result of a DOS function, then					  ;;AN000;
;;		 on return, AX will contain the DOS error code. 					  ;;AN000;
;;													  ;;AN000;
;;   OPERATION: 											  ;;AN000;
;;													  ;;AN000;
;;****************************************************************************				  ;;AN000;
GET_PRINTER_INFO       MACRO	 VAR_PRT								  ;;AN000;
													  ;;AN000;
    MOV  AX, VAR_PRT											  ;;AN000;
    CALL GET_PRINTER_INFO_ROUTINE									  ;;AN000;
    ENDM												  ;;AN000;
													  ;;AN000;
;;****************************************************************************				  ;;AN000;
;;													  ;;AN000;
;;   RELEASE_PRINTER_INFO: Close the printer profile file and free the					  ;;AN000;
;;	 allocated memory.										  ;;AN000;
;;													  ;;AN000;
;;   SYNTAX:  RELEASE_PRINTER_INFO									  ;;AN000;
;;													  ;;AN000;
;;   INPUT:												  ;;AN000;
;;	 None.												  ;;AN000;
;;													  ;;AN000;
;;   OUTPUT:												  ;;AN000;
;;	 If CY = 0, There were no error encountered.							  ;;AN000;
;;	 If CY = 1, There was an error. 								  ;;AN000;
;;	     AX = The DOS error code for the deallocate memory function 				  ;;AN000;
;;													  ;;AN000;
;;   OPERATION: Closes the printer profile file and deallocted memory.					  ;;AN000;
;;													  ;;AN000;
;;****************************************************************************				  ;;AN000;
RELEASE_PRINTER_INFO	MACRO										  ;;AN000;
													  ;;AN000;
    CALL RELEASE_PRINTER_INFO_ROUTINE									  ;;AN000;
    ENDM												  ;;AN000;
;;****************************************************************************				  ;;AN000;
;;													  ;;AN000;
;;   GET_PRINTER_PARAMS: Get parameters for specified printer.						  ;;AN000;
;;													  ;;AN000;
;;   SYNTAX:  GET_PRINTER_PARAMS  var_prt, var_port, var_status 					  ;;AN000;
;;													  ;;AN000;
;;   INPUT:												  ;;AN000;
;;	 var_prt  = The printer number. 								  ;;AN000;
;;	 var_port = The number of the port to retrieve the information on.				  ;;AN000;
;;		    If var_port = 0, the information that is returned is				  ;;AN000;
;;		    that which cooresponds to var_prt.							  ;;AN000;
;;	   var_port = 0 : Get the information on printer number VAR_PRT 				  ;;AN000;
;;		    = 1 : Get the information for the printer attached to LPT1				  ;;AN000;
;;		    = 2 : Get the information for the printer attached to LPT2				  ;;AN000;
;;		    = 3 : Get the information for the printer attached to LPT3				  ;;AN000;
;;		    = 4 : Get the information for the printer attached to COM1				  ;;AN000;
;;		    = 5 : Get the information for the printer attached to COM2				  ;;AN000;
;;		    = 6 : Get the information for the printer attached to COM3				  ;;AN000;
;;		    = 7 : Get the information for the printer attached to COM4				  ;;AN000;
;;													  ;;AN000;
;;   OUTPUT:												  ;;AN000;
;;	 var_status = 1: Printer information is valid							  ;;AN000;
;;		    = 0: Printer not valid: default values returned					  ;;AN000;
;;													  ;;AN000;
;;   OPERATION: Printer information for the specified printer is returned.				  ;;AN000;
;;	 If the specified printer is not defined, default values will be				  ;;AN000;
;;	 returned.											  ;;AN000;
;;	      I_PRINTER      = Index into printer list (16 bit variable) : default 1			  ;;AN000;
;;	      N_PRINTER_TYPE = P: Parallel printer							  ;;AN000;
;;			     = S: Serial printer							  ;;AN000;
;;	      I_PORT	     = Port number	       (16 bit variable) : default 1			  ;;AN000;
;;	      I_REDIRECT     = Redirection port number (16 bit variable) : default 1			  ;;AN000;
;;	      S_MODE_PARM    = Mode parameters		   - ASCII-N format				  ;;AN000;
;;	      S_CP_DRIVER    = Code page driver parameters - ASCII-N format				  ;;AN000;
;;	      S_CP_PREPARE   = Code prepare parameters	   - ASCII-N format				  ;;AN000;
;;	      S_GRAPH_PARM   = Graphics parameters	   - ASCII-N format				  ;;AN000;
;;													  ;;AN000;
;;	 The structures of printer information are searched for the one with				  ;;AN000;
;;	 the same number as specified by VAR_PRT.  If found, the information				  ;;AN000;
;;	 in that structure is returned in the variables listed above.					  ;;AN000;
;;													  ;;AN000;
;;****************************************************************************				  ;;AN000;
GET_PRINTER_PARAMS MACRO     VAR_PRT, VAR_PORT, VAR_STATUS						  ;;AN000;
													  ;;AN000;
    MOV  AX, VAR_PRT											  ;;AN000;
    MOV  BX, VAR_PORT											  ;;AN000;
    CALL GET_PRINTER_PARAMS_ROUTINE									  ;;AN000;
    MOV  VAR_STATUS, AX 										  ;;AN000;
    ENDM												  ;;AN000;
;;****************************************************************************				  ;;AN000;
;;													  ;;AN000;
;;   SAVE_PRINTER_PARAMS: Save the printer information in the printer structures			  ;;AN000;
;;													  ;;AN000;
;;   SYNTAX:  SAVE_PRINTER_PARAMS  var_prt								  ;;AN000;
;;													  ;;AN000;
;;   INPUT:												  ;;AN000;
;;	 var_prt = The printer number.									  ;;AN000;
;;													  ;;AN000;
;;   OUTPUT:												  ;;AN000;
;;	 None.												  ;;AN000;
;;													  ;;AN000;
;;   OPERATION: Printer information for the specified printer is stored.				  ;;AN000;
;;	      I_PRINTER      = Index into printer list (16 bit variable) : default 1			  ;;AN000;
;;	      N_PRINTER_TYPE = P: Parallel printer							  ;;AN000;
;;			     = S: Serial printer							  ;;AN000;
;;	      I_PORT	     = Port number	       (16 bit variable) : default 1			  ;;AN000;
;;	      I_REDIRECT     = Redirection port number (16 bit variable) : default 1			  ;;AN000;
;;	      S_MODE_PARM    = Mode parameters		   - ASCII-N format				  ;;AN000;
;;	      S_CP_DRIVER    = Code page driver parameters - ASCII-N format				  ;;AN000;
;;	      S_CP_PREPARE   = Code prepare parameters	   - ASCII-N format				  ;;AN000;
;;	      S_GRAPH_PARM   = Graphics parameters	   - ASCII-N format				  ;;AN000;
;;													  ;;AN000;
;;	 The information is stored in the structures according to the type				  ;;AN000;
;;	 and port number of this printer.  The first three structures are for				  ;;AN000;
;;	 LPT1 - LPT3, while the next four are for COM1 - COM2.						  ;;AN000;
;;													  ;;AN000;
;;****************************************************************************				  ;;AN000;
SAVE_PRINTER_PARAMS	MACRO	  VAR_PRT								  ;;AN000;
													  ;;AN000;
    MOV  AX, VAR_PRT											  ;;AN000;
    CALL SAVE_PRINTER_PARAMS_ROUTINE									  ;;AN000;
    ENDM												  ;;AN000;
;;****************************************************************************				  ;;AN000;
;;													  ;;AN000;
;;   CHANGE_AUTOEXEC:  Search for the SELECT command in the autoexec.bat and				  ;;AN000;
;;	 change the parameters for that line.								  ;;AN000;
;;													  ;;AN000;
;;   SYNTAX:  CHANGE_AUTOEXEC	FILENAME, APPEND_STRING 						  ;;AN000;
;;													  ;;AN000;
;;   INPUT:												  ;;AN000;
;;	 FILENAME = An ASCII-N string containing the name of the file to change.			  ;;AN000;
;;	      Since the string has to be converted into an ASCII-Z string,				  ;;AN000;
;;	      an extra byte must always be available following the string.				  ;;AN000;
;;	 APPEND_STRING = An ASCII-N string containing the parameters to add to				  ;;AN000;
;;	      the SELECT command.									  ;;AN000;
;;													  ;;AN000;
;;   OUTPUT:												  ;;AN000;
;;	 None.												  ;;AN000;
;;													  ;;AN000;
;;   OPERATION: 											  ;;AN000;
;;													  ;;AN000;
;;****************************************************************************				  ;;AN000;
CHANGE_AUTOEXEC    MACRO     FILENAME, APPEND_STRING							  ;;AN000;
													  ;;AN000;
    MOV  DI, OFFSET FILENAME										  ;;AN000;
    MOV  SI, OFFSET APPEND_STRING									  ;;AN000;
    CALL CHANGE_AUTOEXEC_ROUTINE									  ;;AN000;
    ENDM												  ;;AN000;
													  ;;AN000;
;;****************************************************************************				  ;;AN000;
;;													  ;;AN000;
;;   LOAD_MESSAGES:  Load the messages and initialize the message retriever.				  ;;AN000;
;;													  ;;AN000;
;;   SYNTAX:  LOAD_MESSAGES										  ;;AN000;
;;													  ;;AN000;
;;   INPUT:												  ;;AN000;
;;	 None.												  ;;AN000;
;;													  ;;AN000;
;;   OUTPUT:												  ;;AN000;
;;	 If CY = 1, there was an error loading the messages.						  ;;AN000;
;;	 If CY = 0, there were no errors.								  ;;AN000;
;;													  ;;AN000;
;;   OPERATION: 											  ;;AN000;
;;													  ;;AN000;
;;****************************************************************************				  ;;AN000;
LOAD_MESSAGES MACRO											  ;;AN000;
													  ;;AN000;
    CALL SYSLOADMSG											  ;;AN000;
    ENDM												  ;;AN000;
;;****************************************************************************				  ;;AN000;
;;													  ;;AN000;
;;   DISPLAY_MESSAGE:  Call the message retriever to display a message. 				  ;;AN000;
;;													  ;;AN000;
;;   SYNTAX:  DISPLAY_MESSAGE	 msg_number								  ;;AN000;
;;													  ;;AN000;
;;   INPUT:												  ;;AN000;
;;	 msg_number = The number of the message to be displayed. (16 bit value) 			  ;;AN000;
;;													  ;;AN000;
;;   OUTPUT:												  ;;AN000;
;;	 If CY = 1, there was an error displaying the message.						  ;;AN000;
;;	 If CY = 0, there were no errors.								  ;;AN000;
;;													  ;;AN000;
;;   OPERATION: 											  ;;AN000;
;;													  ;;AN000;
;;****************************************************************************				  ;;AN000;
DISPLAY_MESSAGE    MACRO     MSG_NUMBER 								  ;;AN000;
													  ;;AN000;
    MOV  AX, MSG_NUMBER 										  ;;AN000;
    CALL DISPLAY_MESSAGE_ROUTINE									  ;;AN000;
    ENDM												  ;;AN000;
;;****************************************************************************				  ;;AN000;
;;													  ;;AN000;
;;   CHECK_DOS_PATH:  Check to see if a path for the SET PATH command is valid				  ;;AN000;
;;													  ;;AN000;
;;   SYNTAX:  CHECK_DOS_PATH	path_str								  ;;AN000;
;;													  ;;AN000;
;;   INPUT:												  ;;AN000;
;;	 path_str - An ASCII-N string containing the path to check.					  ;;AN000;
;;													  ;;AN000;
;;   OUTPUT:												  ;;AN000;
;;    If CY = 0, the path is valid.									  ;;AN000;
;;    If CY = 1, The path is NOT valid: 								  ;;AN000;
;;													  ;;AN000;
;;   OPERATION: 											  ;;AN000;
;;													  ;;AN000;
;;****************************************************************************				  ;;AN000;
CHECK_DOS_PATH	   MACRO     PATH_STR									  ;;AN000;
													  ;;AN000;
    LEA  SI, PATH_STR											  ;;AN000;
    CALL CHECK_DOS_PATH_ROUTINE 									  ;;AN000;
    ENDM												  ;;AN000;
;;****************************************************************************				  ;;AN000;
;;													  ;;AN000;
;;   CHECK_PATH:  Check to see if a path is valid.							  ;;AN000;
;;													  ;;AN000;
;;   SYNTAX:  CHECK_PATH    path_str, drive, root							  ;;AN000;
;;													  ;;AN000;
;;   INPUT:												  ;;AN000;
;;	 path_str - An ASCII-N string containing the path to check.					  ;;AN000;
;;													  ;;AN000;
;;	 drive	  = 0: Drive letter cannot be specified.  (8 bit or immediate value)			  ;;AN000;
;;		  = 1: Drive letter is optional and can be specified.					  ;;AN000;
;;		  = 2: Drive letter must be specified.							  ;;AN000;
;;													  ;;AN000;
;;	 root	  = 0: First non-drive character cannot be a backslash ('\') (8 bit or immediate value)   ;;AN000;
;;		  = 1: First non-drive character may be a backslash ('\')                                 ;;AN000;
;;		  = 2: First non-drive character must be a backslash ('\')                                ;;AN000;
;;													  ;;AN000;
;; OUTPUT:												  ;;AN000;
;;    If CY = 0, the path is valid.									  ;;AN000;
;;    If CY = 1, The path is NOT valid: 								  ;;AN000;
;;	   AX = 1, The drive specified is invalid.							  ;;AN000;
;;	      = 2, There was no drive specified.							  ;;AN000;
;;	      = 3, There was a drive specified. 							  ;;AN000;
;;	      = 4, There was a leading backslash							  ;;AN000;
;;	      = 5, The leading backslash was NOT present.						  ;;AN000;
;;	      = 6, There was a trailing backslash.							  ;;AN000;
;;													  ;;AN000;
;;   OPERATION: 											  ;;AN000;
;;													  ;;AN000;
;;****************************************************************************				  ;;AN000;
CHECK_PATH    MACRO	PATH_STR, DRIVE, ROOT								  ;;AN000;
													  ;;AN000;
    LEA  SI, PATH_STR											  ;;AN000;
    MOV  DI, SI 											  ;;AN000;
    CALL POS_ZERO											  ;;AN000;
    MOV  CX, [SI]											  ;;AN000;
    ADD  SI, 2												  ;;AN000;
    MOV  AL, DRIVE											  ;;AN000;
    MOV  AH, ROOT											  ;;AN000;
    CALL CHECK_VALID_PATH										  ;;AN000;
    ENDM												  ;;AN000;
;;****************************************************************************				  ;;AN000;
;;													  ;;AN000;
;;   GET_NUMBER_PORTS: Get the number of parallel and serial ports attached				  ;;AN000;
;;	      to the computer.										  ;;AN000;
;;													  ;;AN000;
;;   SYNTAX:  GET_NUMBER_PORTS	 parallel, serial							  ;;AN000;
;;													  ;;AN000;
;;   INPUT:												  ;;AN000;
;;	 None.												  ;;AN000;
;;													  ;;AN000;
;;   OUTPUT:												  ;;AN000;
;;	 parallel = The number of parallel ports attached. (8 bit value)				  ;;AN000;
;;	 serial   = The number of serial ports attached. (8 bit value)					  ;;AN000;
;;													  ;;AN000;
;;   OPERATION: The macro performs a call to interrupt 11H to determine 				  ;;AN000;
;;	 the number of ports available. 								  ;;AN000;
;;													  ;;AN000;
;;****************************************************************************				  ;;AN000;
GET_NUMBER_PORTS   MACRO     PARALLEL, SERIAL								  ;;AN000;
													  ;;AN000;
    INT  11H					 ;; Determine equipment attached			  ;;AN000;
    SHR  AH, 1					 ;; Put the number of serial ports in L.S. Bits 	  ;;AN000;
    MOV  BH, 0												  ;;AN000;
    MOV  BL, AH 											  ;;AN000;
    MOV  SERIAL, BX											  ;;AN000;
    AND  SERIAL, 0000000000000111B		 ;; Mask off the unwanted information			  ;;AN000;
    MOV  CL, 5					 ;; Number of bits to shift				  ;;AN000;
    SHR  AH, CL 				 ;; Put the number of parallel ports in L.S. Bits	  ;;AN000;
    MOV  BL, AH 											  ;;AN000;
    MOV  PARALLEL, BX				 ;; Store						  ;;AN000;
    AND  PARALLEL, 0000000000000011B		 ;; Mask off the unwanted infromation			  ;;AN000;
    ENDM												  ;;AN000;
;;****************************************************************************				  ;;AN000;
;;													  ;;AN000;
;;   CHANGE_ATTRIBUTE: Change the attributes on a group of file to be hidden				  ;;AN000;
;;	      files.											  ;;AN000;
;;													  ;;AN000;
;;   SYNTAX:  CHANGE_ATTRIBUTE	  list_ptr, num_files							  ;;AN000;
;;													  ;;AN000;
;;   INPUT:												  ;;AN000;
;;	 list_ptr = A pointer to a the list of files to change the attributes				  ;;AN000;
;;		    of.  The list must be of the form:							  ;;AN000;
;;			db   filename,?,?								  ;;AN000;
;;		    Where the filename takes up 12 bytes.						  ;;AN000;
;;	 num_file  = The number of files in the list.							  ;;AN000;
;;													  ;;AN000;
;;   OUTPUT:												  ;;AN000;
;;	 If CY = 1, there was an error encountered.							  ;;AN000;
;;	 If CY = 0, there were no errors.								  ;;AN000;
;;													  ;;AN000;
;;   OPERATION: The macro reads the attribute of the file, stores it in the				  ;;AN000;
;;	 word following the filename in the list, and then assigns the new				  ;;AN000;
;;	 attribute to the file. 									  ;;AN000;
;;													  ;;AN000;
;;****************************************************************************				  ;;AN000;
CHANGE_ATTRIBUTE   MACRO     LIST_PTR, NUM_FILES							  ;;AN000;
													  ;;AN000;
    LEA  SI, LIST_PTR				 ;; Get the address of the file list			  ;;AN000;
    MOV  AX, 0					 ;; Indicate we are to attach a new attribute to the file ;;AN000;
    MOV  BX, NUM_FILES				 ;; Load the number of files in the list		  ;;AN000;
    CALL CHANGE_ATTRIBUTE_ROUTINE		 ;; Change the attributes				  ;;AN000;
    ENDM												  ;;AN000;
;;****************************************************************************				  ;;AN000;
;;													  ;;AN000;
;;   RESTORE_ATTRIBUTE: Restore the original attributes on a group of file.				  ;;AN000;
;;													  ;;AN000;
;;   SYNTAX:  RESTORE_ATTRIBUTE  list_ptr, num_files							  ;;AN000;
;;													  ;;AN000;
;;   INPUT:												  ;;AN000;
;;	 list_ptr = A pointer to a the list of files to change the attributes				  ;;AN000;
;;		    of.  The list must be of the form:							  ;;AN000;
;;			db   filename,?,?								  ;;AN000;
;;		    Where the filename takes up 12 bytes.						  ;;AN000;
;;	 num_files = The number of files in the list.							  ;;AN000;
;;													  ;;AN000;
;;   OUTPUT:												  ;;AN000;
;;	 If CY = 1, there was an error encountered.							  ;;AN000;
;;	 If CY = 0, there were no errors.								  ;;AN000;
;;													  ;;AN000;
;;   OPERATION: This macros restores the attribute previously stored for the				  ;;AN000;
;;	 listed files.											  ;;AN000;
;;													  ;;AN000;
;;****************************************************************************				  ;;AN000;
RESTORE_ATTRIBUTE   MACRO     LIST_PTR, NUM_FILES							  ;;AN000;
													  ;;AN000;
    LEA  SI, LIST_PTR				 ;; Get the address of the file list			  ;;AN000;
    MOV  AX, 1					 ;; Indicate we are to attach a new attribute to the file ;;AN000;
    MOV  BX, NUM_FILES				 ;; Load the number of files in the list		  ;;AN000;
    CALL CHANGE_ATTRIBUTE_ROUTINE		 ;; Change the attributes				  ;;AN000;
    ENDM												  ;;AN000;
;;****************************************************************************				  ;;AN000;
;;													  ;;AN000;
;;   COMPARE_STRINGS:  Compare two strings.								  ;;AN000;
;;													  ;;AN000;
;;   SYNTAX:  COMPARE_STRINGS	string_1, string_2							  ;;AN000;
;;													  ;;AN000;
;;   INPUT:												  ;;AN000;
;;	 string_1 = The address of the first string. (ASCII-N string)					  ;;AN000;
;;	 string_2 = The address of the second string. (ASCII-N string)					  ;;AN000;
;;													  ;;AN000;
;;   OUTPUT:												  ;;AN000;
;;	 If CY = 1, the strings do no compare.								  ;;AN000;
;;	 If CY = 0, the strings are the same.								  ;;AN000;
;;													  ;;AN000;
;;   OPERATION: 											  ;;AN000;
;;													  ;;AN000;
;;****************************************************************************				  ;;AN000;
COMPARE_STRINGS    MACRO     STRING_1, STRING_2 							  ;;AN000;
													  ;;AN000;
    LEA  SI, STRING_1											  ;;AN000;
    LEA  DI, STRING_2											  ;;AN000;
    CALL COMPARE_ROUTINE										  ;;AN000;
    ENDM												  ;;AN000;
;;****************************************************************************				  ;;AN000;
;;													  ;;AN000;
;;   CHECK_WRITE_PROTECT  Determine if the diskette in drive A/B is write				  ;;AC000;JW
;;			protected.									  ;;AN000;
;;													  ;;AN000;
;;   SYNTAX:  CHECK_WRITE_PROTECT RET_CODE								  ;;AN000;
;;													  ;;AN000;
;;   INPUT:												  ;;AN000;
;;	 DRIVE = A_DRIVE (0) Check the diskette in the A drive						  ;;AC000;JW
;;	 DRIVE = B_DRIVE (1) Check the diskette in the B drive						  ;;AC000;JW
;;													  ;;AN000;
;;   OUTPUT:												  ;;AN000;
;;	 If CY = 1, There was an error accessing the drive.						  ;;AN000;
;;	 If CY = 0, There were no errors.								  ;;AN000;
;;	 RET_CODE = 1: The diskette IS write protected. 						  ;;AN000;
;;		  = 0: The diskette is NOT write protected.						  ;;AN000;
;;													  ;;AN000;
;;   OPERATION: 											  ;;AN000;
;;													  ;;AN000;
;;****************************************************************************				  ;;AN000;
CHECK_WRITE_PROTECT	MACRO	  DRIVE, RET_CODE							  ;;AC000;JW
    MOV  CX,DRIVE											  ;;AN000;JW
    CALL CHECK_WRITE_ROUTINE										  ;;AN000;
    MOV  RET_CODE, AX											  ;;AN000;
    ENDM												  ;;AN000;
;;****************************************************************************				  ;;AN000;
;;													  ;;AN000;
;;   GET_FREE_SPACE  Determine the free disk space on a diskette.					  ;;AN000;
;;													  ;;AN000;
;;   SYNTAX:  GET_FREE_SPACE   drive, space								  ;;AN000;
;;													  ;;AN000;
;;   INPUT:												  ;;AN000;
;;	 drive = 1: Examine diskette in drive A 							  ;;AN000;
;;	       = 2: Examine diskette in drive B 							  ;;AN000;
;;													  ;;AN000;
;;   OUTPUT:												  ;;AN000;
;;	 If CY = 1, there was an error accessing the disk						  ;;AN000;
;;	 If CY = 0, there were no errors.								  ;;AN000;
;;	     space = The amount of free space on the disk (32-bit value)				  ;;AN000;
;;													  ;;AN000;
;;   OPERATION: 											  ;;AN000;
;;													  ;;AN000;
;;****************************************************************************				  ;;AN000;
GET_FREE_SPACE	   MACRO     DRIVE, SPACE								  ;;AN000;
													  ;;AN000;
    MOV  DL, DRIVE											  ;;AN000;
    MOV  AH, 36H											  ;;AN000;
    DOSCALL												  ;;AN000;
    .IF < NC >												  ;;AN000;
	 MUL  BX											  ;;AN000;
	 MUL  CX											  ;;AN000;
	 MOV  WORD PTR SPACE[0], AX									  ;;AN000;
	 MOV  WORD PTR SPACE[2], DX									  ;;AN000;
    .ENDIF												  ;;AN000;
    ENDM												  ;;AN000;
;;****************************************************************************				  ;;AN000;
;;													  ;;AN000;
;;   MATCH_DISK_FILES  Determine if a list of file exist on a disk.					  ;;AN000;
;;													  ;;AN000;
;;   SYNTAX:  GET_FREE_SPACE   path, file_list, list_type, num_files, ret_code				  ;;AN000;
;;													  ;;AN000;
;;   INPUT:												  ;;AN000;
;;	 path = ASCII-N string containing the drive, and path of where to				  ;;AN000;
;;		search. 										  ;;AN000;
;;	 file_list = The address of the list of files to use.  If AX=2, then				  ;;AN000;
;;		     the first two bytes are ignored.							  ;;AN000;
;;	 list_type = 1: Use a small list with 12 byte between filenames.				  ;;AN000;
;;		   = 2: Use a list with 14 bytes between filenames.					  ;;AN000;
;;													  ;;AN000;
;;   OUTPUT:												  ;;AN000;
;;	 If CY = 1, There was an error accessing the disk.						  ;;AN000;
;;	 If CY = 0, there were no errors.								  ;;AN000;
;;	     ret_code = 1: All the files are on the disk.						  ;;AN000;
;;	     ret_code = 0: All the file are NOT on the disk.						  ;;AN000;
;;													  ;;AN000;
;;   OPERATION: 											  ;;AN000;
;;													  ;;AN000;
;;****************************************************************************				  ;;AN000;
MATCH_DISK_FILES   MACRO     PATH, FILE_LIST, LIST_TYPE, NUM_FILES, RET_CODE				  ;;AN000;
													  ;;AN000;
    LEA  DI, PATH											  ;;AN000;
    LEA  SI, FILE_LIST											  ;;AN000;
    MOV  AX, LIST_TYPE											  ;;AN000;
    MOV  CX, NUM_FILES											  ;;AN000;
    CALL MATCH_FILES_ROUTINE										  ;;AN000;
    MOV  RET_CODE, AX											  ;;AN000;
    ENDM												  ;;AN000;
													  ;;AN000;
INCLUDE  MACROS7.INC											  ;;AN000;
