;	SCCSID = @(#)abort.asm	1.4 85/10/02
;TITLE   DOS_ABORT - Internal SFT close all files for proc call for MSDOS
;NAME    DOS_ABORT

; Internal Abort call closes all handles and FCBs associated with a process.
;  If process has NET resources a close all is sent out over the net.
;
;   DOS_ABORT
;
;   Modification history:
;
;       Created: ARR 30 March 1983
;

;
; get the appropriate segment definitions
;

%include "dosseg.nas"

section DOSCODECODE

[list -]
;.xcref
%include "dossym.mac"
%include "devsym.mac"
;.cref
[list +]

%iassign Installed TRUE

	I_Need  PROC_ID,WORD            ; current process ID
	I_Need  USER_ID,WORD            ; current user ID
	i_need  CurrentPDB,WORD
	i_need  sft_addr,DWORD
	i_need  THISSFT,DWORD
	i_need  JSHARE,DWORD
	I_need  sftFCB,DWORD            ; pointer to SFTs for FCB cache

Break   <DOS_ABORT -- CLOSE all files for process>

; Inputs:
;       [CurrentPDB] set to PID of process aborting
; Function:
;       Close all files and free all SFTs for this PID
; Returns:
;       None
; All destroyed except stack

	Procedure   DOS_ABORT,NEAR
 assume ds:nothing, es:nothing, ss:DOSGROUP

	MOV     ES,[ss:CurrentPDB]
 assume es:PSP
	MOV     CX,[ES:PDB_JFN_Length]  ; Number of JFNs
reset_free_jfn:
	MOV     BX,CX
	PUSH    CX
	DEC     BX                      ; get jfn (start with last one)

	invoke  D_close
	POP     CX
	LOOP    reset_free_jfn          ; and do 'em all
;
; Note:  We do need to explicitly close FCBs.  Reasons are as follows:  If we
; are running in the no-sharing no-network environment, we are simulating the
; 2.0 world and thus if the user doesn't close the file, that is his problem
; BUT...  the cache remains in a state with garbage that may be reused by the
; next process.  We scan the set and blast the ref counts of the FCBs we own.
;
; If sharing is loaded, then the following call to close process will
; correctly close all FCBs.  We will then need to walk the list AFTER here.
;
; Finally, the following call to NET_Abort will cause an EOP to be sent to all
; known network resources.  These resources are then responsible for cleaning
; up after this process.
;
; Sleazy, eh?
;
	context DS
multNet equ MultNET	; NASM port equate
	CallInstall Net_Abort, multNet, 29
%if installed
JShare equ JSHARE	; NASM port label
	call    far [JShare + 4 * 4]
%else
	call    mftCloseP
%endif
 assume ds:nothing
;
; Scan the FCB cache for guys that belong to this process and zap their ref
; counts.
;
	les     di,[ss:sftFCB]               ; grab the pointer to the table
 assume es:nothing
sfCount equ SFCount	; NASM port equate
	mov     cx,[es:di + sfCount]
	jcxz    FCBScanDone
sfTable equ SFTable	; NASM port equate
	LEA     DI,[DI + sfTable]         ; point at table
proc_id equ PROC_ID	; NASM port label
	mov     ax,[ss:proc_id]
FCBTest:
	cmp     [es:di + sf_PID],ax       ; is this one of ours
	jnz     FCBNext                 ; no, skip it
	mov     word [es:di + sf_ref_count],0  ; yes, blast ref count
FCBNext:
sf_Entry_struc_size equ sf_entry_struc_size	; NASM port equate
	add     di,sf_Entry_struc_size
	loop    FCBTest
FCBScanDone:

;
; Walk the SFT to eliminate all busy SFT's for this process.
;
	XOR     BX,BX
Scan:
	push    bx
	invoke  SFFromSFN
 assume es:nothing
	pop     bx
	retc
		; lDOS note: For MS-DOS v5 the following comparison
		;  only has us operate on entries with a reference
		;  count equal to 0FFFFh, signifying a temporarily
		;  busy SFT entry. This difference had us interfere
		;  with the initial PSP relocation in sysinit1.nas,
		;  but the difference is relevant for others too.
		; Need to study when MS-DOS v5 leaves this special
		;  value in the reference count field.
	cmp     word [es:di + sf_ref_count],0
	jz      next
;
; we have a SFT that is not free.  See if it is for the current process
;
	mov     ax,[ss:proc_id]
sf_pid equ sf_PID	; NASM port equate
	cmp     [es:di + sf_pid],ax
	jnz     next
user_id equ USER_ID	; NASM port label
	mov     ax,[ss:user_id]
sf_uid equ sf_UID	; NASM port equate
	cmp     [es:di + sf_uid],ax
	jnz     next
;
; This SFT is labelled as ours.
;
	mov     word [es:di + sf_ref_count],0
next:
	inc     bx
scan equ Scan	; NASM port label
	jmp     scan

EndProc DOS_Abort

    END
