#! /usr/bin/perl

# Convert makefiles
#  by E. C. Masloch, 2025
#
# Usage of the works is permitted provided that this
# instrument is retained with the works, so that any entity
# that uses the works is notified of this instrument.
#
# DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.

use warnings;
use strict;
use Getopt::Long;
use File::Spec;

our @nextfile = ();
my $nextfileindex = 0;

sub processfilename {
  our @nextfile;
  my $filename = shift;
  my $basename = $filename;
  $basename =~ s/^.*[\\\/:]+//g;
  push(@nextfile, $filename);
}

our $defaultbase;

Getopt::Long::Configure("no_auto_abbrev");

GetOptions(
	'<>' => \&processfilename,
	'base=s' => \$defaultbase,
) or die;

our @arrayoffiles = ();
our $linenumber;
our $target;
our $base;
our $doingsource = 0;
our $wasdoingsource = 0;
our @sources = ();
our @recipe = ();
our $basetarget;
our $skip = 0;

sub afterloop {
  our $target;
  our $base;
  our $doingsource;
  our $wasdoingsource;
  our @sources;
  our @recipe;
  our $basetarget;
  our $skip;
  # print STDERR "$wasdoingsource \"$_\"\n";
  if (($wasdoingsource >= 2 and (not defined $_ or /^\s*$/))
      or $wasdoingsource >= 7) {
    # print STDERR "end $basetarget $wasdoingsource\n";
    if ($wasdoingsource == 5) {
      $skip = 1;
      print STDERR "Skipping $basetarget\n";
    }
    $wasdoingsource = 0;
    if (not $skip) {
      print $basetarget.":";
      my $counter = 0;
      foreach my $line (@sources) {
        if (2 == ($counter % 3)) {
          print " \\\n\t";
        }
        print " ".$line;
        $counter += 1;
      }
      print "\n";
      foreach my $line (@recipe) {
        $line =~ s/[\r\n]*$//;
        print $line."\n";
      }
      print "\n";
    }
    $skip = 0;
  }
}

while ($nextfileindex < scalar @nextfile) {
@ARGV = $nextfile[$nextfileindex];
$nextfileindex += 1;
for my $arg (@ARGV) {
  while (-l $arg) {
    my $path = dirname($arg);
    $arg = File::Spec->abs2rel(readlink($arg), $path);
  }
}
my $inputfile;
my $outputfile;
while ($ARGV = shift @ARGV) {
if (not open($inputfile, "<", $ARGV)) {
  print STDERR "Error: File \"$ARGV\" not found!\n";
  $inputfile = undef;
}
while (defined $inputfile and defined ($_ = readline($inputfile))) {
  # print;
  if ($wasdoingsource == 2) {
    # print STDERR "wds 2 line=$_\n";
    if (not /^\t/) {
      $wasdoingsource = 7;
      afterloop();
    } else {
      push (@recipe, $_);
      if (/^\s+cd\s+/i) {
        $wasdoingsource = 3;
        next;
      }
    }
  }
  my $sourcestext = $_;
  if (/^[\$A-Za-z0-9\\\/\.\)\(]+:/) {
    /^([^:]+):(.*)$/;
    $sourcestext = $2;
    $target = $1;
    if ($target =~ s/^\.\.\\([a-zA-Z0-9]+)\\//) {
      $base = $1;
    } elsif ($target =~ s/\$\(([a-zA-Z0-9]+)\)\\//) {
      $base = $1;
    } else {
      $base = $defaultbase;
    }
    # print STDERR "base=\"$base\" target=\"$target\"\n";
    $basetarget = "\$($base)/$target";
    @sources = ();
    @recipe = ();
    $doingsource = 1;
  }
  if ($doingsource) {
    $wasdoingsource = 1;
    $doingsource = 0;
    while ($sourcestext =~ s/^\s+(\S+)//) {
      my $source = $1;
      if ($source eq '\\' and $sourcestext =~ /^\s*$/) {
        $doingsource = 1;
      } else {
        if ($source eq 'makefile') {
          push (@sources, "makefile");
        } else {
          if ($source =~ s/^\.\.\\([a-zA-Z0-9]+)\\//) {
            $base = $1;
          } elsif ($source =~ s/\$\(([a-zA-Z0-9]+)\)\\//) {
            $base = $1;
          } else {
            $base = $defaultbase;
          }
          # push (@sources, "base=\"$base\" source=\"$source\"\n");
          push (@sources, "\$($base)/$source");
        }
      }
    }
  }
  if ($wasdoingsource == 1 and not $doingsource) {
    # print STDERR "wds 1 line=$_\n";
    $wasdoingsource = 2;
    next;
  }
  if ($wasdoingsource == 3) {
    # print STDERR "wds 3 line=$_\n";
    push (@recipe, $_);
    if (/^\s+\$\(make\)\s*$/i) {
      $wasdoingsource = 4;
      next;
    }
  }
  if ($wasdoingsource == 4) {
    # print STDERR "wds 4 line=$_\n";
    push (@recipe, $_);
    if (/^\s+cd\s+/i) {
      $wasdoingsource = 5;
      next;
    }
  }
  if ($wasdoingsource == 5) {
    # print STDERR "wds 5 line=$_\n";
    push (@recipe, $_);
    if (/\S/i) {
      $wasdoingsource = 6;
      next;
    }
  }
  if ($wasdoingsource == 6) {
    # print STDERR "wds 6 line=$_\n";
    push (@recipe, $_);
  }
  if (not $wasdoingsource) {
    s/[\r\n]*$//g;
    print "$_\n";
  }
} continue {
  afterloop();
}
}
}
afterloop();
