{$A+,B-,D+,F-,I-,O-,R-,S-,V+}
{$IFNDEF FPC}
{$E+,N-,L+}
{$ENDIF}
{$M 4096,0,0}
{ decompress files packed by Microsoft's EXEPACK }
program upackexe;

uses cmdline,FreeWare,dos;

const
	wexeSignature = 0;
	wexeExtraBytes = 1;
	wexePages = 2;
	wexeRelocItems = 3;
	wexeHeaderSize = 4;
	wexeMinAlloc = 5;
	wexeMaxAlloc = 6;
	wexeInitSS = 7;
	wexeInitSP = 8;
	wexeChecksum = 9;
	wexeInitIP = 10;
	wexeInitCS = 11;
	wexeRelocTable = 12;
	wexeOverlayNum = 13;
	WEXESIZE = 14;
	BEXESIZE = WEXESIZE * 2;
	bufsize=8192;
	marqmax=4096;
	idreloc=ord('p')+ord('t')*256;	{ end of "Packed file is corrupt" }
	cr=#13#10;

var
	debugging:word;
	ficin,ficout:file;
	Hexe1,Hexe2:array[0..15] of word;
	headersize,size,posd,posf,posi,posreloc:longint;
	amountpages,extrabytes,imageplusheadersize,imagesize:longint;
	allocsizebytes,allocsizeparas:longint;
	newheadersize,newimageplusheadersize,newimagesize:longint;
	l,k,j,adh,adl,n,nb,i:word;
	by,lb:byte;
	buff:array[1..bufsize] of byte;
	marq:array[1..marqmax] of longint;
	StackAdr:word;
	NomIn,NomOut,NomInOld,NomTmp:String[79];


procedure Fatal(s:string);
begin
	Writeln;
	Writeln;
	Writeln('UPACKEXE: Fatal Error: ');
	Writeln(s);
	Writeln;
	halt(255);
end;

procedure IOtest;
var e:integer;
begin
	e:=ioresult;
	if e<>0 then Fatal(ErrorMsg(e));
end;


procedure help;
begin
	writeln('Syntax: UPACKEXE filename[.EXE]');
	writeln('"filename" is the name of the EXE file to depack.');
	writeln('The EXE extension is appended if it is omitted.');
	writeln('The file is depacked into the current directory.');
	Writeln;
	writeln('For more information refer to the LZEXE documentation.');
	Coordonnees;
	halt(0);
end;




function sread(pos:longint):byte;
var b:byte;
begin
	seek(ficin,pos);
	BlockRead(ficin,b,1);
	IOtest;
	sread:=b;
end;

procedure ReadB0(var lb:byte;var posi:longint);
var n:word;
begin
		lb:=sread(posi);
		case (lb and $FE) of
		$B0: dec(posi,4);
		$B2: begin
			seek(ficin,posi-2);
			BlockRead(ficin,n,2);
			IOtest;
			dec(posi,n+3);
		end;
		else begin
			Fatal('EXE file modified: cannot be unpacked');
		end;
		end;
end;


procedure Decompacter;
var
	nonpack:boolean;
begin
	Writeln('Decompressing ',nomin);
	Writeln;

	assign(ficin,nomin);
	assign(ficout,nomtmp);
	reset(ficin,1);
	rewrite(ficout,1);
	IOtest;



	Writeln('Reading header...');
	BlockRead(ficin,Hexe1,BEXESIZE);
	if (Hexe1[wexeSignature] <> $5A4D) then
		Fatal('File is not an EXE file');
	headersize := Longint(Hexe1[wexeHeaderSize]) shl 4;

{ test whether file can be decompressed by upackexe }
	nonpack:=false;
	if ((Hexe1[wexeRelocItems] <> 0) or (Hexe1[wexeInitSP] <> $80)) then
		nonpack:=true;
if not nonpack then begin
	posd := (longint(Hexe1[wexeInitCS]) shl 4) + headersize;
	seek(ficin,posd+longint(Hexe1[wexeInitIP]));
	BlockRead(ficin,k,2);
	if (k <> $C08C) then	{ 8C C0 = mov ax, es }
		nonpack:=true;
end;
	if nonpack then
		Fatal('The file is not packed by a supported EXEPACK variant');

	seek(ficin,posd);
	BlockRead(ficin,Hexe2[wexeInitIP],2);
	BlockRead(ficin,Hexe2[wexeInitCS],2);
	if Hexe1[wexeInitIP]=$14 then
		StackAdr:=$A
	else
		StackAdr:=$8;
	seek(ficin,posd+StackAdr);
	BlockRead(ficin,Hexe2[wexeInitSP],2);
	BlockRead(ficin,Hexe2[wexeInitSS],2);
	Hexe2[wexeSignature]:=$5A4D;
	Hexe2[wexeRelocTable]:=BEXESIZE;
	Hexe2[wexeOverlayNum]:=0;
	Hexe2[wexeRelocItems]:=0;
	Hexe2[wexeChecksum]:=0;
	BlockWrite(ficout,Hexe2,BEXESIZE);


{ find start of relocation table }

	Writeln('Decompressing relocation table...');
	posreloc:=posd+$10F;
	i:=0;
	repeat
	inc(posreloc);
	seek(ficin,posreloc);
	BlockRead(ficin,l,2);
	inc(i);
	until (i>$40) or (l=idreloc);
	if i>$40 then
		Fatal('Start of relocation table not found');

{ decompress relocation table }

	for i:=0 to 15 do begin
		adh:=i shl 12;
		BlockRead(ficin,n,2);
		for j:=1 to n do begin
			BlockRead(ficin,adl,2);
			if (adl = $FFFF) then begin
				dec(adl, 16);
				BlockWrite(ficout,adl,2);
				inc(adh, 1);
				BlockWrite(ficout,adh,2);
				dec(adh, 1);
			end else begin
				BlockWrite(ficout,adl,2);
				BlockWrite(ficout,adh,2);
			end;
			inc(Hexe2[wexeRelocItems]);
		end;
	end;

	by:=0;
	while (FileSize(ficout) mod 16)<>0 do
		BlockWrite(ficout,by,1);
	Hexe2[wexeHeaderSize] := FileSize(ficout) shr 4;

{ decompress EXE image }

	Writeln('Decompressing EXE code (this may take long!)...');
	posf:=posd-1;
	while sread(posf)=$FF do dec(posf);
	posi:=posf;

{ count size }
	nb:=0;
	lb:=0;
	while (lb and 1)=0 do begin
		inc(nb);
		marq[nb]:=posi;
		ReadB0(lb,posi);
	end;
	if ((debugging and 5) <> 0) then
		Writeln('nb=',nb);

{ sending uncompressed data (?) }
	size:=posi + 1 - headersize;
	if ((debugging and 3) <> 0) then begin
		Writeln('size=',size);
		writeln('in before seek=', filepos(ficin));
	end;
	seek(ficin, headersize);
	if ((debugging and 3) <> 0) then begin
		writeln('in after seek=', filepos(ficin));
		writeln('out=', filepos(ficout));
	end;
	repeat
		if size>bufsize then l:=bufsize else l:=size;
		if ((debugging and 3) <> 0) then
			Writeln('l=',l);
		BlockRead(ficin,buff,l);
		BlockWrite(ficout,buff,l);
		IOtest;
		dec(size,l);
	until size=0;
	if ((debugging and 3) <> 0) then
		writeln('out=', filepos(ficout));

{ decompress }

	for i:=nb downto 1 do begin
		posi:=marq[i];
		lb:=sread(posi);
		seek(ficin,posi-2);
		BlockRead(ficin,n,2);
		if ((debugging and 9) <> 0) then
			Writeln('Marqueur =',lb,'  n=',n,' pos=',posi);
		dec(posi,3);
		case (lb and $FE) of
			$B0: begin
				by:=sread(posi);
				if ((debugging and 3) <> 0) then
					writeln('out=', filepos(ficout));
				for k:=1 to n do BlockWrite(ficout,by,1);
				IOtest;
			end;
			$B2: begin
				seek(ficin,posi-n+1);
				repeat
					if n>bufsize then l:=bufsize else l:=n;
					BlockRead(ficin,buff,l);
					if ((debugging and 3) <> 0) then
						writeln('out=', filepos(ficout));
					BlockWrite(ficout,buff,l);
					IOtest;
					dec(n,l);
				until n=0;
			end;
			else Fatal('File compression incorrect');
		end;
	end;
	if ((debugging and 3) <> 0) then
		writeln('out=', filepos(ficout));

{ update header }

	size:=FileSize(FicOut);
	Hexe2[wexeExtraBytes]:=size mod 512;
	Hexe2[wexePages]:=(size+511) div 512;
	amountpages := Longint(Hexe1[wexePages]);
	extrabytes := Hexe1[wexeExtraBytes];
	if ((extrabytes = 0) or (extrabytes > 512)) then extrabytes := 512;
	imageplusheadersize := (amountpages-1)*512 + extrabytes;
	imagesize := imageplusheadersize - headersize;
	allocsizebytes := Longint(Hexe1[wexeMinAlloc]) * 16 + imagesize;
	allocsizeparas := (allocsizebytes + 15) div 16;
	if ((debugging and 17) <> 0) then
		Writeln('amountpages=',amountpages,
			' extrabytes=',extrabytes,
			' imageplusheadersize=',imageplusheadersize,
			' headersize=',headersize,
			' imagesize=',imagesize,
			' allocsizebytes=',allocsizebytes,
			' allocsizeparas=',allocsizeparas,
			'');
	newheadersize := Longint(Hexe2[wexeHeaderSize]) * 16;
	newimageplusheadersize := size;
	newimagesize := newimageplusheadersize - newheadersize;
	Hexe2[wexeMinAlloc] :=
	  allocsizeparas - ((newimagesize + 15) div 16);
	if ((debugging and 17) <> 0) then
		Writeln('exeminalloc=',Hexe2[wexeMinAlloc],
			' size=',size,
			' (size+15) div 16=',(size+15) div 16,
			' exeheadersize=',Hexe2[wexeHeaderSize],
			'');
	Hexe2[wexeMaxAlloc]:=Hexe1[wexeMaxAlloc];

{ copy any overlays }
	posi:=FileSize(ficin);
	if (imageplusheadersize <> posi) then begin
	  Writeln('*** Warning, internal overlays detected:');
	  Writeln('The EXE file is ',posi,' bytes long when it should be ',imageplusheadersize,' bytes long.');
	  Writeln('This version of UPACKEXE does not allow copying of internal overlays, so');
	  Writeln('your EXE file may not work correctly.');
	end;

{ update header }

	Writeln('Updating file header...');
	seek(ficout,0);
	BlockWrite(ficout,Hexe2,BEXESIZE);

	close(ficout);
	close(ficin);
	Writeln('Decompression done.');
	Writeln;
end;

procedure Renommer;
var
	f:file;
begin
	Writeln('Renaming ',NomIn,' to ',NomInOld);
	assign(f,nominold);
	FileMode := 0;
	Reset(f, 1);
	if (IOResult = 0) then begin
		Close(f);
		Erase(f);
		IOtest;
	end;
	ReName(ficin,NomInOld);
	IOtest;

	Writeln('and ',nomtmp,' to ',nomout);
	ReName(ficout,nomout);
	IOtest;
end;



procedure AnalyserCmd;
var p:byte;
begin
	nomin:=GetUpCase;
	if nomin='' then help;
	if pos('.',nomin)=0 then nomin:=nomin+'.EXE';
	NomInOld:=NomIn;
	while NomInOld[length(NomInOld)]<>'.' do dec(NomInOld[0]);
	NomInOld:=NomInOld+'OLD';

	nomtmp:='UPACKEXE.TMP';

	nomout:='';
	p:=length(nomin);
	while (nomin[p]<>'\') and (nomin[p]<>':') and (p>0) do begin
		nomout:=NomIn[p]+nomout;
		dec(p);
	end;
end;


var
	debugenv:string;
	debugc:word;
begin
{$IFDEF FPC}
	LFNSupport := False;
{$ENDIF}
	Writeln('UPACKEXE.EXE  (C) 1989 Fabrice BELLARD, ecm release 4');
	Writeln('Decompresses EXE files packed by Microsoft EXEPACK.EXE');
	Writeln;

	debugging := 0;
	debugenv := GetEnv('DEBUG');
	if (debugenv <> '') then
		val(debugenv, debugging, debugc);
	AnalyserCmd;
	DeCompacter;
	Renommer;
end.
