#! /bin/bash

# Public Domain

[ -z "$NASM" ] && NASM=nasm

ia16-elf-gcc -Wall -Og unlzexe.c -li86 -o unlzexe.exe
"$NASM" -P nasm.mac lzss.nas -l lzssdat.lst -f obj -DBUILD=DAT -o lzssdat.obj \
	-I ../../lmacros/ -I ../lmacros/ "$@"
"$NASM" -P nasm.mac lzss.nas -l lzsstpc.lst -f obj -DBUILD=TPC -o lzss.obj \
	-I ../../lmacros/ -I ../lmacros/ "$@"
"$NASM" -P nasm.mac lzss.nas -l lzssfpc.lst -f obj -DBUILD=FPC -o lzss.o \
	-I ../../lmacros/ -I ../lmacros/ "$@"
"$NASM" lzexedat.asm -l lzexedat.lst -f obj -I ../../lmacros/ -I ../lmacros/ "$@"
"$NASM" comstub.asm -l comstub.lst -f obj "$@"
"$NASM" exepack.nas -l exepack.lst -f obj "$@"
"$NASM" exepack2.nas -l exepack2.lst -f obj -I ../../lmacros/ -I ../lmacros/ "$@"
"$NASM" exepack3.nas -l exepack3.lst -f obj -I ../../lmacros/ -I ../lmacros/ "$@"
"$NASM" exepack4.nas -l exepack4.lst -f obj -I ../../lmacros/ -I ../lmacros/ "$@"
"$NASM" exepack5.nas -l exepack5.lst -f obj -I ../../lmacros/ -I ../lmacros/ "$@"
"$NASM" exepack6.nas -l exepack6.lst -f obj -I ../../lmacros/ -I ../lmacros/ "$@"
"$NASM" exepack7.nas -l exepack7.lst -f obj -I ../../lmacros/ -I ../lmacros/ "$@"
"$NASM" exepack8.nas -l exepack8.lst -f obj -I ../../lmacros/ -I ../lmacros/ "$@"
"$NASM" exepack9.nas -l exepack9.lst -f obj -I ../../lmacros/ -I ../lmacros/ "$@"
./warplink.sh /mx lzexedat.obj + lzssdat.obj, lzexedat.exe, lzexedat.map;
convlist.pl lzexedat.map lzexedat.lst lzssdat.lst > lzexedat.tls

# fpclarge.sh cmdline
# fpclarge.sh freeware
# fpclarge.sh lzutil
fpclarge.sh lzexe
fpclarge.sh infoexe
fpclarge.sh comtoexe
fpclarge.sh upackexe
