{$B-,D+,F-,I-,R-,S+,V+}
{$IFNDEF FPC}
{$N-,L+}
{$ENDIF}
{$M 8192,8192,655360 }
{ EXE file packer }
program lzexe;

uses LZutil,cmdline,FreeWare;

const
	wexeSignature = 0;
	wexeExtraBytes = 1;
	wexePages = 2;
	wexeRelocItems = 3;
	wexeHeaderSize = 4;
	wexeMinAlloc = 5;
	wexeMaxAlloc = 6;
	wexeInitSS = 7;
	wexeInitSP = 8;
	wexeChecksum = 9;
	wexeInitIP = 10;
	wexeInitCS = 11;
	wexeRelocTable = 12;
	wexeOverlayNum = 13;
	WEXESIZE = 14;
	BEXESIZE = WEXESIZE * 2;

procedure Fatal(s:string);
begin
	Writeln;
	Writeln;
	Writeln('LZEXE: Fatal Error: ');
	Writeln(s);
	Writeln;
	halt(255);
end;

procedure IOtest;
var e:integer;
begin
	e:=ioresult;
	if e<>0 then Fatal(ErrorMsg(e));
end;


procedure help;
begin
	writeln('Syntax: LZEXE [switches] filename[.EXE] [dirname]');
	writeln('"filename" is the name of the EXE file you want to compress.');
	writeln('The EXE extension is added if you omit it.');
	writeln('The compressed file is created in the current directory,');
	writeln('or in the directory specified as "dirname".');
	writeln;
	writeln('Suppported switches:');
	writeln('	/1	Choose old v0.91 stub format');
	writeln('	/2	Choose new stub format (default)');
	writeln('	/I	Inline getbit code alike old stub (faster)');
	writeln('	/J	Do not inline getbit code (slower, default)');
	writeln('	/S	Stop optimisation, always use LZE3 equivalent');
	writeln('	/O	Optimise to drop relocs or segment change (default)');
	writeln('	/L	Allow output file that is not smaller than input');
	writeln('	/-	No more switches, filename follows');
	writeln('	//	Same as /-');
	writeln('	/#XX	Force LZ signature letters to XX (for debugging)');
	writeln;
	writeln('For more information, refer to the LZEXE documentation.');
	Coordonnees;
	halt(0);
end;


{ compression functions }

const
	relocmax=16000;
	IdentLZ=ord('L')+ord('Z')*256;
	Ident90=ord('0')+ord('9')*256;
	Ident91=ord('9')+ord('1')*256;


type
	tab=array[1..65520] of byte;
	tabreloc=array[1..relocmax] of longint;
	tabstub=array[0..511] of byte;
	ptabstub=^tabstub;
var
	Hexe:array[0..15] of word;
	Hout:array[0..15] of word;
	Reloc:^tabreloc;
	bufinptr,bufoutptr:pointer;
	codesize,bufsizel,lzsize,exesize,headersize:longint;
	ficin,ficout:file;
	bufsize:word;
	nomin,dirname,nomout,nomtmp,nominold:string[127];
{$IFDEF FPC}
	depackersize:word;export;
	depackerstartcsip:word;export;
	depackerstartsp:word;export;
	depackerstartss:word;export;
	depackerlenlz:word;export;
	depackerdecalage:word;export;
	depackerlenprog:word;export;
	depackerentry:word;export;
	depackerident:word;export;
	depackeroldident:word;export;
	relocformat:word;export;
	depackerallocdelta:word;export;
{$ELSE}
	depackersize,depackerstartcsip,depackerstartsp,depackerstartss,
	depackerlenlz,depackerdecalage,depackerlenprog,depackerentry,
	depackerident,relocformat,depackerallocdelta:word;
	depackeroldident:word;
{$ENDIF}
	stub:tabstub;
	allowtoolarge,choice,optimise,inlining:byte;
	overrideident:word;

function PREPARE1:ptabstub; external;
function PREPARE2:ptabstub; external;
function PREPARE3:ptabstub; external;
function PREPARE4:ptabstub; external;
function PREPARE5:ptabstub; external;
function PREPARE6:ptabstub; external;
function PREPARE7:ptabstub; external;
function PREPARE8:ptabstub; external;
function PREPARE9:ptabstub; external;
{$L exepack.obj}
{$L exepack2.obj}
{$L exepack3.obj}
{$L exepack4.obj}
{$L exepack5.obj}
{$L exepack6.obj}
{$L exepack7.obj}
{$L exepack8.obj}
{$L exepack9.obj}

{ for lzutil / lzss }
{$F+}
function PutBuf(size:word):word;
begin
	BlockWrite(ficout,bufoutptr^,size);
	IOtest;
	inc(lzsize,size);
	PutBuf:=0;
end;

function GetBuf:word;
var s:word;
begin
	if codesize>bufsize then s:=bufsize else s:=codesize;
	BlockRead(ficin,bufinptr^,s);
	IOtest;
	dec(codesize,s);
	GetBuf:=s;
end;
{$F-}


{ QuickSort }

procedure sort(l,r: word);
var
	i,j: word;
	x,y:longint;
begin
  i:=l; j:=r; x:=reloc^[(l+r) DIV 2];
  repeat
	 while reloc^[i]<x do inc(i);
	 while x<reloc^[j] do dec(j);
    if i<=j then
    begin
		y:=reloc^[i]; reloc^[i]:=reloc^[j]; reloc^[j]:=y;
		inc(i); dec(j);
    end;
  until i>j;
  if l<j then sort(l,j);
  if i<r then sort(i,r);
end;

procedure QuickSortReloc;
begin
  sort(1,Hexe[wexeRelocItems]);
end;


procedure QuestionArreter;
var rep:char;
begin
	repeat
		Write('Do you want to stop ? (Y/N): ');
		readln(rep);
		rep:=upcase(rep);
	until (rep='Y') or (rep='O') or (rep='N');
	if (rep='Y') or (rep='O') then halt(0);
end;



procedure Compacter;

var
	decalage,dcmpsize,i,a,b,n:word;
	tmp,posi:longint;
	lzsizepar,{exesizepar,}dcmpsizepar,lastpagebytes,amountpages:word;
	db:byte;
	p:^tab;
	q:ptabstub;
	version:string[5];
	rc:word;

begin
	Writeln('Compressing ',nomin);
	assign(ficin,nomin);
	assign(ficout,nomtmp);

	reset(ficin,1);
	IOtest;


{ read and check the header }

	Writeln('Reading header...');
	BlockRead(ficin,Hexe,$20);
	IOtest;

	if ((Hexe[wexeSignature] <> $5A4D)
	  and (Hexe[wexeSignature] <> $4D5A)) then begin
		Fatal('The file '+nomin+' is not an .EXE file.'+#13#10+
			'Try making it an EXE with COMTOEXE.EXE.');
	end;
	if (Hexe[wexeRelocTable]=$001C) { exeRelocTable }
	  and (Hexe[wexeRelocItems]=0) { exeRelocItems }
	  and (Hexe[14]=IdentLZ) { past MZ header } then begin
		case Hexe[15] { past MZ header } of
		Ident90: version:='0.90';
		Ident91: version:='0.91';
		else begin
		  version:='LZ' + chr(Hexe[15] and 255) + chr(Hexe[15] shr 8);
		  if ( (Hexe[15] and 255) < 32 ) then version:='??';
		  if ( (Hexe[15] and 255) >= $7F ) then version:='??';
		  if ( (Hexe[15] shr 8) < 32 ) then version:='??';
		  if ( (Hexe[15] shr 8) >= $7F ) then version:='??';
		end;
		end;
		Fatal('The file '+nomin+' has already been compressed with LZEXE version '+version);
	end;


{ test to see if it has already been compressed with EXEPACK }

	if ((Hexe[wexeRelocItems] = 0)
	  and (Hexe[wexeInitSP] = $80)
	  and (Hexe[wexeInitIP] < $20)) then begin
		tmp := (longint(Hexe[wexeInitCS]) shl 4)
			+ (longint(Hexe[wexeHeaderSize]) shl 4)
			+ longint(Hexe[wexeInitIP]);
		seek(ficin,tmp);
		BlockRead(ficin,a,2);
		IOtest;
		if a=$C08C then begin	{ 8C C0 = mov ax, es }
			Writeln('This file appears to have already been compressed with EXEPACK (C) Microsoft');
			Writeln('It is recommended to uncompress it first with LZEXE''s UPACKEXE');
			Writeln('so the savings will be even greater!');
			QuestionArreter;
		end;
	end;


{ check for obvious overlays }

	ExeSize:=FileSize(ficin);
	amountpages:=Hexe[wexePages];
	if (amountpages = 0) then Fatal('Invalid EXE file, zero pages');
	CodeSize:=longint(amountpages-1)*512;
	lastpagebytes:=Hexe[wexeExtraBytes];
	if (lastpagebytes=0) or (lastpagebytes > 512)
	  then inc(codesize,512) else inc(codesize,lastpagebytes);
	if (exesize<>codesize) or (lastpagebytes > 512) then begin
	  if (exesize<>codesize) then begin
		Writeln;
		Writeln('The file appears to contain overlays (refer to the LZEXE documentation)');
		Writeln('Its size is ',exesize,' bytes, whereas it should be ',codesize,' bytes.');
		Writeln('This may cause problems running the compressed program,');
		Writeln('but if the size difference is small, then you can try to compress it.');
	  end;
	  if (lastpagebytes > 512) and ((lastpagebytes and 255) = $EB) then begin
		Writeln;
		Writeln('The file''s last page bytes field is invalid (> 512).');
		Writeln('The file appears to be alike a bootable lDOS iniload executable.');
		Writeln('Compressing the file may irreversibly break the kernel entrypoint.');
	  end
	  else if (lastpagebytes > 512) then begin
		Writeln;
		Writeln('The file''s last page bytes field is invalid (> 512).');
		Writeln('Compressing the file may irreversibly break it.');
	  end;
		QuestionArreter;
	end;



{ read relocation entries }

	Writeln('Reading the relocation table...');
	if (Hexe[wexeRelocItems] > RelocMax) then
		Fatal('Too many relocation entries');
	GetMem(reloc,hexe[wexeRelocItems]*4);
	bufsizel:=MaxAvail;
	if bufsizel<4096 then Fatal('Not enough memory');
	if bufsizel>128000 then bufsizel:=128000;
	bufsize:=bufsizel div 2;
	getmem(bufinptr,bufsize);
	getmem(bufoutptr,bufsize);

	seek(ficin,Hexe[wexeRelocTable]);
	for i:=1 to Hexe[wexeRelocItems] do begin
		BlockRead(ficin,a,2);
		BlockRead(ficin,b,2);
		IOtest;
		reloc^[i]:=longint(a)+longint(b)*16;
	end;


{ compression }

	Writeln('Opening output file for rewrite...');
	rewrite(ficout,1);
	IOtest;
	Writeln('Compressing the EXE code (this can take a long time!)...');
	BlockWrite(ficout,Hout,32);
	IOtest;
	seek(ficin,longint(Hexe[wexeHeaderSize]) shl 4);
	headersize := longint(Hexe[wexeHeaderSize]) shl 4;
	if (CodeSize <= headersize)
	  then Fatal('Invalid EXE file, negative or zero image size');
	dec(CodeSize, headersize);
	Exesize:=codesize;
	lzsize:=0;
	SEGMENTCHANGEDONE := 0;
	rc := LZcompact(bufinptr^,bufsize,@getbuf,bufoutptr^,bufsize,@putbuf);
	if (rc <> 0) then Fatal('Compression error');
	{exesizepar:=(exesize+15) div 16;}
	lzsizepar:=(lzsize+15) div 16;
	decalage:=ecartmax+16;
	db:=0;
	while (filesize(ficout) mod 16)<>0 do begin
		BlockWrite(ficout,db,1);
		IOtest;
	end;
{	writeln(exesizepar-lzsizepar,'   ',decalage);}


{ set up our stub variables according to choice.
  this is now after reading Hexe so we will be able
  to make use of the header later. }

	depackerallocdelta := $FFFF;
	if (choice = 1) then begin
		q := PREPARE1;
	end else
	if (choice = 2) then begin
	  if (inlining<>0) then begin
		if (optimise<>0) then begin
		  if (SEGMENTCHANGEDONE=0) then begin
		    if (Hexe[wexeRelocItems] = 0) then q := PREPARE5 else q := PREPARE4;
		  end else begin
		    if (Hexe[wexeRelocItems] = 0) then q := PREPARE3 else q := PREPARE2;
		  end;
		end else begin
		  q := PREPARE2;
		end;
	  end else begin
		if (optimise<>0) then begin
		  if (SEGMENTCHANGEDONE=0) then begin
		    if (Hexe[wexeRelocItems] = 0) then q := PREPARE9 else q := PREPARE8;
		  end else begin
		    if (Hexe[wexeRelocItems] = 0) then q := PREPARE7 else q := PREPARE6;
		  end;
		end else begin
		  q := PREPARE6;
		end;
	  end;
	end else
		Fatal('Internal error, unknown choice!');
	if (depackersize > sizeof(stub)) then Fatal('Internal error, stub too large!');
	Move(q^, stub, depackersize);


{ depacker }

if ((depackerident = depackeroldident) or (depackeroldident = 0)) then
	if (overrideident<>0) then
		Writeln('Writing format LZ',
			chr(depackerident and 255),
			chr(depackerident shr 8),
			' depacker (overridden to LZ',
			chr(overrideident and 255),
			chr(overrideident shr 8),
			')...')
	else
		Writeln('Writing format LZ',
			chr(depackerident and 255),
			chr(depackerident shr 8),
			' depacker...')
else
	if (overrideident<>0) then
		Writeln('Writing format LZ',
			chr(depackerident and 255),
			chr(depackerident shr 8),
			' (compatible to LZ',
			chr(depackeroldident and 255),
			chr(depackeroldident shr 8),
			') depacker (overridden to LZ',
			chr(overrideident and 255),
			chr(overrideident shr 8),
			')...')
	else
		Writeln('Writing format LZ',
			chr(depackerident and 255),
			chr(depackerident shr 8),
			' (compatible to LZ',
			chr(depackeroldident and 255),
			chr(depackeroldident shr 8),
			') depacker...');
	posi:=filepos(ficout);
	dcmpsize:=depackersize;
	p:=@stub;
	BlockWrite(ficout,p^,dcmpsize);
	IOtest;


{ relocation table }

	Writeln('Writing the compressed relocation table...');
	if hexe[wexeRelocItems]>1 then QuickSortReloc;
	if ((hexe[wexeRelocItems] <> 0)
	  and ((reloc^[hexe[wexeRelocItems]] + 2) > exesize)) then begin
		Fatal('Invalid EXE, relocation points past image');
	end;
	tmp:=0;
if (relocformat = 91) then begin
	for i:=1 to Hexe[wexeRelocItems] do begin
		while (reloc^[i]-tmp)>$FFF0 do begin
			a:=0;
			BlockWrite(ficout,a,1);
			BlockWrite(ficout,a,2);
			inc(dcmpsize,3);
			inc(tmp,$FFF0);
		end;
		if (reloc^[i]-tmp) = 0 then begin
			Fatal('Duplicate relocation not supported by v0.91');
		end
		else if (reloc^[i]-tmp)<=255 then begin
			a:=reloc^[i]-tmp;
			BlockWrite(ficout,a,1);
			inc(dcmpsize);
		end
		else begin
			a:=0;
			BlockWrite(ficout,a,1);
			a:=reloc^[i]-tmp;
			BlockWrite(ficout,a,2);
			inc(dcmpsize,3);
		end;
		tmp:=reloc^[i];
	end;

{ end of the relocation table }
	a:=0;
	BlockWrite(ficout,a,1);
	a:=1;
	BlockWrite(ficout,a,2);
	inc(dcmpsize,3);
end else if (relocformat = $E1) then begin
	for i:=1 to Hexe[wexeRelocItems] do begin
		while (reloc^[i]-tmp)>$FFF0 do begin
			a:=255;
			BlockWrite(ficout,a,1);
			a:=0;
			BlockWrite(ficout,a,2);
			inc(dcmpsize,3);
			inc(tmp,$FFF0);
		end;
		if (reloc^[i]-tmp)<=254 then begin
			a:=reloc^[i]-tmp;
			BlockWrite(ficout,a,1);
			inc(dcmpsize);
		end
		else begin
			a:=255;
			BlockWrite(ficout,a,1);
			a:=reloc^[i]-tmp;
			BlockWrite(ficout,a,2);
			inc(dcmpsize,3);
		end;
		tmp:=reloc^[i];
	end;

{ end of the relocation table }
	a:=255;
	BlockWrite(ficout,a,1);
	a:=1;
	BlockWrite(ficout,a,2);
	inc(dcmpsize,3);
end else if (relocformat = $E4) then begin
	{ nothing written }
	if (hexe[wexeRelocItems] <> 0) then begin
		Fatal('Internal error, relocation format E4h found relocations!');
	end;
end else Fatal('Internal error, unknown relocation format!');
	dcmpsizepar:=(dcmpsize+15) div 16;
	IOtest;


{ update Hexe }

	Writeln('Updating header...');
	seek(ficout,0);
{ EXE signature }
	Hout[wexeSignature]:=$5A4D;
	tmp:=filesize(ficout);
{ size in pages (512 Bytes/page) }
	Hout[wexeExtraBytes]:=tmp mod 512;
	Hout[wexePages]:=(tmp+511) div 512;
	Hout[wexeRelocItems]:=0;
	Hout[wexeHeaderSize]:=2;
{ needed allocation }
	n:=decalage+dcmpsizepar+9;
	if (depackerallocdelta <> $FFFF) then
		Move(n, stub[depackerallocdelta], 2);
	Hout[wexeMinAlloc]:=Hexe[wexeMinAlloc]+n;
	if Hexe[wexeMaxAlloc]>($FFFF-n) then
		Hout[wexeMaxAlloc]:=$FFFF
	else
		Hout[wexeMaxAlloc]:=Hexe[wexeMaxAlloc]+n;

{ SS:SP }
	Hout[wexeInitSS]:=lzsizepar+decalage+dcmpsizepar;
	Hout[wexeInitSP]:=$0080;

{ checksum (unused) }
	Hout[wexeChecksum]:=0;

{ CS:IP }
	Hout[wexeInitIP]:=depackerentry;
	Hout[wexeInitCS]:=lzsizepar;

{ relocation table position (in header) }
	Hout[wexeRelocTable]:=$001C;

{ overlay field (unused) }
	Hout[wexeOverlayNum]:=0;

{ compression signature }
	Hout[14]:=IdentLZ;
	if (overrideident<>0) then
		Hout[15]:= overrideident
	else
		Hout[15]:= depackerident;
	BlockWrite(ficout,Hout,32);
	IOtest;

{ rewrite depacker with updated header/patchsites.
  (this only had to write the header in v0.91
  but is now updated to rewrite the entire depacker,
  excluding the compressed relocation table.)  }
	seek(ficout,posi);

	Move(Hexe[wexeInitIP], stub[depackerstartcsip], 2);
	Move(Hexe[wexeInitCS], stub[depackerstartcsip + 2], 2);
	Move(Hexe[wexeInitSP], stub[depackerstartsp], 2);
	Move(Hexe[wexeInitSS], stub[depackerstartss], 2);
	Move(lzsizepar, stub[depackerlenlz], 2);
	Move(decalage, stub[depackerdecalage], 2);
	Move(dcmpsize, stub[depackerlenprog], 2);

	BlockWrite(ficout,stub,depackersize);
	IOtest;

	exesize:=FileSize(ficin);
	lzsize:=FileSize(ficout);
	close(ficout);
	close(ficin);
	IOtest;
	writeln;
	writeln('Compression finished');
end;

function percentage(part:longint;full:longint;reverse:boolean):string;
var
	tt:longint;
	ss,zz,minus:string;
begin
	tt := part * 10000;
	tt := tt div full;
	if (reverse) then tt := 10000 - tt;
	if (tt < 0) then begin
		minus := '-';
		tt := - tt;
	end else
		minus := '';
	str(tt mod 100, ss);
	if (Length(ss) < 2) then ss := '0' + ss;
	str(tt div 100, zz);
	percentage := minus + zz + '.' + ss;
end;

procedure Renommer;
var f:file;
begin
	writeln;
	Writeln('Changed from ',exesize,' to ',lzsize,' bytes');
	writeln('Left: ',lzsize:6,' bytes  (',percentage(lzsize,exesize,False),'%)');
	writeln('Gain: ',exesize-lzsize:6,' bytes  (',percentage(lzsize,exesize,True),'%)');
	if lzsize>=exesize then begin
		writeln;
		writeln('Sorry, the compression wasn''t efficient enough');
		if (allowtoolarge = 0) then begin
			writeln('Deleting the file ',nomtmp);
			erase(ficout);
			IOtest;
		end;
	end;
	if ((lzsize < exesize) or (allowtoolarge <> 0)) then begin
		writeln;
		writeln('Renaming ',nomin,' to ',nominold);
		assign(f,nominold);
		FileMode := 0;
		Reset(f, 1);
		if (IOResult = 0) then begin
			Close(f);
			Erase(f);
			IOtest;
		end;
		Rename(ficin,nominold);
		IOtest;
		writeln('and ',nomtmp,' to ',nomout);
		Rename(ficout,nomout);
		IOtest;
		Writeln;
	end;
end;


procedure handleswitches(var nomoreswitches:byte);
	var s:string;
	var unknown,letter:byte;
begin
	while ((nomoreswitches = 0) and IsOption) do begin
		s := CmdCh;
		unknown := 0;
		if (IsChar('o')) then optimise:=1
		else if (IsChar('O')) then optimise:=1
		else if (IsChar('s')) then optimise:=0
		else if (IsChar('S')) then optimise:=0
		else if (IsChar('i')) then inlining:=1
		else if (IsChar('I')) then inlining:=1
		else if (IsChar('j')) then inlining:=0
		else if (IsChar('J')) then inlining:=0
		else if (IsChar('L')) then allowtoolarge:=1
		else if (IsChar('l')) then allowtoolarge:=1
		else if (IsChar('2')) then choice:=2
		else if (IsChar('1')) then choice:=1
		else if (IsChar('-')) then nomoreswitches:=1
		else if (IsChar('/')) then nomoreswitches:=1
		else if (IsChar('#')) then begin
			letter := ord(CmdCh);
			overrideident := letter;
			if (CmdCh <> #13) then s := s + CmdCh;
			NextCmdCh;
			if ((letter < 32) or (letter >= $7F)) then
				unknown := 1
			else begin
				letter := ord(CmdCh);
				inc(overrideident, letter * 256);
				if (CmdCh <> #13) then s := s + CmdCh;
				NextCmdCh;
				if ((letter < 32) or (letter >= $7F)) then
					unknown := 1;
			end;
		end else if (IsChar('?')) then begin
			help;
		end else begin
			unknown := 1;
			s := '';
		end;
		if (unknown <> 0)
		  or ((CmdCh<>' ') and (CmdCh<>#9) and (CmdCh<>#13)) then begin
			s := s + GetName;
			Fatal('Unknown switch "' + s + '"');
		end;
	end;
end;

procedure AnalyserCmd;
var p:byte;
var nomoreswitches:byte;
begin
	nomoreswitches := 0;
	choice := 2;
	allowtoolarge := 0;
	optimise := 1;
	inlining := 0;
	overrideident := 0;
	depackeroldident := 0;
	handleswitches(nomoreswitches);
	nomin:=GetUpCase;
	if nomin='' then help;
	handleswitches(nomoreswitches);
	dirname := GetUpCase;
	handleswitches(nomoreswitches);
	SkipSpace;
	if (CmdCh <> #13) then Fatal('Unexpected trailing garbage on command line');
	if pos('.',nomin)=0 then nomin:=nomin+'.EXE';
	NomInOld:=NomIn;
	while NomInOld[length(NomInOld)]<>'.' do dec(NomInOld[0]);
	NomInOld:=NomInOld+'OLD';

	nomtmp:='LZEXE.TMP';

	nomout:='';
	p:=length(nomin);
	while ((p > 0)
	  and (nomin[p] <> '\')
	  and (nomin[p] <> '/')
	  and (nomin[p] <> ':')
	  ) do begin
		nomout:=NomIn[p]+nomout;
		dec(p);
	end;
	if (dirname <> '') then begin
		if ((dirname[length(dirname)] <> '\')
		  and (dirname[length(dirname)] <> '/')
		  and (dirname[length(dirname)] <> ':')) then
			dirname := dirname + '\';
		nomtmp := dirname + nomtmp;
		nomout := dirname + nomout;
	end;
end;

var
	buildname:string;
begin
{$IFDEF FPC}
	LFNSupport := False;
	buildname := ' (FPC build)';
{$ELSE}
	buildname := ' (TPC build)';
{$ENDIF}
	writeln('LZEXE.EXE  v0.91  (C) 1989 Fabrice BELLARD. ecm release 4' + buildname);
	writeln('High-performance EXE file packer');
	writeln;
	AnalyserCmd;
	Compacter;
	Renommer;
end.
