{$R-,S-,I-,D+,F-,V-,B-}
{$IFNDEF FPC}
{$N-,L+}
{$ENDIF}
{$M 4096,0,0 }
{ converts *.com files to *.exe }
program comtoexe;

uses CmdLine,FreeWare;

const
	wexeSignature = 0;
	wexeExtraBytes = 1;
	wexePages = 2;
	wexeRelocItems = 3;
	wexeHeaderSize = 4;
	wexeMinAlloc = 5;
	wexeMaxAlloc = 6;
	wexeInitSS = 7;
	wexeInitSP = 8;
	wexeChecksum = 9;
	wexeInitIP = 10;
	wexeInitCS = 11;
	wexeRelocTable = 12;
	wexeOverlayNum = 13;
	WEXESIZE = 14;
	BEXESIZE = WEXESIZE * 2;
	buffsize=32768;
	stubcode: array[0..7] of byte = ( $31, $F6, $56, $BE, $00, $01, $FF, $E6 );

{ The machine code was assembled this way:

-a
2976:0100 xor si, si
          31F6
2976:0102 push si
          56
2976:0103 mov si,100
          BE0001
2976:0106 jmp si
          FFE6
2976:0108
-d 100 l 8
2976:0100  31 F6 56 BE 00 01 FF E6-                        1.V.....
-

}

type
	Thexw=string[4];

const
	HexStr:array[0..15] of char='0123456789ABCDEF';

function HexW(a:word):Thexw;
var
	s:ThexW;
	i:byte;

begin
	s[0]:=#4;
	for i:=4 downto 1 do begin
		s[i]:=HexStr[byte(a) and $F];
		a:=a shr 4;
	end;
	HexW:=s;
end;


type
	tabstub=array[0..255] of byte;
	ptabstub=^tabstub;

var nomin,nomout:string[80];
	a:byte;
	ficin,ficout:file;
	buff:array[0..buffsize - 1] of byte;
	len:word;
	exesize,comsize:longint;
	Header:array[0..15] of word;
	stub:tabstub;
	choice:byte;
	minimumsp,alloc,processimagesize,processimageplussize:longint;
	comstubsize:word;
{$IFDEF FPC}
	export;
{$ENDIF}

{$F+}
function preparecomstub:ptabstub; external;
{$L comstub.obj}
{$F-}

procedure help;
begin
	Writeln('Syntax: COMTOEXE [switches] comfile[.COM] [exefile[.EXE]]');
	Writeln;
	writeln('Supported switches:');
	writeln('	/0	Choose old-style no stub operation');
	writeln('	/1	Choose new-style stub pushing zero (default)');
	writeln('	/2	Choose stub that expands SP dynamically');
	writeln('	/A=num	For /2 stub: Allocate at least num bytes after image');
	writeln('	/P=num	For /2 stub: Set minimum SP offset before stub runs');
	Coordonnees;
	halt(0);
end;

procedure Fatal(s:string);
begin
	Writeln;
	writeln;
	writeln('COMTOEXE: Fatal Error: '+s);
	Writeln;
	halt(255);
end;

procedure IOtest;
var e:integer;
begin
	e:=IOresult;
	if e<>0 then Fatal(ErrorMsg(e));
end;


function ishex(input:char; var hexit:byte):Boolean;
begin
	if ((input >= '0') and (input <= '9')) then begin
		hexit := ord(input) - ord('0');
		ishex := True;
	end else if ((upcase(input) >= 'A') and (upcase(input) <= 'F')) then begin
		hexit := ord(upcase(input)) - ord('A') + 10;
		ishex := True;
	end else
		ishex := False;
end;

function gethexordecnumber:longint;
var
	ii,start,ende,base,flags:word;
	name:string;
	valid:Boolean;
	hexit:byte;
	product,output:longint;
begin
	flags := 0;
	base := 10;
	name := GetName;
	ende := length(name);
	start := 1;
	while ((name[start] = '=') or (name[start] = ':')) do
		inc(start);
	for ii := start to ende do begin
		if (name[ii] = '_') then begin
		end else if ((name[ii] = '0') and (base = 10)) then begin
			flags := flags or 1;
		end else if ((upcase(name[ii]) = 'X')
				or (upcase(name[ii]) = 'H')) then
		begin
			if ((flags and 2) = 0) then
				start := ii + 1;
			if (base <> 10) then
				Fatal('Bad number');
			base := 16;
		end else begin
			valid := ishex(name[ii], hexit);
			if (not valid) then
				Fatal('Bad number');
			flags := flags or 2;
		end;
	end;
	if (flags = 0) then
		Fatal('Bad number');
{	if (((flags and 2) <> 0) and (start > ende)) then
		Fatal('Bad number'); }
	output := 0;
	valid := True;
	ii := start;
	while ((ii <= ende) and valid) do begin
		if (name[ii] = '_') then
			inc(ii)
		else begin
			valid := ishex(name[ii], hexit);
			if (valid) then begin
				if (hexit >= base) then
					Fatal('Bad number');
				product := output * base;
				if (product div base <> output) then
					Fatal('Number overflow');
				output := product + hexit;
				if (output < product) then
					Fatal('Number overflow');
				inc(ii);
			end;
		end;
	end;
	while (ii <= length(name)) do begin
		if ((upcase(name[ii])<>'X') and (upcase(name[ii])<>'H')) then
			Fatal('Bad number');
		inc(ii);
	end;
	gethexordecnumber := output;
end;

procedure handleswitches(var nomoreswitches:byte);
	var s:string;
	var unknown:byte;
begin
	while ((nomoreswitches = 0) and IsOption) do begin
		s := CmdCh;
		unknown := 0;
		if (IsChar('2')) then choice:=2
		else if (IsChar('1')) then choice:=1
		else if (IsChar('0')) then choice:=0
		else if (IsChar('-')) then nomoreswitches:=1
		else if (IsChar('/')) then nomoreswitches:=1
		else if (IsChar('P') or IsChar('p')) then
			minimumsp := gethexordecnumber
		else if (IsChar('A') or IsChar('a')) then
			alloc := gethexordecnumber
		else if (IsChar('?')) then begin
			help;
		end else begin
			unknown := 1;
			s := '';
		end;
		if (unknown <> 0)
		  or ((CmdCh<>' ') and (CmdCh<>#9) and (CmdCh<>#13)) then begin
			s := s + GetName;
			Fatal('Unknown switch "' + s + '"');
		end;
	end;
end;


var
	nomoreswitches:byte;
	sign:string[2];
	cond:string[2];
	pp:ptabstub;
	ii:word;
	attempts:longint;
	found:Boolean;
	buildname:string;
begin
{$IFDEF FPC}
	LFNSupport := False;
	buildname := ' (FPC build)';
{$ELSE}
	buildname := ' (TPC build)';
{$ENDIF}
	nomoreswitches := 0;
	Writeln('COMTOEXE.EXE  (C) 1989 Fabrice Bellard, ecm release 4' + buildname);
	Writeln('Converts COM files to EXE, for use with LZEXE for instance.');
	writeln;
	choice := 1;
	minimumsp := 0;
	alloc := 0;
	handleswitches(nomoreswitches);
	nomin:=GetUpCase;
	handleswitches(nomoreswitches);
	nomout:=GetUpCase;
	handleswitches(nomoreswitches);
	if nomin='' then help;
	SkipSpace;
	if (CmdCh <> #13) then Fatal('Unexpected trailing garbage on command line');
	a:=pos('.',nomin);
	if nomout='' then begin
		if a=0 then
			nomout:=nomin+'.'+'EXE'
		else begin
			nomout:=copy(nomin,1,a)+'EXE';
		end;
	end
	else begin
		if pos('.',nomout)=0 then nomout:=nomout+'.EXE';
	end;
	if a=0 then nomin:=nomin+'.COM';

	comstubsize := $FFFF;
	if (choice = 0) then begin
		minimumsp := $10000;
		comstubsize := 0;
	end else if (choice = 1) then begin
		minimumsp := $10000;
		pp := @stubcode;
		comstubsize := sizeof(stubcode);
	end else if (choice = 2) then begin
		pp := preparecomstub;	{ also sets comstubsize }
	end else Fatal('Internal error, unknown choice!');
	if (comstubsize > sizeof(stub)) then
		Fatal('Internal error, too large stub!');
	Move(pp^, stub, comstubsize);

	Writeln('Converting ',nomin,' to ',nomout);

	assign(ficin,nomin);
	reset(ficin,1);
	IOtest;
	BlockRead(ficin,buff,buffsize,len);
	IOtest;
	if (len = 0) then
		Fatal('The file '+nomin+' is empty');
	sign := char(buff[0]) + char(buff[1]);
	if ((len >= 2) and ((sign='MZ') or (sign='ZM'))) then
		Fatal('The file '+nomin+' seems to already be an EXE file');
	comsize:=FileSize(ficin);
	if comsize>($FE00-comstubsize) then
		Fatal('The file '+nomin+' is too long');
	exesize:=comsize + 32 + comstubsize;

	if ((minimumsp = 0) and (len >= 6)) then begin
		ii := 0;
		{ jumps assumed to be forward (positive rel16/rel8) }
		if (buff[0] = $E9) then begin
			ii := 3 + word(buff[1]) + 256 * word(buff[2]);
		end;
		if (buff[0] = $EB) then begin
			ii := 2 + word(buff[1]);
		end;
		attempts := len - 6 + 1 - ii;
		if (attempts > 128) then
			attempts := 128;
		found := False;
		while (attempts > 0) do begin
			cond := '';
			if ((buff[ii+4] and $F0) = $70) then
				case (buff[ii+4] and $0F) of
					2: cond := 'B';
					3: cond := 'AE';
					6: cond := 'BE';
					7: cond := 'A';
				end;
			if ((buff[ii] = $81) and (buff[ii+1] = $FC)
				and (cond <> '')) then
			begin
				attempts := 0;
				found := True;
			end else begin
				inc(ii);
				dec(attempts);
			end;
		end;
		if (found) then begin
			minimumsp := word(buff[ii+2]) + 256 * word(buff[ii+3]);
			inc(minimumsp, 2);
			if ((cond = 'A') or (cond = 'BE')) then
				inc(minimumsp);
			writeln('Automatic detection of minimum SP=',
				HexW(minimumsp),'h',
				'=',minimumsp,
				'. Condition is J',
				cond);
		end;
		if (not found) then
			writeln('Automatic detection of minimum SP failed.');
	end;

	assign(ficout,nomout);
	rewrite(ficout,1);
	IOtest;

	Header[wexeSignature]:=byte('M')+byte('Z')*256;
	Header[wexeExtraBytes]:=exesize mod 512;
	Header[wexePages]:=(exesize+511) div 512;
	Header[wexeRelocItems]:=0;
	Header[wexeHeaderSize]:=2;
	if (choice <> 2) then
		alloc := 0;
	if (alloc > $FFFF) then
		Fatal('Too large alloc /A= parameter');
	if (minimumsp > $10000) then
		Fatal('Too large pointer /P= parameter');
	processimagesize := (256 + comsize + comstubsize + 15) and $ffffFFF0;
	if (processimagesize > $10000) then
		Fatal('Internal error, process image size too large');
	inc(alloc, 128);
	if (alloc < 128) then
		Fatal('Invalid alloc /A= parameter');
	processimageplussize := (processimagesize + alloc + 15) and $ffffFFF0;
	if (processimageplussize < processimagesize) then
		Fatal('Invalid alloc /A= parameter');
	if (processimageplussize > $10000) then
		Fatal('Too large alloc /A= parameter');
	if (choice = 2) then
		writeln('Alloc+128=',HexW(alloc),'h=',alloc,
		  ' process+image=',HexW(processimagesize),'h=',processimagesize)
	else
		writeln('Process+image=',HexW(processimagesize),'h=',processimagesize);
	if (minimumsp < processimageplussize) then begin
		writeln('Minimum SP=',
			HexW(minimumsp),
			'h is below process+image+alloc+128 size=',
			HexW(processimageplussize),'h! Enlargening.');
		minimumsp := processimageplussize;
	end;
	header[wexeMinAlloc]:=(minimumsp + 15 - processimagesize) div 16; { minimum alloc }
	Header[wexeMaxAlloc]:=$FFFF; { maximum alloc }
	Header[wexeInitSS]:=$FFF0; { ss = -16 }
	Header[wexeChecksum]:=0;
	if (choice = 2) then begin
		Header[wexeInitSP]:= (minimumsp + 15) and $FFF0; { sp }
		Header[wexeInitIP]:=$100 + comsize; { ip -> behind original image }
	end else if (choice = 1) then begin
		Header[wexeInitSP]:=0; { sp = 0 }
		Header[wexeInitIP]:=$100 + comsize; { ip -> behind original image }
	end else begin
		Header[wexeInitSP]:=$FFFE; { sp }
		Header[wexeInitIP]:=$100; { ip -> behind PSP }
	end;
	Header[wexeInitCS]:=$FFF0; { cs = -16 }
	Header[wexeRelocTable]:=$1C;
	Header[13]:=0;
	Header[14]:=0;
	Header[15]:=0;
	BlockWrite(ficout,Header,32);
	BlockWrite(ficout,buff,len);
	IOtest;
	repeat
		BlockRead(ficin,buff,buffsize,len);
		BlockWrite(ficout,buff,len);
		IOtest;
	until len<>buffsize;
	BlockWrite(ficout,stub,comstubsize);
	IOtest;
	close(ficin);
	close(ficout);
	IOtest;
	Writeln('Conversion done.');
end.
