	PAGE	,132			;
	TITLE	LABELM.SAL - MESSAGE HANDLER FOR LABEL UTILITY
;*****************************************************************************
;*									     *
;*  MODULE NAME:       LABELM.SAL					     *
;*									     *
;*  DESCRIPTIVE NAME:  Include the DOS system MESSAGE HANDLER in the SEGMENT *
;*		       configuration expected by the modules of LABEL.	     *
;*									     *
;*  FUNCTION:	       The common code of the DOS SYSTEM MESSAGE HANDLER is  *
;*		       made a part of the LABEL module by using INCLUDE to   *
;*		       bring in the common portion, in SYSMSG.INC.  This     *
;*		       included code contains the routines to initialize for *
;*		       message services, to find where a particular message  *
;*		       is, and to display a message.			     *
;*									     *
;*  ENTRY POINT:       SYSDISPMSG:near					     *
;*		       SYSLOADMSG:near					     *
;*									     *
;*  INPUT:	       ax = message number				     *
;*		       bx = handle to display to			     *
;*		       cx = number of %parms, 0 if none 		     *
;*		       dx = class in high byte, input function in low	     *
;*		       si = offset in es: of sublist, or 0 if none	     *
;*									     *
;*  EXIT-NORMAL:       CARRY is not set 				     *
;*									     *
;*  EXIT-ERROR:        CARRY is set					     *
;*		       Call SYSDISPMSG					     *
;*									     *
;*  INTERNAL REFERENCES:						     *
;*    Routines:    SYSDISPMSG (generated by MSG_SERVICES macro) 	     *
;*		   SYSLOADMSG	   "      "	  "        "		     *
;*    Data Areas:  INCLUDE SYSMSG.INC (permit Sys Msg handler definition)    *
;*									     *
;*  EXTERNAL REFERENCES:						     *
;*    Routines:    None 						     *
;*    Data Areas:  Control blocks pointed to by input registers 	     *
;*									     *
;*  NOTES:  This module should be processed with the SALUT pre-processor     *
;*	    with the re-alignment not requested, as:			     *
;*									     *
;*		 SALUT LABELM,NUL					     *
;*									     *
;*	    To assemble these modules, the sequential or alphabetical	     *
;*	    ordering of segments may be used.				     *
;*									     *
;*	    Sample LINK command:					     *
;*									     *
;*		 LINK @LABEL.ARF					     *
;*									     *
;*	    Where the LABEL.ARF is defined as:				     *
;*									     *
;*		 LABEL+ 						     *
;*		 LABELM 						     *
;*									     *
;*	    These modules should be linked in this order. The load module is *
;*	    a COM file.  It should be converted via EXE2BIN to a .COM file.  *
;*									     *
;*  REVISION HISTORY:							     *
;*									     *
;*    Prolog edited					  04/88  S. Maes     *
;*									     *
;*****************************************************************************
IF1
	%OUT	COMPONENT=LABEL MODULE=LABELM.SAL
	%OUT	INCLUDING SYSMSG.INC
ENDIF
	INCLUDE sysmsg.inc
	MSG_UTILNAME <LABL>

CSEG	segment public
	assume	cs:CSEG,ds:CSEG
	assume	es:CSEG,ss:CSEG

	PUBLIC	SYSDISPMSG,SYSLOADMSG

	MSG_SERVICES <MSGDATA>
	MSG_SERVICES <LABL.CLA,LABL.CL1,LABL.CL2> ;AN000;M Support Utility msgs
						  ;DEFAULT=CHECK DOS VERSION
						  ;DEFAULT=NEARmsg
						  ;DEFAULT=INPUTmsg
						  ;DEFAULT=NO TIMEmsg
						  ;DEFAULT=NO DATEmsg
						  ;DEFAULT=NO GETmsg

 public amis_sign
	even
amis_sign:
	db "ecm"
	db 5 dup (' ')
	db "lDOS"
	db 4 dup (' ')
amis_id:			; must be directly after amis_sign
	dw 0
	dw 0			; sequential number
	db amis_id_msg_end - amis_id_msg
amis_id_msg:
	db "label"		; our id name
amis_id_msg_end:

AMIS_SIGN_SEGMENT equ CSEG

	MSG_SERVICES <NEARmsg,DISPLAYmsg,CHARmsg,NUMmsg,INPUTmsg,LOADmsg>
CSEG	ENDS					  ;AN000;M Access to svcs macro

	include msgdcl.inc

	END

