
;*****************************************************************************
;*****************************************************************************
;UTILITY NAME: FORMAT.COM
;
;MODULE NAME: DISPLAY.ASM
;
;
; Change List: AN000 - New code DOS 3.3 spec additions
;              AC000 - Changed code DOS 3.3 spec additions
;*****************************************************************************
;*****************************************************************************

%include "lmacros1.mac"

;
;*****************************************************************************
; Define Segment ordering
;*****************************************************************************
;


.SEQ                                            ;

section PSP public align=16 class=DUMMY
; (no prior section) ; PSP     ends

section data public align=16 class=DATA              ;
Public Test_Data_Start
Test_Data_Start label byte
; (no prior section) ; data    ends                                    ;

section stack align=16 stack
        db      62 dup ("-Stack!-")      ; (362-80h) is the additionsal IBM ROM
        assume ss:stack
; (no prior section) ; stack   ends


section code public align=16 class=CODE              ;
        assume  cs:code,ds:data                 ;
; (no prior section) ; code    ends

section End_Of_Memory public align=16 class=BUFFERS  ;
Public  Test_End
Test_End        label   byte
; (no prior section) ; End_Of_Memory    ends                           ;


;
;*****************************************************************************
; INCLUDE FILES
;*****************************************************************************
;

[list -]
%include "forchng.mac"
%include "forequ.mac"
%include "formsg.mac"
%include "sysmsg.mac"
[list +]

;
;*****************************************************************************
; Message Services
;*****************************************************************************
;


MSG_UTILNAME  <FORMAT>


section data
Msg_Services    "MSGDATA"
; (no prior section) ; data    ends

section code

 global amis_sign
	even
amis_sign:
.ven:	fill 8, 32, db "ecm"
.prod:	fill 8, 32, db "lDOS"
amis_id:			; must be directly after amis_sign
	dw 0
.seq:	dw 0			; sequential number
.us:	counted "format"	; our id name

Msg_Services    "NEARmsg"
Msg_Services    "LOADmsg"
Msg_Services    "DISPLAYmsg","CHARmsg","NUMmsg"
Msg_Services    "FORMAT.CLA","FORMAT.CLB","FORMAT.CLC","FORMAT.CL1","FORMAT.CL2","FORMAT.CTL"
; (no prior section) ; code    ends

;
;*****************************************************************************
; Public Declarations
;*****************************************************************************
;

SysDispMsg equ SYSDISPMSG	; NASM port label
        Public  SysDispMsg
SysLoadMsg equ SYSLOADMSG	; NASM port label
        Public  SysLoadMsg


;
;***************************************************************************
; Message Structures
;***************************************************************************
;


Message_Table struc                             ;                               ;AN000;
                                                ;
Entry1  dw      ?                               ;                               ;AN000;
Entry2  dw      ?                               ;                               ;AN000;
Entry3  dw      ?                               ;                               ;AN000;
Entry4  dw      ?                               ;                               ;AN000;
Entry5  db      ?                               ;                               ;AN000;
Entry6  db      ?                               ;                               ;AN000;
Entry7  dw      ?                               ;                               ;AN000;
                                                ;
Message_Table ends                              ;                               ;AN000;



section code
;*****************************************************************************
;Routine name&gml Display_Interface
;*****************************************************************************
;
;DescriptioN&gml Save all registers, set up registers required for SysDispMsg
;             routine. This information is contained in a message description
;             table pointed to by the DX register. Call SysDispMsg, then
;             restore registers. This routine assumes that the only time an
;             error will be returned is if an extended error message was
;             requested, so it will ignore error returns
;
;Called Procedures: Message (macro)
;
;Change History&gml Created        4/22/87         MT
;
;Input&gml ES&gmlDX = pointer to message description
;
;Output&gml None
;
;Psuedocode
;----------
;
;       Save all registers
;       Setup registers for SysDispMsg from Message Description Tables
;       CALL SysDispMsg
;       Restore registers
;       ret
;*****************************************************************************

Public  Display_Interface
Display_Interface   proc                        ;                               ;AN000;

        push    ds                              ;                               ;AN000;
        push    ax                              ;Save registers                 ;AN000;
        push    bx                              ; "  "    "  "                  ;AN000;
        push    cx                              ; "  "    "  "                  ;AN000;
        push    dx                              ; "  "    "  "                  ;AN000;
        push    si                              ; "  "    "  "                  ;AN000;
        push    di                              ; "  "    "  "                  ;AN000;
        mov     di,dx                           ;Change pointer to table        ;AN000;
        mov     dx,data                         ;Point to data segment
        mov     ds,dx                           ;
        mov     ax,[di + Entry1]                  ;Message number                 ;AN000;
        mov     bx,[di + Entry2]                  ;Handle                         ;AN000;
        mov     si,[di + Entry3]                  ;Sublist                        ;AN000;
        mov     cx,[di + Entry4]                  ;Count                          ;AN000;
        mov     dh,[di + Entry5]                  ;Class                          ;AN000;
        mov     dl,[di + Entry6]                  ;Function                       ;AN000;
        mov     di,[di + Entry7]                  ;Input                          ;AN000;
        call    SysDispMsg                      ;Display the message            ;AN000;
        pop     di                              ;Restore registers              ;AN000;
        pop     si                              ; "  "    "  "                  ;AN000;
        pop     dx                              ; "  "    "  "                  ;AN000;
        pop     cx                              ; "  "    "  "                  ;AN000;
        pop     bx                              ; "  "    "  "                  ;AN000;
        pop     ax                              ; "  "    "  "                  ;AN000;
        pop     ds                              ;                               ;AN000;
        ret                                     ;All done                       ;AN000;

Display_Interface      endp                     ;                               ;AN000;
; (no prior section) ; code    ends
        end

