;	PAGE	,132			;
;	TITLE	MSBIO1.asm - BIOS
;==============================================================================
;REVISION HISTORY:
;AN000 - New for DOS Version 4.00 - J.K.
;AC000 - Changed for DOS Version 4.00 - J.K.
;AN00x - PTM number for DOS Version 4.00 - J.K.
;==============================================================================
%if 0 ; COMMENT *
THE LINK STEP IS PERFORMED BY USING THE FOLLOWING "NEW.ARF" FILE:
msbio1+
msSTACK+
MsCON+
msAUX+
msLPT+
msCLOCK+
msdISK+
msBIO2+
C:\BIO2\OLDOBJ\disk+
C:\BIO2\OLDOBJ\msinit+
C:\BIO2\OLDOBJ\sysinit1+
C:\BIO2\OLDOBJ\sysinit2+
C:\BIO2\OLDOBJ\sysimes,msbio,/M;

THE FOLLOWING IS A BATCH FILE THAT CAN BE USED TO CREATE THE IBMBIO.COM
WHERE "LOCSCR" IS A FILE THAT JUST HAS THE NUMBER, 70:

link @NEW.ARF
exe2bin ibmbio ibmbio.com <C:\BIO2\Locscr
del ibmbio.exe
(END OF COMMENT)*
%endif ; COMMENT end

;***For testing purposes, set the TEST flag to 1. Otherwise reset it.

itest equ 0

PATHGEN equ	1

;.SALL
	%warning out: ...MSBIO1.ASM

; THIS IS A DOSMAC MACRO WHICH IS USED IN DEVSYM WHICH IS INCLUDED LATER
%imacro BREAK 0-1+.nolist
	;SUBTTL  subtitle
	;PAGE
%endmacro

%imacro POPFF 0
	jmp %%skip
%%iret:	iret
%%skip:	push cs
	call %%iret
%endmacro

	%include "lmacros3.mac"
	%include "sysinisw.mac"
	%include "entryseg.nas"
	%include "lstruct.mac"

 extern afterdosdatalabel
addsection DOSDATAMCB, PUBLIC class=DOSDATAMCB align=16
istruc MCB
at mcbSignature,db 'M'
at mcbOwner,	dw 8
 %if _RELOCATEDOSCODE
at mcbSize,	dw afterdosdatalabel + DOSCODE_HMA_OFFSET - 16 wrt DOSSTART
 %else
at mcbSize,	dw afterdosdatalabel wrt DOSSTART
 %endif
at mcbName,	db "S"
at smcbType,	db S_DOSDATA
iend

	%include "ddataseg.nas"

addsection AFTERDOSDATA, align=16 class=AFTERDOSDATA

	%include "dcodeseg.nas"
	%include "msgroup.mac"	;DEFINE CODE SEGMENT

addsection DOSCODETABLE		; actually added in dosseg.nas
addsection DOSCODECODE		; actually added in dosseg.nas

%ifn _RELOCATEDOSCODE
 [list -]
%endif
%if _RELOCATEDOSCODE
addsection AFTERDOSCODE, align=16 PUBLIC class=AFTERDOSCODE
%endif
%ifn _RELOCATEDOSCODE
 [list +]
%endif

addsection SYSINITMCB, PUBLIC class=SYSINITMCB align=16
istruc MCB
at mcbSignature,db 'Z'
at mcbOwner,	dw 8
at mcbSize,	dw fromparas(paras(SYSINITSTACK)) + SYSSIZE wrt SYSINITSEG
at mcbName,	db "S"
at smcbType,	db S_INIT
iend

addsection SYSINITSEG, PUBLIC class=INIT
addsection SYSINITTRAIL, PUBLIC class=INIT align=2
addsection SYSINITLAST, PUBLIC class=INIT align=2

group SYSINITGROUP SYSINITSEG SYSINITTRAIL SYSINITLAST

addsection AFTERSYSINIT, PUBLIC class=AFTERSYSINIT align=16
	global SYSSIZE
SYSSIZE LABEL	BYTE

addsection BIOCODE		; actually added before
usesection DOSENTRY

	%include "jumpmac.mac"
%unimacro PATHSTART 2
%unimacro PATHEND 2

%imacro PATHSTART 2
	%IF	PATHGEN							  ;3.30
	    PUBLIC  %2%1S,%2%1E						  ;3.30
	    %2%1S LABEL	 BYTE						  ;3.30
	%ENDIF								  ;3.30
%endmacro								  ;3.30
									  ;3.30
%imacro PATHEND 2
	%IF	PATHGEN							  ;3.30
	    %2%1E LABEL	 BYTE						  ;3.30
	%ENDIF								  ;3.30
%endmacro								  ;3.30

	%include "pushpop.mac"
	%include "devsym.mac"		;MJB001
	%include "msbds.mac"

;   REV 2.1	5/1/83 ARR ADDED TIMER INT HANDLER AND CHANGED ORDER OF AUX
;		    PRN INIT FOR HAL0
;
;   REV 2.15	7/13/83 ARR BECAUSE IBM IS FUNDAMENTALY BRAIN DAMAGED, AND
;		    BASCOM IS RUDE ABOUT THE 1CH TIMER INTERRUPT, THE TIMER
;		    HANDLER HAS TO GO BACK OUT!!!!!  IBM SEEMS UNWILLING TO
;		    BELIEVE THE PROBLEM IS WITH THE BASCOM RUNTIME, NOT THE
;		    DOS.  THEY HAVE EVEN BEEN GIVEN A PATCH FOR BASCOM!!!!!
;		    THE CORRECT CODE IS COMMENTED OUT AND HAS AN ARR 2.15
;		    ANNOTATION.  THIS MEANS THE BIOS WILL GO BACK TO THE
;		    MULTIPLE ROLL OVER BUG.
;   REV 2.20	8/5/83 ARR IBM MAKES HARDWARE CHANGE.  NOW WANTS TO USE HALF
;		    HIGHT DRIVES FOR HAL0, AND BACK FIT FOR PC/PC XT.  PROBLEM
;		    WITH HEAD SETTLE TIME.  PREVIOUS DRIVES GOT BY ON A 0
;		    SETTLE TIME, 1/2 HIGHT DRIVES NEED 15 HEAD SETTLE WHEN
;		    DOING WRITES (0 OK ON READ) IF THE HEAD IS BEING STEPPED.
;		    THIS REQUIRES A LAST TRACK VALUE TO BE KEPT SO THAT BIOS
;		    KNOWS WHEN HEAD IS BEING MOVED.  TO HELP OUT STUPID
;		    PROGRAMS THAT ISSUE INT 13H DIRECTLY, THE HEAD SETTLE WILL
;		    NORMALLY BE SET TO 15.  IT WILL BE CHANGED TO 0 ON READS,
;		    OR ON WRITES WHICH DO NOT REQUIRE HEAD STEP.
;   REV 2.21	8/11/83 MZ IBM WANTS WRITE WITH VERIFY TO USE HEAD SETTLE 0.
;		    USE SAME TRICK AS ABOVE.
;   REV 2.25	6/20/83 MJB001 ADDED SUPPORT FOR 96TPI AND SALMON
;   REV 2.30	6/27/83 MJB002 ADDED REAL-TIME CLOCK
;   REV 2.40	7/8/83 MJB003 ADDED VOLUME-ID CHECKING AND INT 2F MACRO
;		    DEFINITIONS PUSH* AND POP*
;   REV 2.41	7/12/83 ARR MORE 2.X ENHANCEMENTS.  OPEN/CLOSE MEDIA CHANGE
;   REV 2.42	11/3/83 ARR MORE 2.X ENHANCEMENTS.  DISK OPEN/CLOSE, FORMAT
;		    CODE AND OTHER MISC HOOKED OUT TO SHRINK BIOS.  CODE FOR
;		    DISK OPEN/CLOSE, FORMAT INCLUDED ONLY WITH 96TPI DISKS.
;   REV   2.43	12/6/83 MZ EXAMINE BOOT SECTORS ON HARD DISKS FOR 16-BIT FAT
;		    CHECK.  EXAMINE LARGE FAT BIT IN BPB FOR WALK OF MEDIA FOR
;		    DOS
;   REV   2.44	12/9/83 ARR CHANGE TO ERROR REPORTING ON INT 17H
;   REV   2.45	12/22/83 MZ MAKE HEAD SETTLE CHANGE ONLY WHEN DISK PARM IS 0.

;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
;
;	IBM ADDRESSES FOR I/O
;
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

	%include "msdskpr.mac"

LF	equ	10			;LINE FEED
CR	equ	13			;CARRIAGE RETURN
BACKSP	equ	8			;BACKSPACE
BRKADR	equ	1BH * 4 		;006C  1BH BREAK VECTOR ADDRESS
TIMADR	equ	1CH * 4 		;0070  1CH TIMER INTERRUPT
DSKADR	equ	1EH * 4 		;ADDRESS OF PTR TO DISK PARAMETERS
SEC9	equ	522H			;ADDRESS OF DISK PARAMETERS
HEADSETTLE equ	SEC9+9			; ARR 2.20 ADDRESS OF HEAD SETTLE TIME
NORMSETTLE equ	15			; ARR 2.20 NORMAL HEAD SETTLE
SPEEDSETTLE equ	0			; ARR 2.20 SPEED UP SETTLE TIME
INITSPOT equ	534H			; ARR IBM WANTS 4 ZEROS HERE
AKPORT	equ	20H
EOI	equ	20H

 assume ds:nothing, es:nothing, ss:nothing

	EXTRN	MEDIA$CHK:NEAR
	EXTRN	GET$BPB:NEAR
	EXTRN	DSK$INIT:NEAR
	EXTRN	DSK$READ:NEAR
	EXTRN	DSK$WRIT:NEAR
	EXTRN	DSK$WRITV:NEAR
	EXTRN	DSK$OPEN:NEAR
	EXTRN	DSK$CLOSE:NEAR
	EXTRN	DSK$REM:NEAR
	EXTRN	GENERIC$IOCTL:NEAR
	EXTRN	IOCTL$GETOWN:NEAR
	EXTRN	IOCTL$SETOWN:NEAR
	EXTRN	CON$READ:NEAR
	EXTRN	CON$RDND:NEAR
	EXTRN	CON$FLSH:NEAR
	EXTRN	CON$WRIT:NEAR
;	EXTRN	CON$GENIOCTL:NEAR		;J.K. 4/29/86
	EXTRN	AUX$READ:NEAR
	EXTRN	AUX$WRIT:NEAR
	EXTRN	AUX$FLSH:NEAR
	EXTRN	AUX$RDND:NEAR
	EXTRN	AUX$WRST:NEAR
	EXTRN	TIM$READ:NEAR
	EXTRN	TIM$WRIT:NEAR
	EXTRN	PRN$WRIT:NEAR
	EXTRN	PRN$STAT:NEAR
	EXTRN	PRN$TILBUSY:NEAR
	EXTRN	PRN$GENIOCTL:NEAR
	EXTRN	WRMSG:NEAR


;=== Push trace listing source: msbdata.nas
	%include "msbdata.nas" ; NASM included file
;=== Pop trace listing source


usesection BIOCODE

	%IF	itest
	    PUBLIC  MSGNUM
MSGNUM:
	    PUSHF
	    TEST    [cs:FTESTBITS],AX
	    JZ	    MRET
	    PUSH    SI
	    PUSH    BX
	    PUSH    CX
	    PUSH    ES
	    PUSH    DI
	    MOV     DI,OFFSET NUMBUF
	    PUSH    CS
	    POP     ES
	    MOV     CX,4
NUMLOOP:
	    PUSH    CX
	    MOV     CL,4
	    ROL     BX,CL
	    POP     CX
	    PUSH    BX
	    AND     BX,0FH
	    MOV     AL,[cs:DIGITS + BX]
	    STOSB
	    POP     BX
	    LOOP    NUMLOOP
	    POP     DI
	    POP     ES
	    POP     CX
	    POP     BX
	    MOV     SI,OFFSET NUMBUF
	    CALL    MSGOUT
	    POP     SI
	    POPF
	    RET

	    PUBLIC  MSGOUT
MSGOUT:
	    PUSHF
	    TEST    [cs:FTESTBITS],AX
	    JZ	    MRET
	    PUSH    DS
	    PUSH    AX
	    PUSH    BX
	    PUSH    CS
	    POP     DS
	    CALL    WRMSG
	    POP     BX
	    POP     AX
	    POP     DS
MRET:
	    POPF
	    RET

	    PUBLIC DUMPBYTES		;J.K. 4/9/86
;Dumpbytes will dump the bytes in memory in hex.  Space will be put in between
;the bytes and CR, LF will be put at the end. - J.K.
;Input: DS:SI -> buffer to dump in Hex.
;	CX -> # of bytes (Length of the buffer)
;
DUMPBYTES proc near
	pushf
	push	ax
dumploops:
	lodsb
	mov	ah, al
	shr	ah, 1
	shr	ah, 1
	shr	ah, 1
	shr	ah, 1
	call	hex_to_ascii
	push	ax
	mov	al, ah
	call	outchar
	pop	ax
	call	outchar
	mov	al, ' '
	call	outchar
	loop	dumploops

	mov	al, 0dh
	call	outchar
	mov	al, 0ah
	call	outchar

	pop	ax
	popf
	ret
DUMPBYTES	endp

	PUBLIC	Hex_to_ascii
Hex_to_ascii	proc	near		;J.K. - 4/9/86
	and	ax, 0f0fh
	add	ah, 30h
	cmp	ah, 3ah
	jb	hta_$1
	add	ah, 7
hta_$1:
	add	al, 30h
	cmp	al, 3ah
	jb	hta_$2
	add	al, 7
hta_$2:
	ret
Hex_to_ascii	endp

	PUBLIC	outchar
Outchar proc	near
	PUSH	AX
	PUSH	SI
	PUSH	DI
	PUSH	BP
	PUSH	BX
;SB33002*******************************************************
	MOV	AH, 0Eh 		;SET COMMAND TO WRITE A CHAR   ;SB;3.30*
	MOV	BX, 7			;SET FOREGROUND COLOR	       ;SB;3.30*
	INT	10h			;CALL ROM-BIOS		       ;SB;3.30*
;SB33002*******************************************************
	POP	BX
	POP	BP
	POP	DI
	POP	SI
	POP	AX
	RET
Outchar endp

	%ENDIF
	%include "msmacro.mac"

;---------------------------------------------------
;
;	DEVICE ENTRY POINT
;
CMDLEN	equ	0			;LENGTH OF THIS COMMAND
UNIT	equ	1			;SUB UNIT SPECIFIER
CMD	equ	2			;COMMAND CODE
STATUS	equ	3			;STATUS
MEDIA	equ	13			;MEDIA DESCRIPTOR
TRANS	equ	14			;TRANSFER ADDRESS
COUNT	equ	18			;COUNT OF BLOCKS OR CHARACTERS
_START	equ	20			;FIRST BLOCK TO TRANSFER
EXTRA	equ	22			;USUALLY A POINTER TO VOL ID FOR ERROR 15
START_L equ	26			;AN000; Extended start sector (Low)
START_H equ	28			;AN000; Extended start sector (High)


	section BIOCODE
 extern doscode_getdosdata

dosbiocode_get_ds_dosbiodata:
biocode_get_ds_dosbiodata:
 assume ds:nothing, es:nothing, ss:nothing
	push ax
	call doscode_getdosdata
	mov ds, ax
 assume ds:DOSGROUP
	pop ax
	retn

dosbiocode_get_ds_dosentry:
biocode_get_ds_dosentry:
 assume ds:nothing, es:nothing, ss:nothing
	mov ds, word [cs:.segment]
 assume ds:DOSENTRYGROUP
	retn

	align 2, db 0
.segment:	dw DOSENTRY

dosbiocode_get_es_dosbiodata:
biocode_get_es_dosbiodata:
 assume ds:nothing, es:nothing, ss:nothing
	push ax
	call doscode_getdosdata
	mov es, ax
 assume es:DOSGROUP
	pop ax
	retn

dosbiocode_get_es_dosentry:
biocode_get_es_dosentry:
 assume ds:nothing, es:nothing, ss:nothing
	mov es, word [cs:biocode_get_ds_dosentry.segment]
 assume es:DOSENTRYGROUP
	retn

	global biocode_get_es_dosentry, biocode_get_ds_dosentry
	global dosbiocode_get_es_dosentry, dosbiocode_get_ds_dosentry
	global biocode_get_es_dosbiodata, biocode_get_ds_dosbiodata
	global dosbiocode_get_es_dosbiodata, dosbiocode_get_ds_dosbiodata


	section BIOCODE


relocated strategyentry, device
	PUBLIC	STRATEGY
STRATEGY PROC	FAR
 assume ds:nothing, es:nothing, ss:nothing
	push ds
	call biocode_get_ds_dosentry	; PTRSAV in DOSENTRY
 assume ds:DOSENTRYGROUP
	MOV	WORD PTR [PTRSAV],BX
	MOV	WORD PTR [PTRSAV+2],ES
	pop ds
 assume ds:nothing
	RET
STRATEGY ENDP


 global DSK$IN
DSK$IN:					; legacy entry used by disk_i2F
	push si
	push ax
	mov si, DSKTBL

 global common_dev_entrypoint
common_dev_entrypoint:
 assume ds:nothing, es:nothing, ss:nothing
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	BP
	PUSH	DS
	PUSH	ES
	PUSH	BX

	call biocode_get_es_dosentry	; AUXNUM and PTRSAV in DOSENTRY
 assume es:DOSENTRYGROUP
	MOV	[es:AUXNUM],AL		;SAVE CHOICE OF AUX/PRN DEVICE

	lds bx, [es:PTRSAV]		;GET POINTER TO I/O PACKET
	ASSUME	DS:NOTHING

	MOV	AL,BYTE PTR [BX + UNIT] ;AL = UNIT CODE
	MOV	AH,BYTE PTR [BX + MEDIA] ;AH = MEDIA DESCRIP
	MOV	CX,WORD PTR [BX + COUNT] ;CX = COUNT
	MOV	DX,WORD PTR [BX + _START] ;DX = START SECTOR

;SB34MSB100*********************************************************************
;SB
;SB	The disk device driver can now handle 32 bit start sector number.
;SB	So we should check to see if a 32 bit sector number has been specified
;SB	and if so get it. Whether a 32 bit sector has been specified or not
;SB	the disk driver expects a 32 bit sector number with the high word
;SB	in DOSENTRY:Start_Sec_H and the low word in dx.
;SB
;SB	Algorithm:
;SB		1. Check to see if the request is for the disk driver by 
;SB		   checking to see if SI points to DSKTBL.
;SB
;SB		2. If request not for the disk nothing special needs to be done.
;SB	
;SB		3. If request for the disk then check to see if a 32 bit 
;SB		   sector number has been specified by seeing whether the
;SB		   the conventional sector number specified is -1.  If so
;SB		   we need to pick the 32 bit sector number from the new
;SB		   fields in the request packet.  See the request header
;SB		   struc for the fields you need.  If the conventional
;SB		   sector field is not -1 then a 16 bit sector number
;SB		   has been specified and we just need to initalise the
;SB		   high word in DOSENTRY:Start_Sec_H to 0
;SB	
;SB NOTE: START_L and START_H are the offsets withing the IO_REQUEST packet
;SB	  which contain the low and hi words of the 32 bit start sector if
;SB	  it has been used.
;SB	
;SB NOTE:Remember not to destroy the registers which have been set up before

%ifnidni %[DOSBIODATA], %[DOSENTRY]
	call biocode_get_es_dosbiodata
 assume es:DOSGROUP
%endif
	CMP	SI,OFFSET DSKTBL
	JNZ	DSK_REQ_CONT		; Not Disk Req
	and	word [es:START_SEC_H], 0; prepare for zx 16-bit sector number
	CMP	DX,-1
	JNZ	DSK_REQ_16		; is a 16-bit sector number -->
	MOV	DX,[BX + START_H]	; 32 bits DSK REQ
START_SEC_H equ Start_Sec_H	; NASM port label
	MOV	[es:START_SEC_H],DX	; es:Start_sec_H = Packet.Start_H
	MOV	DX,[BX + START_L]	; DX             = Packet.Start_L
DSK_REQ_16:
DSK_REQ_CONT:

;SB34MSB100*********************************************************************

	XCHG	DI,AX
	MOV	AL,BYTE PTR [BX + CMD]
	CMP	AL,[CS:SI]		;ARR 2.41
	JA	CMDERR

	CBW				; NOTE THAT AL <= 15 MEANS OK
	SHL	AX,1

	ADD	SI,AX
	XCHG	AX,DI

	push es
	LES	DI,[BX + TRANS]
 assume es:nothing
	pop ds
 assume ds:DOSGROUP

	CLD
	JMP	WORD PTR [cs:SI+1]	;GO DO COMMAND
DSK$IN	ENDP
;	PAGE
;=====================================================
;=
;=	SUBROUTINES SHARED BY MULTIPLE DEVICES
;=
;=====================================================
;----------------------------------------------------------
;
;	EXIT - ALL ROUTINES RETURN THROUGH THIS PATH
;
	PUBLIC	BUS$EXIT
BUS$EXIT PROC	FAR
 assume ds:nothing, es:nothing, ss:nothing
	MOV	AH,00000011B
	JMP	SHORT ERR1

 global DSK$UNKNOWN
DSK$UNKNOWN:
 assume ds:nothing, es:nothing, ss:nothing
	mov al, 1			; unknown unit error
	db __TEST_IMM16			; skip mov al

	PUBLIC	CMDERR
CMDERR:
 assume ds:nothing, es:nothing, ss:nothing
	MOV	AL,3			;UNKNOWN COMMAND ERROR

	PUBLIC	ERR$CNT
ERR$CNT:
 assume ds:nothing, es:nothing, ss:nothing
	call biocode_get_ds_dosentry	; PTRSAV in DOSENTRY
 assume ds:DOSENTRYGROUP
	lds bx, [PTRSAV]
 ASSUME DS:NOTHING
	SUB	WORD PTR [BX + COUNT],CX	;# OF SUCCESSFUL I/O'S

	PUBLIC	ERR$EXIT
ERR$EXIT:
 assume ds:nothing, es:nothing, ss:nothing
	MOV	AH,10000001B		;MARK ERROR RETURN
	JMP	SHORT ERR1
BUS$EXIT ENDP

EXITP	PROC	FAR
 assume ds:nothing, es:nothing, ss:nothing
EXIT$ZER:
	call biocode_get_ds_dosentry	; PTRSAV in DOSENTRY
 assume ds:DOSENTRYGROUP
	lds bx, [PTRSAV]
 ASSUME DS:NOTHING
	XOR	AX,AX
	MOV	WORD PTR [BX + COUNT],AX	;INDICATE NO CHARS READ

	PUBLIC	EXIT
EXIT:
 assume ds:nothing, es:nothing, ss:nothing
	MOV	AH,00000001B
ERR1:
 assume ds:nothing, es:nothing, ss:nothing
	call biocode_get_ds_dosentry	; PTRSAV in DOSENTRY
 assume ds:DOSENTRYGROUP
	lds bx, [PTRSAV]
 assume ds:nothing
	MOV	WORD PTR [BX + STATUS],AX ;MARK OPERATION COMPLETE

	POP	BX
	POP	ES
 assume es:nothing
	POP	DS
 assume ds:nothing
	POP	BP
	POP	DI
	POP	DX
	POP	CX
	POP	AX
	POP	SI
global biocode_retf
biocode_retf:
	RET				;RESTORE REGS AND RETURN
EXITP	ENDP

;-------------------------------------------------------------
;
;	CHROUT - WRITE OUT CHAR IN AL USING CURRENT ATTRIBUTE
;
;	CALLED VIA INT 29H
;
	PUBLIC	CHROUT
CHROUT	equ	29H

relocated i29
	PUBLIC	OUTCHR
OUTCHR	PROC	FAR
 assume ds:nothing, es:nothing, ss:nothing
	PUSH	AX
	PUSH	SI
	PUSH	DI
	PUSH	BP
;SB33002a*******************************************************
	push	bx			;			      ;SB ;3.30
	mov	AH, 0Eh 		; set command to write a character;SB;3.30
	mov	BX, 7			; set foreground color	      ;SB ;3.30
	int	10h			; call rom-bios 	      ;SB ;3.30
	pop	bx			;			      ;SB ;3.30
;SB33002a*******************************************************
	POP	BP
	POP	DI
	POP	SI
	POP	AX
	IRET
OUTCHR	ENDP
;----------------------------------------------
;
;	SET DX TO AUXNUM
;
	PUBLIC GETDX
GETDX	PROC	NEAR
 assume ds:nothing, es:nothing, ss:nothing
	push ds
	call biocode_get_ds_dosentry
 assume ds:DOSENTRYGROUP
	MOV	DX,WORD PTR [AUXNUM]
	pop ds
 assume ds:nothing
	RET
GETDX	ENDP
;	PAGE
;************************************************** ARR 2.15

;-----------------------------------------------
;
;	TIMER INTERRUPT HANDLER
;
;TIMER_LOW	 DW	 0
;TIMER_HIGH	 DW	 0
;
;TIMER:
;	 STI
;	 PUSH	 AX
;	 PUSH	 CX
;	 PUSH	 DX
;	 PUSH	 DS
;	 PUSH	 CS
;	 POP	 DS
;	 XOR	 AX,AX
;	 INT	 1AH			 ; GET ROM TIME AND ZAP ROLL OVER
;	 MOV	 [TIMER_HIGH],CX
;	 MOV	 [TIMER_LOW],DX
;	 OR	 AL,AL
;	 JZ	 T5
;	 INC	 WORD PTR [DAYCNT]		  ; ONE DAY GONE BY
;T5:
;	 POP	 DS
;	 POP	 DX
;	 POP	 CX
;	 POP	 AX
;	 IRET
;************************************************** ARR 2.15
; (no prior section) ; CODE	ENDS
	END
