



	PAGE	,132
	TITLE	DOS - Keyboard Definition File

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; DOS - - NLS Support - Keyboard Defintion File
;; (c) Copyright 1988 Microsoft
;;
;; This file contains the keyboard tables for Spanish.
;;
;; Linkage Instructions:
;;	Refer to KDF.ASM.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
				       ;;
	INCLUDE KEYBSHAR.INC	       ;;								;AN000;
	INCLUDE POSTEQU.INC	       ;;								;AN000;
	INCLUDE KEYBMAC.INC	       ;;								;AN000;
				       ;;								;AN000;
	PUBLIC IT1_LOGIC		;;								;AN000;
	PUBLIC IT1_437_XLAT		;;								;AN000;
	PUBLIC IT1_850_XLAT		;;								;AN000;
				       ;;								;AN000;
CODE	SEGMENT PUBLIC 'CODE'          ;;                                                               ;AN000;
	ASSUME CS:CODE,DS:CODE	       ;;								;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; Standard translate table options are a liner search table						;AN000;
;; (TYPE_2_TAB) and ASCII entries ONLY (ASCII_ONLY)							;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
STANDARD_TABLE	    EQU   TYPE_2_TAB+ASCII_ONLY 							;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;;***************************************								;AN000;
;; IT State Logic											;AN000;
;;***************************************								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
				       ;;								;AN000;
IT1_LOGIC:												;AN000;
													;AN000;
   DW  LOGIC_END-$		       ;; length							;AN000;
				       ;;								;AN000;
   DW  0			       ;; special features						;AN000;
				       ;;								;AN000;
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; COMMANDS START HERE						;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; OPTIONS:  If we find a scan match in 								;AN000;
;; an XLATT or SET_FLAG operation then									;AN000;
;; exit from INT 9.											;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
   OPTION EXIT_IF_FOUND 	       ;;								;AN000;
				       ;;								;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;;  Dead key definitions must come before								;AN000;
;;  dead key translations to handle									;AN000;
;;  dead key + dead key.										;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
   IFF	EITHER_ALT,NOT		       ;;								;AN000;
   ANDF EITHER_CTL,NOT		       ;;								;AN000;
      IFF EITHER_SHIFT		       ;;								;AN000;
	  SET_FLAG DEAD_UPPER	       ;;								;AN000;
      ELSEF			       ;;								;AN000;
	  SET_FLAG DEAD_LOWER	       ;;								;AN000;
      ENDIFF			       ;;								;AN000;
   ENDIFF			       ;;								;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; ACUTE ACCENT TRANSLATIONS										;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
ACUTE_PROC:			       ;;								;AN000;
				       ;;								;AN000;
   IFF ACUTE,NOT		       ;;								;AN000;
      GOTO DIARESIS_PROC	       ;;								;AN000;
      ENDIFF			       ;;								;AN000;
				       ;;								;AN000;
      RESET_NLS 		       ;;								;AN000;
      IFF R_ALT_SHIFT,NOT	       ;;								;AN000;
	 XLATT ACUTE_SPACE	       ;;								;AN000;
      ENDIFF			       ;;								;AN000;
      IFF EITHER_CTL,NOT	       ;;								;AN000;
      ANDF EITHER_ALT,NOT	       ;;								;AN000;
	 IFF EITHER_SHIFT	       ;;								;AN000;
	    IFF CAPS_STATE	       ;;								;AN000;
	       XLATT ACUTE_LOWER       ;;								;AN000;
	    ELSEF		       ;;								;AN000;
	       XLATT ACUTE_UPPER       ;;								;AN000;
	    ENDIFF		       ;;								;AN000;
	 ELSEF			       ;;								;AN000;
	    IFF CAPS_STATE	       ;;								;AN000;
	       XLATT ACUTE_UPPER       ;;								;AN000;
	    ELSEF		       ;;								;AN000;
	       XLATT ACUTE_LOWER       ;;								;AN000;
	    ENDIFF		       ;;								;AN000;
	 ENDIFF 		       ;;								;AN000;
      ENDIFF			       ;;								;AN000;
				       ;;								;AN000;
INVALID_ACUTE:			       ;;								;AN000;
      PUT_ERROR_CHAR ACUTE_LOWER       ;; If we get here then either the XLATT				;AN000;
      BEEP			       ;; failed or we are ina bad shift state. 			;AN000;
      GOTO NON_DEAD		       ;; Either is invalid so BEEP and fall				;AN000;
				       ;; through to generate the second char.				;AN000;
				       ;; Note that the dead key flag will be				;AN000;
				       ;; reset before we get here.					;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; DIARESIS ACCENT TRANSLATIONS 									;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
DIARESIS_PROC:			       ;;								;AN000;
				       ;;								;AN000;
   IFF DIARESIS,NOT		       ;;								;AN000;
      GOTO GRAVE_PROC		       ;;								;AN000;
      ENDIFF			       ;;								;AN000;
				       ;;								;AN000;
      RESET_NLS 		       ;;								;AN000;
      IFF R_ALT_SHIFT,NOT	       ;;								;AN000;
	 XLATT DIARESIS_SPACE	       ;;  exist for 437 so beep for					;AN000;
      ENDIFF			       ;;								;AN000;
      IFF EITHER_CTL,NOT	       ;;								;AN000;
      ANDF EITHER_ALT,NOT	       ;;								;AN000;
	 IFF EITHER_SHIFT	       ;;								;AN000;
	    IFF CAPS_STATE	       ;;								;AN000;
	       XLATT DIARESIS_LOWER    ;;								;AN000;
	    ELSEF		       ;;								;AN000;
	       XLATT DIARESIS_UPPER    ;;								;AN000;
	    ENDIFF		       ;;								;AN000;
	 ELSEF			       ;;								;AN000;
	    IFF CAPS_STATE	       ;;								;AN000;
	       XLATT DIARESIS_UPPER    ;;								;AN000;
	    ELSEF		       ;;								;AN000;
	       XLATT DIARESIS_LOWER    ;;								;AN000;
	    ENDIFF		       ;;								;AN000;
	 ENDIFF 		       ;;								;AN000;
      ENDIFF			       ;;								;AN000;
				       ;;								;AN000;
INVALID_DIARESIS:		       ;;								;AN000;
      PUT_ERROR_CHAR DIARESIS_SPACE    ;; standalone accent						;AN000;
      BEEP			       ;; Invalid dead key combo.					;AN000;
      GOTO NON_DEAD		       ;;								;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; GRAVE ACCENT TRANSLATIONS										;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
GRAVE_PROC:			       ;;								;AN000;
				       ;;								;AN000;
   IFF GRAVE,NOT		       ;;								;AN000;
      GOTO CIRCUMFLEX_PROC	       ;;								;AN000;
      ENDIFF			       ;;								;AN000;
				       ;;								;AN000;
      RESET_NLS 		       ;;								;AN000;
      IFF R_ALT_SHIFT,NOT	       ;;								;AN000;
	 XLATT GRAVE_SPACE	       ;;								;AN000;
      ENDIFF			       ;;								;AN000;
      IFF EITHER_CTL,NOT	       ;;								;AN000;
      ANDF EITHER_ALT,NOT	       ;;								;AN000;
	IFF EITHER_SHIFT	       ;;								;AN000;
	   IFF CAPS_STATE	       ;;								;AN000;
	      XLATT GRAVE_LOWER        ;;								;AN000;
	   ELSEF		       ;;								;AN000;
	      XLATT GRAVE_UPPER        ;;								;AN000;
	   ENDIFF		       ;;								;AN000;
	ELSEF			       ;;								;AN000;
	   IFF CAPS_STATE,NOT	       ;;								;AN000;
	      XLATT GRAVE_LOWER        ;;								;AN000;
	   ELSEF		       ;;								;AN000;
	      XLATT GRAVE_UPPER        ;;								;AN000;
	   ENDIFF		       ;;								;AN000;
	ENDIFF			       ;;								;AN000;
      ENDIFF			       ;;								;AN000;
				       ;;								;AN000;
INVALID_GRAVE:			       ;;								;AN000;
      PUT_ERROR_CHAR GRAVE_LOWER       ;; standalone accent						;AN000;
      BEEP			       ;; Invalid dead key combo.					;AN000;
      GOTO NON_DEAD		       ;;								;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; CIRCUMFLEX ACCENT TRANSLATIONS									;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
CIRCUMFLEX_PROC:		       ;;								;AN000;
				       ;;								;AN000;
   IFF CIRCUMFLEX,NOT		       ;;								;AN000;
      GOTO NON_DEAD		       ;;								;AN000;
      ENDIFF			       ;;								;AN000;
				       ;;								;AN000;
      RESET_NLS 		       ;;								;AN000;
      IFF R_ALT_SHIFT,NOT	       ;;								;AN000;
	 XLATT CIRCUMFLEX_SPACE        ;;								;AN000;
      ENDIFF			       ;;								;AN000;
      IFF EITHER_CTL,NOT	       ;;								;AN000;
      ANDF EITHER_ALT,NOT	       ;;								;AN000;
	IFF EITHER_SHIFT	       ;;								;AN000;
	   IFF CAPS_STATE	       ;;								;AN000;
	      XLATT CIRCUMFLEX_LOWER   ;;								;AN000;
	   ELSEF		       ;;								;AN000;
	      XLATT CIRCUMFLEX_UPPER   ;;								;AN000;
	   ENDIFF		       ;;								;AN000;
	ELSEF			       ;;								;AN000;
	   IFF CAPS_STATE,NOT	       ;;								;AN000;
	      XLATT CIRCUMFLEX_LOWER   ;;								;AN000;
	   ELSEF		       ;;								;AN000;
	      XLATT CIRCUMFLEX_UPPER   ;;								;AN000;
	   ENDIFF		       ;;								;AN000;
	ENDIFF			       ;;								;AN000;
      ENDIFF			       ;;								;AN000;
				       ;;								;AN000;
INVALID_CIRCUMFLEX:		       ;;								;AN000;
      PUT_ERROR_CHAR CIRCUMFLEX_LOWER  ;; standalone accent						;AN000;
      BEEP			       ;; Invalid dead key combo.					;AN000;
      GOTO NON_DEAD		       ;;								;AN000;
				       ;;								;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; Upper, lower and third shifts									;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
NON_DEAD:			       ;;								;AN000;
				       ;;								;AN000;
   IFKBD G_KB+P12_KB		       ;; Avoid accidentally translating				;AN000;
   ANDF LC_E0			       ;;  the "/" on the numeric pad of the                            ;AN000;
      EXIT_STATE_LOGIC		       ;;   G keyboard							;AN000;
   ENDIFF			       ;;								;AN000;
;;***BD ADDED FOR ALT, CTRL CASES      ;;								;AN000;
      IFF EITHER_CTL,NOT	       ;;								;AN000;
	 IFF  ALT_SHIFT 	       ;; ALT - case							;AN000;
	 ANDF R_ALT_SHIFT,NOT	       ;;								;AN000;
	    XLATT ALT_CASE	       ;;								;AN000;
	 ENDIFF 		       ;;								;AN000;
      ELSEF			       ;;								;AN000;
	 IFF EITHER_ALT,NOT	       ;; CTRL - case							;AN000;
	    XLATT CTRL_CASE	       ;;								;AN000;
	 ENDIFF 		       ;;								;AN000;
      ENDIFF			       ;;								;AN000;
;;***BD END OF ADDITION 										;AN000;
				       ;;								;AN000;
   IFF	EITHER_ALT,NOT		       ;; Lower and upper case.  Alphabetic				;AN000;
   ANDF EITHER_CTL,NOT		       ;; keys are affected by CAPS LOCK.				;AN000;
      IFF EITHER_SHIFT		       ;; Numeric keys are not. 					;AN000;
;;***BD ADDED FOR NUMERIC PAD										;AN000;
	  IFF NUM_STATE,NOT	       ;;								;AN000;
	      XLATT NUMERIC_PAD        ;;								;AN000;
	  ENDIFF		       ;;								;AN000;
;;***BD END OF ADDITION 										;AN000;
	  XLATT NON_ALPHA_UPPER        ;;								;AN000;
	  IFF CAPS_STATE	       ;;								;AN000;
	      XLATT ALPHA_LOWER        ;;								;AN000;
	  ELSEF 		       ;;								;AN000;
	      XLATT ALPHA_UPPER        ;;								;AN000;
	  ENDIFF		       ;;								;AN000;
      ELSEF			       ;;								;AN000;
;;***BD ADDED FOR NUMERIC PAD										;AN000;
	  IFF NUM_STATE 	       ;;								;AN000;
	      XLATT NUMERIC_PAD        ;;								;AN000;
	  ENDIFF		       ;;								;AN000;
;;***BD END OF ADDITION 										;AN000;
	  XLATT NON_ALPHA_LOWER        ;;								;AN000;
	  IFF CAPS_STATE	       ;;								;AN000;
	     XLATT ALPHA_UPPER	       ;;								;AN000;
	  ELSEF 		       ;;								;AN000;
	     XLATT ALPHA_LOWER	       ;;								;AN000;
	  ENDIFF		       ;;								;AN000;
      ENDIFF			       ;;								;AN000;
   ELSEF			       ;;								;AN000;
      IFF EITHER_SHIFT,NOT	       ;;								;AN000;
	  IFKBD XT_KB+AT_KB	 ;;									;AN000;
	      IFF  EITHER_CTL	       ;;								;AN000;
	      ANDF ALT_SHIFT	       ;;								;AN000;
		  XLATT THIRD_SHIFT    ;;								;AN000;
	      ENDIFF		       ;;								;AN000;
	  ELSEF 		       ;;								;AN000;
	      IFF EITHER_CTL,NOT       ;;								;AN000;
	      ANDF R_ALT_SHIFT	       ;;								;AN000;
		  XLATT THIRD_SHIFT    ;;								;AN000;
	      ENDIFF		       ;;								;AN000;
	   ENDIFF		       ;;								;AN000;
      ENDIFF			       ;;								;AN000;
   ENDIFF			       ;;								;AN000;
				       ;;								;AN000;
   EXIT_STATE_LOGIC		       ;;								;AN000;
				       ;;								;AN000;
LOGIC_END:			       ;;								;AN000;
				       ;;								;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;;;***************************************								;AN000;
;; IT Common Translate Section										;AN000;
;; This section contains translations for the lower 128 characters					;AN000;
;; only since these will never change from code page to code page.					;AN000;
;; In addition the dead key "Set Flag" tables are here since the                                        ;AN000;
;; dead keys are on the same keytops for all code pages.						;AN000;
;;***************************************								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
 PUBLIC IT1_COMMON_XLAT 		;;								;AN000;
IT1_COMMON_XLAT:			;;								;AN000;
				       ;;								;AN000;
   DW	 COMMON_XLAT_END-$	       ;; length of section						;AN000;
   DW	 -1			       ;; code page							;AN000;
				       ;;								;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; CODE PAGE: Common											;AN000;
;; STATE: Upper Shift Dead Key										;AN000;
;; KEYBOARD TYPES: G + P12										;AN000;
;; TABLE TYPE: Flag Table										;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;;				       ;;								;AN000;
;; DW	 COM_DK_UP_K1_END-$	       ;; length of state section					;AN000;
;; DB	 DEAD_UPPER		       ;; State ID							;AN000;
;; DW	 G_KB+P12_KB		       ;; Keyboard Type 						;AN000;
;; DB	 -1,-1			       ;; Buffer entry for error character				;AN000;
;;				       ;; Set Flag Table						;AN000;
;; DW	 1			       ;; number of entries						;AN000;
;; DB	 13			       ;; scan code							;AN000;
;; FLAG  CIRCUMFLEX		       ;; flag bit to set						;AN000;
;;				       ;;								;AN000;
;;COM_DK_UP_K1_END:			 ;;								;AN000;
;;					 ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;;***************************************								;AN000;
;;***BD - ADDED FOR ALT CASE										;AN000;
;;******************************									;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; CODE PAGE: Common											;AN000;
;; STATE: Alt Case											;AN000;
;; KEYBOARD TYPES: All											;AN000;
;; TABLE TYPE: Translate										;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
   DW	 COM_ALT_K1_END-$	       ;; length of state section					;AN000;
   DB	 ALT_CASE		       ;; State ID							;AN000;
   DW	 ANY_KB 		       ;; Keyboard Type 						;AN000;
   DB	 -1,-1			       ;; Buffer entry for error character				;AN000;
				       ;;								;AN000;
   DW	 COM_ALT_K1_T1_END-$	       ;; Size of xlat table						;AN000;
   DB	 TYPE_2_TAB		       ;; xlat options: 						;AN000;
   DB	 0			       ;; 3 number of entries						;AN000;
;;***BD THIS ENTRY IS A TEST ENTRY									;AN000;
;; DB	 53,225,0		       ;; TEST ENTRY							;AN000;
;   DB	  53,0,82H			;; valid alt -							;AN000;
;   DB	  12,-1,-1			;; invalid alt -						;AN000;
;   DB	  13,-1,-1			;; invalid alt =						;AN000;
COM_ALT_K1_T1_END:		       ;;								;AN000;
				       ;;								;AN000;
   DW	 0			       ;; Size of xlat table - null table				;AN000;
				       ;;								;AN000;
COM_ALT_K1_END: 		       ;;								;AN000;
				       ;;								;AN000;
;;******************************									;AN000;
;;***BD - ADDED FOR CTRL CASE										;AN000;
;;******************************									;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; CODE PAGE: Common											;AN000;
;; STATE: Ctrl Case											;AN000;
;; KEYBOARD TYPES: G_KB+P12_KB+AT									;AN000;
;; TABLE TYPE: Translate										;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
   DW	 COM_CTRL_K1_END-$	       ;; length of state section					;AN000;
   DB	 CTRL_CASE		       ;; State ID							;AN000;
   DW	 G_KB+P12_KB+AT_KB	       ;; Keyboard Type 						;AN000;
   DB	 -1,-1			       ;; Buffer entry for error character				;AN000;
				       ;;								;AN000;
   DW	 COM_CTRL_K1_T1_END-$	       ;; Size of xlat table						;AN000;
   DB	 TYPE_2_TAB		       ;; xlat options: 						;AN000;
   DB	 2			       ;; number of entries						;AN000;
;;***BD THIS ENTRY IS A TEST ENTRY									;AN000;
;; DB	 53,226,0		       ;; TEST ENTRY							;AN000;
   DB	 43,-1,-1		       ;; invalid slash 						;AN000;
   DB	 41,28,41		       ;; valid slash							;AN000;
COM_CTRL_K1_T1_END:		       ;;								;AN000;
				       ;;								;AN000;
   DW	 0			       ;; Size of xlat table - null table				;AN000;
				       ;;								;AN000;
COM_CTRL_K1_END:		       ;;								;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; CODE PAGE: Common		       ;;change **********CNS **************				;AN000;
;; STATE: Numeric Key Pad										;AN000;
;; KEYBOARD TYPES: All except the p12									;AN000;
;; TABLE TYPE: Translate										;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
   DW	 COM_PAD_K1_END-$	       ;; length of state section					;AN000;
   DB	 NUMERIC_PAD		       ;; State ID							;AN000;
   DW	 G_KB+AT_KB+XT_KB	       ;; Keyboard Type 						;AN000;
   DB	 -1,-1			       ;; Buffer entry for error character				;AN000;
				       ;;								;AN000;
   DW	 COM_PAD_K1_T1_END-$	       ;; Size of xlat table						;AN000;
   DB	 STANDARD_TABLE 	       ;; xlat options: 						;AN000;
   DB	 1			       ;; number of entries						;AN000;
   DB	 83,','                        ;; decimal seperator = ,                                         ;AN000;
COM_PAD_K1_T1_END:		       ;;								;AN000;
				       ;;								;AN000;
   DW	 0			       ;; Size of xlat table - null table				;AN000;
				       ;;								;AN000;
COM_PAD_K1_END: 		       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; CODE PAGE: Common											;AN000;
;; STATE: Non-Alpha Lower Case										;AN000;
;; KEYBOARD TYPES: G_KB+P12_KB										;AN000;
;; TABLE TYPE: Translate										;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
   DW	 COM_NA_LO_K1_END-$		  ;; length of state section					;AN000;
   DB	 NON_ALPHA_LOWER	       ;; State ID							;AN000;
   DW	 G_KB+P12_KB		     ;; Keyboard Type							;AN000;
   DB	 -1,-1			       ;; Buffer entry for error character				;AN000;
				       ;;								;AN000;
   DW	 COM_NA_LO_K1_T1_END-$		  ;; Size of xlat table 					;AN000;
   DB	 STANDARD_TABLE 	       ;; xlat options: 						;AN000;
   DB	 10			       ;; number of entries						;AN000;
   DB	 41,"\"                        ;; \                                                             ;AN000;
   DB	 12,"'"                        ;; '                                                             ;AN000;
   DB	 13,141 		       ;; grave i - ;							;AN000;
   DB	 27,'+'                        ;; +                                                             ;AN000;
   DB	 86,'<'                        ;; <                                                             ;AN000;
   DB	 53,'-'                        ;; -                                                             ;AN000;
   DB	 39,149 		       ;; grave o - 							;AN000;
   DB	 40,133 		       ;; grave a - ;							;AN000;
   DB	 43,151 		       ;; grave u - ;							;AN000;
   DB	 26,138 		       ;; grave e - ;							;AN000;
COM_NA_LO_K1_T1_END:			  ;;								;AN000;
				       ;;								;AN000;
   DW	 0			       ;; Size of xlat table - null table				;AN000;
				       ;;								;AN000;
COM_NA_LO_K1_END:			  ;;								;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; CODE PAGE: Common											;AN000;
;; STATE: Non-Alpha Lower Case										;AN000;
;; KEYBOARD TYPES: AT											;AN000;
;; TABLE TYPE: Translate										;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
   DW	 COM_NA_LO_K2_END-$		  ;; length of state section					;AN000;
   DB	 NON_ALPHA_LOWER	       ;; State ID							;AN000;
   DW	 AT_KB			       ;; Keyboard Type 						;AN000;
   DB	 -1,-1			       ;; Buffer entry for error character				;AN000;
				       ;;								;AN000;
   DW	 COM_NA_LO_K2_T1_END-$		  ;; Size of xlat table 					;AN000;
   DB	 STANDARD_TABLE 	       ;; xlat options: 						;AN000;
   DB	 9			       ;; number of entries						;AN000;
   DB	 41,"<"                        ;; <                                                             ;AN000;
   DB	 12,"'"                        ;; '                                                             ;AN000;
   DB	 13,141 		       ;; grave i - ;							;AN000;
   DB	 27,'+'                        ;; +                                                             ;AN000;
   DB	 53,'-'                        ;; -                                                             ;AN000;
   DB	 39,149 		       ;; grave o - 							;AN000;
   DB	 40,133 		       ;; grave a - ;							;AN000;
   DB	 43,151 		       ;; grave u - ;							;AN000;
   DB	 26,138 		       ;; grave e - ;							;AN000;
COM_NA_LO_K2_T1_END:			  ;;								;AN000;
				       ;;								;AN000;
   DW	 0			       ;; Size of xlat table - null table				;AN000;
				       ;;								;AN000;
COM_NA_LO_K2_END:			  ;;								;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; CODE PAGE: Common											;AN000;
;; STATE: Non-Alpha Lower Case										;AN000;
;; KEYBOARD TYPES:  XT +										;AN000;
;; TABLE TYPE: Translate										;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
   DW	 COM_NA_LO_K3_END-$		  ;; length of state section					;AN000;
   DB	 NON_ALPHA_LOWER	       ;; State ID							;AN000;
   DW	 XT_KB			 ;; Keyboard Type							;AN000;
   DB	 -1,-1			       ;; Buffer entry for error character				;AN000;
				       ;;								;AN000;
   DW	 COM_NA_LO_K3_T1_END-$		  ;; Size of xlat table 					;AN000;
   DB	 STANDARD_TABLE 	       ;; xlat options: 						;AN000;
   DB	 9			       ;; number of entries						;AN000;
   DB	 12,"'"                        ;; '                                                             ;AN000;
   DB	 13,141 		       ;; grave i - ;							;AN000;
   DB	 27,'+'                        ;; +                                                             ;AN000;
   DB	 43,'<'                        ;; <                                                             ;AN000;
   DB	 53,'-'                        ;; -                                                             ;AN000;
   DB	 39,149 		       ;; grave o - 							;AN000;
   DB	 40,133 		       ;; grave a - ;							;AN000;
   DB	 41,151 		       ;; grave u - ;							;AN000;
   DB	 26,138 		       ;; grave e - ;							;AN000;
COM_NA_LO_K3_T1_END:			  ;;								;AN000;
				       ;;								;AN000;
   DW	 0			       ;; Size of xlat table - null table				;AN000;
				       ;;								;AN000;
COM_NA_LO_K3_END:			  ;;								;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; CODE PAGE: Common											;AN000;
;; STATE: Non-Alpha Upper Case										;AN000;
;; KEYBOARD TYPES: G_KB+P12										;AN000;
;; TABLE TYPE: Translate										;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
   DW	 COM_NA_UP_K1_END-$		  ;; length of state section					;AN000;
   DB	 NON_ALPHA_UPPER	       ;; State ID							;AN000;
   DW	 G_KB+P12_KB		     ;; Keyboard Type							;AN000;
   DB	 -1,-1			       ;; Buffer entry for error character				;AN000;
				       ;;								;AN000;
   DW	 COM_NA_UP_K1_T1_END-$		  ;; Size of xlat table 					;AN000;
   DB	 STANDARD_TABLE 	       ;; xlat options: 						;AN000;
   DB	 18			       ;; number of entries						;AN000;
   DB	  41,07CH		       ;; Solid vertical bar - |					;AN000;
   DB	  3,'"'                        ;;                                                               ;AN000;
   DB	  4,''                        ;;                                                               ;AN000;
   DB	  7,'&'                        ;;                                                               ;AN000;
   DB	  8,'/'                        ;;                                                               ;AN000;
   DB	  9,'('                        ;;                                                               ;AN000;
   DB	 10,')'                        ;;                                                               ;AN000;
   DB	 11,'='                        ;;                                                               ;AN000;
   DB	 12,'?'                        ;;                                                               ;AN000;
   DB	 13,'^'                        ;;                                                               ;AN000;
   DB	 26,130 		       ;; acute e - ;							;AN000;
   DB	 39,135 		       ;; c - cedilla - 						;AN000;
   DB	 27,'*'                        ;;                                                               ;AN000;
   DB	 40,0F8H		       ;;  - degree symbol						;AN000;
   DB	 86,'>'                        ;;                                                               ;AN000;
   DB	 51,';'                        ;;                                                               ;AN000;
   DB	 52,':'                        ;;                                                               ;AN000;
   DB	 53,'_'                        ;;                                                               ;AN000;
				       ;;								;AN000;
COM_NA_UP_K1_T1_END:			  ;;								;AN000;
				       ;;								;AN000;
   DW	 0			       ;; Size of xlat table - null table				;AN000;
				       ;;								;AN000;
COM_NA_UP_K1_END:			  ;;								;AN000;
				       ;;								;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; CODE PAGE: Common											;AN000;
;; STATE: Non-Alpha Upper Case										;AN000;
;; KEYBOARD TYPES: AT											;AN000;
;; TABLE TYPE: Translate										;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
   DW	 COM_NA_UP_K2_END-$		  ;; length of state section					;AN000;
   DB	 NON_ALPHA_UPPER	       ;; State ID							;AN000;
   DW	 AT_KB			       ;; Keyboard Type 						;AN000;
   DB	 -1,-1			       ;; Buffer entry for error character				;AN000;
				       ;;								;AN000;
   DW	 COM_NA_UP_K2_T1_END-$		  ;; Size of xlat table 					;AN000;
   DB	 STANDARD_TABLE 	       ;; xlat options: 						;AN000;
   DB	 18			       ;; number of entries						;AN000;
   DB	  41,'>'                       ;; >                                                             ;AN000;
   DB	  3,'"'                        ;;                                                               ;AN000;
   DB	  4,''                        ;;                                                               ;AN000;
   DB	  7,'&'                        ;;                                                               ;AN000;
   DB	  8,'/'                        ;;                                                               ;AN000;
   DB	  9,'('                        ;;                                                               ;AN000;
   DB	 10,')'                        ;;                                                               ;AN000;
   DB	 11,'='                        ;;                                                               ;AN000;
   DB	 12,'?'                        ;;                                                               ;AN000;
   DB	 13,'^'                        ;;                                                               ;AN000;
   DB	 26,130 		       ;; acute e - ;							;AN000;
   DB	 39,'@'                        ;; @ AT sign replaces c - cedilla -                             ;AN000;
   DB	 27,'*'                        ;;                                                               ;AN000;
   DB	 40,'#'                        ;; # sign replaces  - degree symbol                             ;AN000;
   DB	 86,'>'                        ;;                                                               ;AN000;
   DB	 51,';'                        ;;                                                               ;AN000;
   DB	 52,':'                        ;;                                                               ;AN000;
   DB	 53,'_'                        ;;                                                               ;AN000;
				       ;;								;AN000;
COM_NA_UP_K2_T1_END:		       ;;								;AN000;
				       ;;								;AN000;
   DW	 0			       ;; Size of xlat table - null table				;AN000;
				       ;;								;AN000;
COM_NA_UP_K2_END:		       ;;								;AN000;
				       ;;								;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; CODE PAGE: Common											;AN000;
;; STATE: Non-Alpha Upper Case										;AN000;
;; KEYBOARD TYPES: XT + 										;AN000;
;; TABLE TYPE: Translate										;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
   DW	 COM_NA_UP_K3_END-$		  ;; length of state section					;AN000;
   DB	 NON_ALPHA_UPPER	       ;; State ID							;AN000;
   DW	 XT_KB			 ;; Keyboard Type							;AN000;
   DB	 -1,-1			       ;; Buffer entry for error character				;AN000;
				       ;;								;AN000;
   DW	 COM_NA_UP_K3_T1_END-$		  ;; Size of xlat table 					;AN000;
   DB	 STANDARD_TABLE 	       ;; xlat options: 						;AN000;
   DB	 17			       ;; number of entries						;AN000;
   DB	  3,'"'                        ;;                                                               ;AN000;
   DB	  4,''                        ;;                                                               ;AN000;
   DB	  7,'&'                        ;;                                                               ;AN000;
   DB	  8,'/'                        ;;                                                               ;AN000;
   DB	  9,'('                        ;;                                                               ;AN000;
   DB	 10,')'                        ;;                                                               ;AN000;
   DB	 11,'='                        ;;                                                               ;AN000;
   DB	 12,'?'                        ;;                                                               ;AN000;
   DB	 13,'^'                        ;;                                                               ;AN000;
   DB	 26,130 		       ;; acute e - ;							;AN000;
   DB	 39,'@'                        ;; @ AT sign replaces c - cedilla -                             ;AN000;
   DB	 27,'*'                        ;;                                                               ;AN000;
   DB	 40,'#'                        ;; # sign replaces  - degree symbol                             ;AN000;
   DB	 43,'>'                        ;;                                                               ;AN000;
   DB	 51,';'                        ;;                                                               ;AN000;
   DB	 52,':'                        ;;                                                               ;AN000;
   DB	 53,'_'                        ;;                                                               ;AN000;
				       ;;								;AN000;
COM_NA_UP_K3_T1_END:			  ;;								;AN000;
				       ;;								;AN000;
   DW	 0			       ;; Size of xlat table - null table				;AN000;
				       ;;								;AN000;
COM_NA_UP_K3_END:			  ;;								;AN000;
				       ;;								;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; CODE PAGE: Common											;AN000;
;; STATE: Third Shift											;AN000;
;; KEYBOARD TYPES: G_KB 										;AN000;
;; TABLE TYPE: Translate										;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
   DW	 COM_THIRD_K1_END-$	       ;; length of state section					;AN000;
   DB	 THIRD_SHIFT		       ;; State ID							;AN000;
   DW	 G_KB			       ;; Keyboard Type 						;AN000;
   DB	 -1,-1			       ;; Buffer entry for error character				;AN000;
				       ;;								;AN000;
   DW	 COM_THIRD_K1_T1_END-$	       ;; Size of xlat table						;AN000;
   DB	 STANDARD_TABLE 	       ;; xlat options: 						;AN000;
   DB	 8			       ;; number of entries						;AN000;
   DB	 4,'#'                         ;;                                                               ;AN000;
   DB	 8,'{'                         ;;                                                               ;AN000;
   DB	 9,'['                         ;;                                                               ;AN000;
   DB	 10,']'                        ;;                                                               ;AN000;
   DB	 11,'}'                        ;;                                                               ;AN000;
   DB	 16,'@'                        ;;                                                               ;AN000;
   DB	 27,'~'                        ;;                                                               ;AN000;
   DB	 43,"`"                        ;; grave symbol or closing single quote                          ;AN000;
COM_THIRD_K1_T1_END:		       ;; codepoint 60h 						;AN000;
				       ;;								;AN000;
   DW	 0			       ;; Last xlat table						;AN000;
COM_THIRD_K1_END:		       ;;								;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; CODE PAGE: Common											;AN000;
;; STATE: Third Shift											;AN000;
;; KEYBOARD TYPES: P12_KB										;AN000;
;; TABLE TYPE: Translate										;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
   DW	 COM_THIRD_PK1_END-$		   ;; length of state section					;AN000;
   DB	 THIRD_SHIFT		       ;; State ID							;AN000;
   DW	 P12_KB 		       ;; Keyboard Type 						;AN000;
   DB	 -1,-1			       ;; Buffer entry for error character				;AN000;
				       ;;								;AN000;
   DW	 COM_THIRD_PK1_T1_END-$ 	   ;; Size of xlat table					;AN000;
   DB	 STANDARD_TABLE 	       ;; xlat options: 						;AN000;
   DB	 4			       ;; number of entries						;AN000;
   DB	 26,'['                        ;;                                                               ;AN000;
   DB	 27,']'                        ;;                                                               ;AN000;
   DB	 39,'@'                        ;;                                                               ;AN000;
   DB	 40,'#'                        ;;                                                               ;AN000;
COM_THIRD_PK1_T1_END:			   ;;								;AN000;
				       ;;								;AN000;
   DW	 0			       ;; Last xlat table						;AN000;
COM_THIRD_PK1_END:			   ;;								;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; CODE PAGE: Common											;AN000;
;; STATE: Third Shift											;AN000;
;; KEYBOARD TYPES: AT											;AN000;
;; TABLE TYPE: Translate										;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
   DW	 COM_THIRD_K2_END-$		  ;; length of state section					;AN000;
   DB	 THIRD_SHIFT		       ;; State ID							;AN000;
   DW	 AT_KB			       ;; Keyboard Type 						;AN000;
   DB	 -1,-1			       ;; Buffer entry for error character				;AN000;
				       ;;								;AN000;
   DW	 COM_THIRD_K2_T1_END-$		  ;; Size of xlat table 					;AN000;
   DB	 STANDARD_TABLE 	       ;; xlat options: 						;AN000;
   DB	 3			       ;; number of entries						;AN000;
   DB	 41,'\'                        ;;                                                               ;AN000;
   DB	 26,'['                        ;;                                                               ;AN000;
   DB	 27,']'                        ;;                                                               ;AN000;
COM_THIRD_K2_T1_END:			  ;;								;AN000;
				       ;;								;AN000;
   DW	 0			       ;; Last xlat table						;AN000;
COM_THIRD_K2_END:			  ;;								;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; CODE PAGE: Common											;AN000;
;; STATE: Third Shift											;AN000;
;; KEYBOARD TYPES:  XT +										;AN000;
;; TABLE TYPE: Translate										;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
   DW	 COM_THIRD_K3_END-$		  ;; length of state section					;AN000;
   DB	 THIRD_SHIFT		       ;; State ID							;AN000;
   DW	 XT_KB			 ;; Keyboard Type							;AN000;
   DB	 -1,-1			       ;; Buffer entry for error character				;AN000;
				       ;;								;AN000;
   DW	 COM_THIRD_K3_T1_END-$		  ;; Size of xlat table 					;AN000;
   DB	 STANDARD_TABLE 	       ;; xlat options: 						;AN000;
   DB	 3			       ;; number of entries						;AN000;
   DB	 43,'\'                        ;;                                                               ;AN000;
   DB	 26,'['                        ;;                                                               ;AN000;
   DB	 27,']'                        ;;                                                               ;AN000;
COM_THIRD_K3_T1_END:			  ;;								;AN000;
				       ;;								;AN000;
   DW	 0			       ;; Last xlat table						;AN000;
COM_THIRD_K3_END:			  ;;								;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
   DW	 0			       ;; Last State							;AN000;
COMMON_XLAT_END:		       ;;								;AN000;
				       ;;								;AN000;
				       ;;								;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;;***************************************								;AN000;
;; IT Specific Translate Section for 437								;AN000;
;; 437 IS COMPLETELY COVERED BY THE COMMON TABLE.							;AN000;
;;***************************************								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
 PUBLIC IT1_437_XLAT			;;								;AN000;
IT1_437_XLAT:				;;								;AN000;
				       ;;								;AN000;
   DW	  CP437_XLAT_END-$	       ;; length of section						;AN000;
   DW	  437			       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; CODE PAGE: 437											;AN000;
;; STATE: Non-Alpha Upper case										;AN000;
;; KEYBOARD TYPES: G_KB+P12+AT										;AN000;
;; TABLE TYPE: Translate										;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
					 ;;								;AN000;
     DW    CP437_NA_UP_K1_END-$ 	 ;; length of state section					;AN000;
     DB    NON_ALPHA_UPPER		 ;; State ID							;AN000;
     DW    G_KB+P12_KB+AT_KB		 ;; Keyboard Type						;AN000;
     DB    -1,-1			 ;; error character = standalone accent 			;AN000;
					 ;;								;AN000;
     DW    CP437_NA_UP_T1_K1_END-$	 ;; Size of xlat table						;AN000;
     DB    STANDARD_TABLE+ZERO_SCAN	 ;; xlat options:						;AN000;
     DB    1				 ;; number of scans						;AN000;
     DB    43,015H			 ;; Section symbol - 						;AN000;
  CP437_NA_UP_T1_K1_END:		 ;;								;AN000;
					 ;;								;AN000;
     DW    0				 ;; Size of xlat table - null table				;AN000;
					 ;;								;AN000;
  CP437_NA_UP_K1_END:			 ;;								;AN000;
					 ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; CODE PAGE: 437											;AN000;
;; STATE: Non-Alpha Upper case										;AN000;
;; KEYBOARD TYPES: XT + 										;AN000;
;; TABLE TYPE: Translate										;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
					 ;;								;AN000;
     DW    CP437_NA_UP_K2_END-$ 	 ;; length of state section					;AN000;
     DB    NON_ALPHA_UPPER		 ;; State ID							;AN000;
     DW    XT_KB			 ;; Keyboard Type						;AN000;
     DB    -1,-1			 ;; error character = standalone accent 			;AN000;
					 ;;								;AN000;
     DW    CP437_NA_UP_T1_K2_END-$	 ;; Size of xlat table						;AN000;
     DB    STANDARD_TABLE+ZERO_SCAN	 ;; xlat options:						;AN000;
     DB    1				 ;; number of scans						;AN000;
     DB    41,015H			 ;; Section symbol - 						;AN000;
  CP437_NA_UP_T1_K2_END:		 ;;								;AN000;
					 ;;								;AN000;
     DW    0				 ;; Size of xlat table - null table				;AN000;
					 ;;								;AN000;
  CP437_NA_UP_K2_END:			 ;;								;AN000;
					 ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
   DW	  0			       ;; LAST STATE							;AN000;
				       ;;								;AN000;
CP437_XLAT_END: 		       ;;								;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;;***************************************								;AN000;
;; IT Specific Translate Section for 850								;AN000;
;;***************************************								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
 PUBLIC IT1_850_XLAT			;;								;AN000;
IT1_850_XLAT:				;;								;AN000;
				       ;;								;AN000;
   DW	  CP850_XLAT_END-$	       ;; length of section						;AN000;
   DW	  850			       ;;								;AN000;
				       ;;								;AN000;
				       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; CODE PAGE: 850											;AN000;
;; STATE: Non-Alpha Upper case										;AN000;
;; KEYBOARD TYPES: G_KB+P12+AT										;AN000;
;; TABLE TYPE: Translate										;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
					 ;;								;AN000;
     DW    CP850_NA_UP_K1_END-$ 	 ;; length of state section					;AN000;
     DB    NON_ALPHA_UPPER		 ;; State ID							;AN000;
     DW    G_KB+P12_KB+AT_KB		 ;; Keyboard Type						;AN000;
     DB    -1,-1			 ;; error character = standalone accent 			;AN000;
					 ;;								;AN000;
     DW    CP850_NA_UP_T1_K1_END-$	 ;; Size of xlat table						;AN000;
     DB    STANDARD_TABLE+ZERO_SCAN	 ;; xlat options:						;AN000;
     DB    1				 ;; number of scans						;AN000;
     DB    43,0F5H			 ;; Section symbol - 						;AN000;
  CP850_NA_UP_T1_K1_END:		 ;;								;AN000;
					 ;;								;AN000;
     DW    0				 ;; Size of xlat table - null table				;AN000;
					 ;;								;AN000;
  CP850_NA_UP_K1_END:			 ;;								;AN000;
					 ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
;; CODE PAGE: 850											;AN000;
;; STATE: Non-Alpha Upper case										;AN000;
;; KEYBOARD TYPES: XT											;AN000;
;; TABLE TYPE: Translate										;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
					 ;;								;AN000;
     DW    CP850_NA_UP_K2_END-$ 	 ;; length of state section					;AN000;
     DB    NON_ALPHA_UPPER		 ;; State ID							;AN000;
     DW    XT_KB			 ;; Keyboard Type						;AN000;
     DB    -1,-1			 ;; error character = standalone accent 			;AN000;
					 ;;								;AN000;
     DW    CP850_NA_UP_T1_K2_END-$	 ;; Size of xlat table						;AN000;
     DB    STANDARD_TABLE+ZERO_SCAN	 ;; xlat options:						;AN000;
     DB    1				 ;; number of scans						;AN000;
     DB    41,0F5H			 ;; Section symbol - 						;AN000;
  CP850_NA_UP_T1_K2_END:		 ;;								;AN000;
					 ;;								;AN000;
     DW    0				 ;; Size of xlat table - null table				;AN000;
					 ;;								;AN000;
  CP850_NA_UP_K2_END:			 ;;								;AN000;
					 ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
   DW	 0			       ;; LAST STATE							;AN000;
				       ;;								;AN000;
CP850_XLAT_END: 		       ;;								;AN000;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;								;AN000;
				       ;;								;AN000;
CODE	 ENDS			       ;;								;AN000;
	 END			       ;;								;AN000;
