;	PAGE ,132 ;
;	TITLE MSBIO2 - BIOS

	%warning out: ...MSBIO2.ASM

;==============================================================================
;REVISION HISTORY:
;AN000 - New for DOS Version 4.00 - J.K.
;AC000 - Changed for DOS Version 4.00 - J.K.
;AN00x - PTM number for DOS Version 4.00 - J.K.
;==============================================================================
;AN001; - P1820 New Message SKL file				  10/20/87 J.K.
;AN002; - P5045 New INT 2fh for Get BDS table vector for EMS	  06/06/88 J.K.
;==============================================================================

ROMSEGMENT	EQU	0F000H
labelsize MODELBYTE, byte, 0FFFEH
MODELPCJR	EQU	0FDH

	itest equ 0

	%include "entryseg.nas"
	%include "lmacros3.mac"
	%include "entrysw.mac"
	%include "msgroup.mac"	;DEFINE CODE SEGMENT
	%include "msequ.mac"
	%include "devsym.mac"
	%include "pushpop.mac"
	%include "msmacro.mac"
	%include "ddataseg.nas"
	%include "dcodeseg.nas"
	%include "codesw.mac"

addsection BIOCODE

addsection SYSINITSEG, PUBLIC class=INIT
addsection SYSINITTRAIL, PUBLIC class=INIT

group SYSINITGROUP SYSINITSEG SYSINITTRAIL

usesection BIOCODE

 assume ds:nothing, es:nothing, ss:nothing

	extern biocode_get_ds_dosentry, biocode_get_es_dosentry
	extern dosbiocode_get_ds_dosentry, dosbiocode_get_es_dosentry
	extern biocode_get_ds_dosbiodata
	extern biocode_get_es_dosbiodata
	extern dosbiocode_get_ds_dosbiodata
	extern dosbiocode_get_es_dosbiodata

	EXTRN	DSK$IN:NEAR
	EXTRN	SETPTRSAV:NEAR
	EXTRN	OUTCHR:NEAR
	EXTRN	SETDRIVE:NEAR
	EXTRN	FLUSH:NEAR
	EXTRN	HARDERR:NEAR
	EXTRN	HARDERR2:NEAR
	EXTRN	MAPERROR:NEAR
	EXTRN	GETBP:NEAR
	EXTRN	CHECKSINGLE:NEAR
	EXTRN	CHECK_TIME_OF_ACCESS:NEAR
	EXTRN	EXIT:NEAR
	EXTRN	HAS1:NEAR
	EXTRN	READ_SECTOR:NEAR

	EXTRN	OLD13:DWORD

;DATA
	EXTRN	PTRSAV:DWORD		;IBMBIO1
	EXTRN	START_BDS:WORD
	EXTRN	FDRIVE1:WORD
	EXTRN	FDRIVE2:WORD
	EXTRN	FDRIVE3:WORD
	EXTRN	FDRIVE4:WORD
	EXTRN	FLAGBITS:WORD
	EXTRN	TIM_DRV:BYTE
	EXTRN	MEDBYT:BYTE
	EXTRN	DRVMAX:BYTE
	extrn	Ext_Boot_Sig:byte		;AN000; ibmbdata
	extrn	SecPerClusInSector:byte 	;AN000; ibmbdata
	extrn	Boot_Serial_L:word		;AN000; ibmbdata
	extrn	Boot_Serial_H:word		;AN000; ibmbdata


	usesection DOSBIODATA

	extern	MODEL_BYTE
	extern	Secondary_Model_Byte
	extern	INT19SEM
%macro int19oldextern 1-*
 %rep %0
	extern	Int19OLD%1
  %rotate 1
 %endrep
%endmacro
	int19oldextern 02,08,09,0A,0B,0C,0D,0E,70,72,73,74,76,77
	extern dskdrvs_indirect


	addsection DOSBIOCODE

;  INT19
;
;	WE "HOOK" THE INT 19 VECTOR, BECAUSE CONTRARY TO IBM DOCUMENTATION,
;  IT DOES NOT "BOOTSTRAP" THE MACHINE.  IT LEAVES MEMORY ALMOST UNTOUCHED.
;  SINCE THE BIOS_INIT CODE ASSUMES THAT CERTAIN INTERRUPT VECTORS POINT TO
;  THE ROM_BIOS  WE MUST "UNHOOK" THEM BEFORE ISSUING THE ACTUAL INT_19.
;  CURRENTLY THE ONLY VECTORS THAT NEED TO BE UNHOOKED ARE INT_19, INT_13,
;  AND THE HARDWARE INTERRUPTS.
;
relocated i19
INT19	PROC	FAR
 assume ds:nothing, es:nothing, ss:nothing

 extern InterruptRestorationTable
	cld
	call dosbiocode_get_ds_dosentry	; IRT in DOSENTRY
 assume ds:DOSENTRYGROUP	; ds => DOSENTRY
	mov si, InterruptRestorationTable
.loop:
	xor ax, ax
	mov es, ax		; es => IVT
 assume es:IVT
	lodsb
	cmp al, -1
	je .done
	xchg di, ax		; di = interrupt number
	add di, di
	add di, di		; es:di -> interrupt vector
	movsw
	movsw			; restore from IRT
	jmp .loop
.done:

%ifnidni %[DOSBIODATA], %[DOSENTRY]
	push es
	pop ds			; => IVT
	call biocode_get_es_dosbiodata
 assume ds:IVT, es:DOSGROUP
%else
	push es
	push ds
	pop es
	pop ds			; swap, es => DOSENTRY, ds => IVT
%endif

	CMP	BYTE [es:INT19SEM], 0
	JNZ	INT19VECS
	JMP	DOINT19

%if 0	; dead code
;	ON THE PCJR, DON'T REPLACE ANY VECTORS
;	MODEL BYTE DEFINITIONS FROM IBMSTACK.ASM
	MOV	AX,ROMSEGMENT
	MOV	DS,AX
	MOV	AL,MODELPCJR

	CMP	AL,[MODELBYTE]
	JNE	INT19VECS
	JMP	DOINT19
%endif

;Stacks code has changed these hardware interrupt vectors
;STKINIT in SYSINIT1 will initialzie Int19hOLDxx values.
INT19VECS:
	XOR	AX,AX
	MOV	DS,AX
 assume ds:IVT


%macro int19restore 1-*
 %rep %0
	call dosbiocode_get_es_dosbiodata
 assume es:DOSGROUP
	LES	DI,[es:Int19OLD%1]
 assume es:nothing
;SB33103******************************************************************

	mov	ax,es		;
	cmp	ax,-1		;OPT 0ffffh is unlikely segment
	je	skip_int%1	;OPT no need to check selector too 
	cmp	di,-1		;OPT 0ffffh is unlikely offset
	je	skip_int%1

;SB33103******************************************************************
	MOV	[%1H*4],DI
	MOV	[%1H*4+2],ES
skip_int%1:
  %rotate 1
 %endrep
%endmacro

	int19restore 02,08,09,0A,0B,0C,0D,0E,70,72,73,74,76,77


DOINT19:
	mov ax, cs
	cmp ax, DOSCODE_HMA_SEGMENT
	jb .done

		; clear the VDISK header in HMA
	mov ax, -1		; => HMA
	mov es, ax
 assume es:nothing
	mov di, 10h		; -> start of HMA
	mov cx, di		; 10h words = 20h bytes
	inc ax			; = 0
	rep stosw		; re-initialise
.done:
	INT	19H
INT19	ENDP


section BIOCODE

	PUBLIC	DSK$INIT
DSK$INIT PROC	NEAR
 assume ds:DOSGROUP, es:nothing, ss:nothing
		; ds => DOSBIODATA from ENTRY in msbio1.nas
%ifnidni %[DOSBIODATA], %[DOSENTRY]
	call biocode_get_es_dosentry	; DRVMAX in DOSENTRY
 assume es:DOSENTRYGROUP
	es
%endif
	MOV	AH,BYTE PTR [DRVMAX]
	lds di, [dskdrvs_indirect]
 assume ds:UPB
	JMP	SETPTRSAV
DSK$INIT ENDP

;
; INT 2F HANDLER FOR EXTERNAL BLOCK DRIVERS TO COMMUNICATE WITH THE INTERNAL
; BLOCK DRIVER IN IBMDISK. THE MULTIPLEX NUMBER CHOSEN IS 8. THE HANDLER
; SETS UP THE POINTER TO THE REQUEST PACKET IN [PTRSAV] AND THEN JUMPS TO
; DSK$IN, THE ENTRY POINT FOR ALL DISK REQUESTS.
; ON EXIT FROM THIS DRIVER (AT EXIT), WE WILL RETURN TO THE EXTERNAL DRIVER
; THAT ISSUED THIS INT 2F, AND CAN THEN REMOVE THE FLAGS FROM THE STACK.
; THIS SCHEME ALLOWS US TO HAVE A SMALL EXTERNAL DEVICE DRIVER, AND MAKES
; THE MAINTAINANCE OF THE VARIOUS DRIVERS (DRIVER AND IBMBIO) MUCH EASIER,
; SINCE WE ONLY NEED TO MAKE CHANGES IN ONE PLACE (MOST OF THE TIME).
;
; 06/03/88 J.K. When AL=3, return DS:DI -> Start of BDS table.
;	   (EMS device driver hooks INT 13h to handle 16KB DMA overrun
;	    problem.  BDS table is going to be used to get head/sector
;	    informations without calling Generic IOCTL Get Device Parm call.)
;
; AL CONTAINS THE INT2F FUNCTION:
;   0 - CHECK FOR INSTALLED HANDLER - RESERVED
;   1 - INSTALL THE BDS INTO THE LINKED LIST
;   2 - DOS REQUEST
;   3 - Get BDS vector				;06/03/88 J.K.
;	Return BDS table starting pointer in DS:DI

MYNUM	EQU	8

relocated disk_i2F
 assume ds:nothing, es:nothing, ss:nothing
	CMP	AH,MYNUM
 extern relocatedmsdos_i2F
	jne relocatedmsdos_i2F		; CHAIN TO NEXT INT 2F HANDLER
	CMP	AL,0F8H			; IRET ON RESERVED FUNCTIONS
	jae .iret			; if >= 0F8h -->
	cmp al, 1			; what subfunction ?
	ja @F				; if > 1 -->
	je INSTALL_BDS			; if == 1 -->
					; if < 1
	MOV	AL,0FFH			; installation check
.iret:
	IRET

@@:
	cmp	al, 3			; Get BDS vector?
	je	DO_Get_BDS_Vector	; yes -->
					; 2 or 4..0F7h: call block device
; SET UP POINTER TO REQUEST PACKET
	push ds
	call biocode_get_ds_dosentry	; PTRSAV in DOSENTRY
 assume ds:DOSENTRYGROUP
	MOV	WORD PTR [PTRSAV], BX	; otherwise DOS block device function
	MOV	WORD PTR [PTRSAV+2], ES
	pop ds
 assume ds:nothing
	JMP	DSK$IN

DO_Get_BDS_Vector:			;AN002; AL=3
	call biocode_get_ds_dosbiodata
 assume ds:DOSGROUP
Start_BDS equ START_BDS	; NASM port label
	lds	di, [Start_BDS]		;AN002;
 assume ds:UPB
	IRET				;AN002;


; INSTALL_BDS INSTALLS A BDS A LOCATION DS:DI INTO THE CURRENT LINKED LIST OF
; BDS MAINTAINED BY THIS DEVICE DRIVER. IT PLACES THE BDS AT THE END OF THE
; LIST.

INSTALL_BDS:
 assume ds:nothing, es:nothing, ss:nothing
	MESSAGE FTESTINIT,<"INSTALL BDS",CR,LF>
; DS:DI POINT TO BDS TO BE INSTALLED
	call biocode_get_es_dosbiodata
 assume es:DOSGROUP
	LES	SI,[es:START_BDS]	; START AT BEGINNING OF LIST
 assume es:UPB
	PUSH	ES			; SAVE POINTER TO CURRENT BDS
	PUSH	SI
; ES:SI NOW POINT TO BDS IN LINKED LIST
LOOP_NEXT_BDS:
	inc si				; GOT TO END OF LINKED LIST? (-1)
	JZ	INSTALL_RET		; yes --> (will overwrite si)
	dec si				; undo inc

; IF WE HAVE SEVERAL LOGICAL DRIVES USING THE SAME PHYSICAL DRIVE, WE MUST
; SET THE I_AM_MULT FLAG IN EACH OF THE APPROPRIATE BDSS.
	MOV	AL,BYTE PTR [DI + DRIVENUM]
	CMP	BYTE PTR [ES:SI + DRIVENUM],AL
	JNZ	.NEXT_BDS
	MESSAGE FTESTINIT,<"LOGICAL DRIVES",CR,LF>
	MOV	bl, FI_AM_MULT
	OR	[DI + FLAGS], bl	; SET FLAGS IN BOTH BDSS CONCERNED
	OR	[ES:SI + FLAGS], bl
	AND	byte [DI + FLAGS], ~ FI_OWN_PHYSICAL
					; RESET THAT FLAG FOR 'NEW' BDS
; WE MUST ALSO SET THE FCHANGELINE BIT CORRECTLY.
	MOV	bl, [ES:SI + FLAGS]	; DETERMINE IF CHANGELINE AVAILABLE
	AND	BL,FCHANGELINE
	OR	[DI + FLAGS], bl

.NEXT_BDS:
; BEFORE MOVING TO NEXT BDS, PRESERVE POINTER TO CURRENT ONE. THIS IS NEEDED AT
; THE END WHEN THE NEW BDS IS LINKED INTO THE LIST.
	POP	BX			; DISCARD PREVIOUS POINTER TO BDS
	POP	BX
	PUSH	ES
	PUSH	SI
	les si, [es:si + LINK]
	mov bx, es			; returned bx
	JMP	SHORT LOOP_NEXT_BDS

INSTALL_RET:
	POP	SI			; RETRIEVE POINTER TO LAST BDS
	POP	ES			; IN LINKED LIST.
 assume es:UPB
	MOV	AX,DS			; returned ax
	MOV	WORD PTR [ES:SI + LINK + 2],AX ; INSTALL BDS
	MOV	WORD PTR [ES:SI + LINK],DI
	or	WORD PTR [DI + LINK],-1 ; SET NEXT POINTER TO NULL
	iret


usesection SYSINITTRAIL		; fix to not run in unrelocated DOSCODE

; lDOS: This used to install the msbio int 2Fh handler. No longer used.
	PUBLIC	RE_INIT
RE_INIT PROC	near
 assume ds:nothing, es:nothing, ss:nothing
	MESSAGE FTESTINIT,<"REINIT",CR,LF>
	retn

RE_INIT ENDP


usesection BIOCODE

;-------------------------------------------------
;
;  ASK TO SWAP THE DISK IN DRIVE A:
;
		; INP:	ah = prior drive letter
		;	ds:di -> UPB for target drive, already active
		; CHG:	ax
	PUBLIC	SWPDSK
SWPDSK	PROC	NEAR
 assume ds:UPB, es:nothing, ss:nothing
	push cx
	push dx
	MOV	AL,BYTE PTR [DI + DRIVELET] ; GET THE DRIVE LETTER
;USING A DIFFERENT DRIVE IN A ONE DRIVE SYSTEM SO REQUEST THE USER CHANGE DISKS
	xchg dx, ax			; dh = prior, dl = new
	push es
	 push ds
	 pop es				; (super undocumented? es:di -> target UPB)
 assume es:UPB
	xor cx, cx
	mov ax, 4A00h
	int 2Fh				; MS-DOS v5+ drive change notification
	inc cx				; was FFFFh ?
	jz .skip			; yes, someone handled it -->
	xchg ax, dx			; get new drive back to al
	ADD	AL,"A"			; make into a letter
	PUSH	DS			; PRESERVE SEGMENT REGISTER
	call biocode_get_ds_dosbiodata
 assume ds:DOSGROUP
	MOV	[DRVLET],AL
	MOV	SI,OFFSET SNGMSG	; DS:SI -> MESSAGE
	PUSH	BX
	CALL	WRMSG			;PRINT DISK CHANGE MESSAGE
	CALL	FLUSH
;SB33003***************************************************************
	xor	AH, AH			; set command to read character;SB
	int	16h			; call rom-bios		       ;SB
;SB33003***************************************************************
	POP	BX
	POP	DS			; RESTORE SEGMENT REGISTER
 assume ds:UPB
.skip:
	pop es
 assume es:nothing
	pop dx
	pop cx
WRMRET:
	RET
SWPDSK	ENDP

;----------------------------------------------
;
;	WRITE OUT MESSAGE POINTED TO BY [SI]
;
	PUBLIC	WRMSG
WRMSG	PROC	NEAR
 assume ds:DOSGROUP, es:nothing, ss:nothing
	LODSB				;GET THE NEXT CHARACTER OF THE MESSAGE
	test	AL,AL			;SEE IF END OF MESSAGE
	JZ	WRMRET
;	INT	CHROUT
	PUSHF
	PUSH	CS
	CALL	OUTCHR
	JMP	SHORT WRMSG
WRMSG	ENDP


usesection DOSBIODATA
	extern SNGMSG
	extern DRVLET


usesection BIOCODE

;
; END OF SUPPORT FOR MULTIPLE FLOPPIES WITH NO LOGICAL DRIVES
; THIS IS NOT 'SPECIAL' ANY MORE BECAUSE WE NOW HAVE THE CAPABILITY OF
; DEFINING LOGICAL DRIVES IN CONFIG.SYS. WE THEREFORE KEEP THE CODE FOR
; SWAPPING RESIDENT ALL THE TIME.
;

;J.K. 10/1/86 *******************************************************
;Variables for Dynamic Relocatable modules
;These should be stay resident.

usesection DOSBIODATA

	align 2, db 0

	PATHSTART 001,CLK
;
;   DATA STRUCTURES FOR REAL-TIME DATE AND TIME
;
	public	BIN_DATE_TIME
	public	MONTH_TABLE
	public	DAYCNT2
	public	FEB29
BIN_DATE_TIME:
	DB	0		; CENTURY (19 OR 20) OR HOURS (0-23)
	DB	0		; YEAR IN CENTURY (0...99) OR MINUTES (0-59)
	DB	0		; MONTH IN YEAR (1...12) OR SECONDS (0-59)
	DB	0		; DAY IN MONTH (1...31)
MONTH_TABLE:			;
	DW	0		;MJB002 JANUARY
	DW	31		;MJB002 FEBRUARY
	DW	59		;MJB002
	DW	90		;MJB002
	DW	120		;MJB002
	DW	151		;MJB002
	DW	181		;MJB002
	DW	212		;MJB002
	DW	243		;MJB002
	DW	273		;MJB002
	DW	304		;MJB002
	DW	334		;MJB002 DECEMBER
DAYCNT2 DW	0000		;MJB002 TEMP FOR COUNT OF DAYS SINCE 1-1-80
FEB29	DB	0		;MJB002 FEBRUARY 29 IN A LEAP YEAR FLAG
	PATHEND 001,CLK

;********************************************************************
;

usesection DOSENTRY

	PUBLIC	ENDFLOPPY
ENDFLOPPY LABEL BYTE

	PATHSTART 004,BIO


usesection SYSINITTRAIL

	global partition_table, partition_table.end
	align 4, db 0		; ! this needs WarpLink ecm release 3
				; (r1 and r2 had new bugs, so we want r3 now)
partition_table:
	times 64 db 0
.end:

	global load_mode, load_scan_flags, load_partition_cycle
	global load_current_partition, load_unit, load_amount_units
	global next_block_device_unit
	align 2, db 0
load_mode:
	dw 0
load_scan_flags:
	dw 0
load_partition_cycle:
	dw 0
load_current_partition:
	db 0
load_unit:
	db 0
load_amount_units:
	db 0
next_block_device_unit:
	db 0


	PUBLIC	HNUM
HNUM	DB	0			;NUMBER OF HARDFILES
	PUBLIC	HARDDRV
HARDDRV DB	80H			;PHYSICAL DRIVE NUMBER OF FIRST HARDFILE

;**********************************************************************
;	"HDRIVE" IS A HARD DISK WITH 512 BYTE SECTORS
;*********************************************************************
	EVENB

BDSM_type_size equ BDSM_type_struc_size		; NASM port equate
	public BDS_harddisk_template
BDS_harddisk_template:
istruc BDSM_type
at mlink
	dw -1
	dw -1			; LINK TO NEXT STRUCTURE
at mdriveNum
	db 80h			; INT 13 DRIVE NUMBER
at mdriveLet
	db 3			; LOGICAL DRIVE LETTER
at mBytePerSec
	dw 512
at mSecPerClus
	db 1			; SECTORS/ALLOCATION UNIT
at mRESSEC
	dw 1			; RESERVED SECTORS FOR DOS
at mcFAT
	db 2			; NO. OF ALLOCATION TABLES
at mcDIR
	dw 16			; NUMBER OF DIRECTORY ENTRIES
at mDRVLIM
	dw 0			; NUMBER OF SECTORS (AT 512 BYTES EACH)
at mMediad
	db 1111_1000b		; MEDIA DESCRIPTOR
at mcSecFat
	dw 1			; NUMBER OF FAT SECTORS
at mSECLIM
	dw 0			; SECTOR LIMIT
at mHDLIM
	dw 0			; HEAD LIMIT
at mHIDSEC_L
	dw 0			; HIDDEN SECTOR COUNT(low)
at mHidsec_H
	dw 0			; Hidden Sector (high)
at mDrvlim_L
	dw 0			; Number of Sectors (low)
at mDrvlim_H
	dw 0			; Number of Sectors (high)
at mFatSiz
	db 0			; TRUE => BIGFAT
at mOPCNT
	dw 0			; OPEN REF. COUNT
at mFormFactor
	db 3			; FORM FACTOR
at mFLAGS
	dw 20h			; VARIOUS FLAGS
at mcCyln
	dw 40			; NUMBER OF CYLINDERS
at mRecBPB
	db 0			; RECOMMENDED BPB FOR DRIVE
at mTrack
	db -1			; LAST TRACK ACCESSED ON THIS DRIVE
at IsMini
	dw 1
at Hidden_Trks
	dw 0
at mVOLID
	db "NO NAME    "
	db 0			; VOLUME ID FOR THIS DISK
at mVol_Serial
	dd 0			; Current volume serial number from Boot record
at mFileSys_Id
	db "FAT12   "
	db 0			; Current file system id from Boot record
iend

usesection BIOCODE

;
; END OF SECTION FOR TWO HARD DISKS

	PATHEND 004,BIO

;	PAGE
;=== Push trace listing source: ms96tpi.nas
	%include "ms96tpi.nas" ; NASM included file
;=== Pop trace listing source

;*********************************************************************
;Memory allocation for BDSM table. - J.K. 2/21/86
;*********************************************************************

%if 0
mlink		DW	? ;-1			;Link to next structure
		DW	?
mdriveNum	DB	? ;80			;Int 13 Drive Number
mdriveLet	DB	? ;3			;Logical Drive Number
mBytePerSec	DW	? ;512
mSecPerClus	DB	? ;1			;Sectors/allocation unit
mRESSEC 	DW	? ;1			;Reserved sectors for DOS
mcFAT		DB	? ;2			;No. of allocation tables
mcDIR		DW	? ;16			;Number of directory entries
mDRVLIM 	DW	? ;0			;Number of sectors (at 512 bytes each)
mMediad 	DB	? ;11111000B		;Media descriptor
mcSecFat	DW	? ;1			;Number of FAT sectors
mSECLIM 	DW	? ;0			;Sector limit
mHDLIM		DW	? ;0			;Head limit
mHIDSEC_L	DW	? ;0			;Hidden sector count
mHidsec_H	dw	? ;0			;J.K.87
mDrvlim_L	dw	? ;0			;J.K.87
mDrvlim_H	dw	? ;0			;J.K.87
mFatSiz 	DB	? ;0			;TRUE => bigfat
mOPCNT		DW	? ;0			;Open Ref. Count
mFormFactor	DB	? ;3			;Form Factor
mFLAGS		DW	? ;0020H		;Various Flags
mcCyln		dw	? ;40			;max number of cylinders
mRecBPB 	db	31 dup (?) ;(0)		;Recommended BPB for drive
mTrack		db	? ;-1
IsMini		dw	? ;1			;Overlapping TIM_LOH
Hidden_Trks	dw	? ;0			;Overlapping TIM_HIH
mVOLID		DB	11 dup (?) ;"NO NAME    "           ;Volume ID for this disk
		DB	? ;0			;ASCIZII for "NO NAME    "
mVol_Serial	dd	? ;0	   ;Current volume serial number from Boot record
mFileSys_Id	db	8 dup (?) ;"FAT12   " ;Current file system id from Boot record
		db	? ;0
%endif

;
;;3.3 BUG FIX -SP ------------------------------
;;Migrated into 4.00 -MRW
;Paragraph buffer between the BDSMs and MSHARD
;
;The relocation code for MSHARD needs this. this cannot be used for 
;anything. nothing can come before this or after this.....IMPORTANT!!!!
;don't get too smart and using this buffer for anything!!!!!!

	align 16, db 0CCh

;
;end of bug fix buffer
;;
;;3.3 BUG FIX -SP------------------------------
	END
