	PAGE	,132			;
	TITLE	COMPSM.SAL - COMP SYSTEM MESSAGES
;****************** START OF SPECIFICATIONS *****************************
; MODULE NAME: COMPSM.SAL
;
; DESCRIPTIVE NAME: Include the DOS system MESSAGE HANDLER in the SEGMENT
;		    configuration expected by the modules of COMP.
;
;FUNCTION: The common code of the DOS SYSTEM MESSAGE HANDLER is made a
;	   part of the COMP module by using INCLUDE to bring in the
;	   common portion, in SYSMSG.INC.  This included code contains
;	   the routines to initialize for message services, to find
;	   where a particular message is, and to display a message.
;
; ENTRY POINT: SYSDISPMSG:near
;	       SYSGETMSG:near
;	       SYSLOADMSG:near
;
; INPUT:
;    AX = MESSAGE NUMBER
;    BX = HANDLE TO DISPLAY TO (-1 means use DOS functions 1-12)
;    SI = OFFSET IN ES: OF SUBLIST, OR 0 IF NONE
;    CX = NUMBER OF %PARMS, 0 IF NONE
;    DX = CLASS IN HIGH BYTE, INPUT FUNCTION IN LOW
;   CALL SYSDISPMSG		;DISPLAY THE MESSAGE
;
;    If carry set, extended error already called:
;    AX = EXTENDED MESSAGE NUMBER
;    BH = ERROR CLASS
;    BL = SUGGESTED ACTION
;    CH = LOCUS
; _ _ _ _ _ _ _ _ _ _ _ _
;
;    AX = MESSAGE NUMBER
;    DH = MESSAGE CLASS (1=DOS EXTENDED ERROR, 2=PARSE ERROR, -1=UTILITY MSG)
;   CALL SYSGETMSG		 ;FIND WHERE A MSG IS
;
;    If carry set, error
;     CX = 0, MESSAGE NOT FOUND
;    If carry NOT set, ok, and resulting regs are:
;     CX = MESSAGE SIZE
;     DS:SI = MESSAGE TEXT
; _ _ _ _ _ _ _ _ _ _ _ _
;
;   CALL SYSLOADMSG		 ;SET ADDRESSABILITY TO MSGS, CHECK DOS VERSION
;    If carry not set:
;    CX = SIZE OF MSGS LOADED
;
;    If carry is set, regs preset up for SYSDISPMSG, as:
;    AX = ERROR CODE IF CARRY SET
;	  AX = 1, INCORRECT DOS VERSION
;	  DH =-1, (Utility msg)
;	OR,
;	  AX = 1, Error loading messages
;	  DH = 0, (Message manager error)
;    BX = STDERR
;    CX = NO_REPLACE
;    DL = NO_INPUT
;
; EXIT-NORMAL: CARRY is not set
;
; EXIT-ERROR:  CARRY is set
;	       Call Get Extended Error for reason code, for SYSDISPMSG and
;	       SYSGETMSG.
;
; INTERNAL REFERENCES:
;    ROUTINES: (Generated by the MSG_SERVICES macro)
;	SYSLOADMSG
;	SYSDISPMSG
;	SYSGETMSG
;
;    DATA AREAS:
;	INCLUDED "COMPMS.INC" - message defining control blocks
;	INCLUDED "MSGHAN.INC" - Define STRUCs for msg control blocks
;	INCLUDE SYSMSG.INC   ;Permit System Message handler definition
;
; EXTERNAL REFERENCES:
;    ROUTINES: none
;
;    DATA AREAS: control blocks pointed to by input registers.
;
; NOTES:
;	 This module should be processed with the SALUT preprocessor
;	 with the re-alignment not requested, as:
;
;		SALUT COMPSM,nul,;
;
;	 To assemble these modules, the alphabetical or sequential
;	 ordering of segments may be used.
;
;	 For LINK instructions, refer to the PROLOG of the main module,
;	 COMP1.ASM.
;
; REVISION HISTORY: A000 Version 4.0 : add PARSER, System Message Handler,
;		  Add compare of code page extended attribute, if present.
;
; COPYRIGHT: "The DOS COMP Utility"
;	     "Version 4.0  (C)Copyright 1988 Micorsoft "
;	     "Licensed Material - Property of Microsoft "
;
;PROGRAM AUTHOR: DOS 3.20 Dave L.
;		 DOS 3.30 modifications by Russ W.
;		 DOS 4.0  modifications by Edwin M. K., Bill L.
;****************** END OF SPECIFICATIONS *****************************
;									 ;AN000;
	IF1								 ;AN000;
	    %OUT    COMPONENT=COMP, MODULE=COMPSM.SAL...		 ;AN000;
	ENDIF								 ;AN000;
; =  =	=  =  =  =  =  =  =  =	=  =					 ;AN000;
;									 ;AN000;
HEADER	MACRO	TEXT							 ;AN000;
.XLIST									 ;AN000;
	SUBTTL	TEXT							 ;AN000;
.LIST									 ;AN000;
	PAGE								 ;AN000;
	ENDM								 ;AN000;
; =  =	=  =  =  =  =  =  =  =	=  =					 ;AN000;
	INCLUDE SYSMSG.INC		;PERMIT SYSTEM MESSAGE HANDLER DEFINITION ;AN000;
	MSG_UTILNAME <COMP>		;IDENTIFY THE UTILITY		 ;AN000;
; =  =	=  =  =  =  =  =  =  =	=  =					 ;AN000;
	HEADER	<DEFINITION OF MESSAGES>				 ;AN000;
;	   $SALUT (4,12,18,36)						 ;AN000;
CSEG	   SEGMENT PARA PUBLIC	'CODE'					 ;AN000;
	   ASSUME CS:CSEG,DS:CSEG,ES:CSEG,SS:CSEG			 ;AN000;
;									 ;AN000;
	   PUBLIC COPYRIGHT						 ;AN000;
COPYRIGHT  DB	 "The DOS COMP Utility" 	       ;AN000;
	   INCLUDE MSGHAN.INC	   ;DEFINE THE MESSAGE HANDLER CONTROL BLOCKS ;AN000;
	   INCLUDE COMPMS.INC	   ;DEFINE THE MESSAGES, AND CONTROL BLOCKS ;AN000;
	   MSG_SERVICES <MSGDATA>					 ;AN000;
; =  =	=  =  =  =  =  =  =  =	=  =					 ;AN000;
	   HEADER <SYSTEM MESSAGE HANDLER>				 ;AN000;
	   PUBLIC SYSLOADMSG						 ;AN000;
	   PUBLIC SYSDISPMSG						 ;AN000;
	   PUBLIC SYSGETMSG						 ;AN000;
;									 ;AN000;
;	   MSG_SERVICES <LOADmsg,GETmsg,DISPLAYmsg,CHARmsg,INPUTmsg,NUMmsg> ;AN000;
				   ;DEFAULT=CHECK DOS VERSION		 ;AN000;
				   ;DEFAULT=NEARmsg			 ;AN000;
				   ;DEFAULT=INPUTmsg			 ;AN000;
				   ;DEFAULT=NUMmsg			 ;AN000;
				   ;DEFAULT=NO TIMEmsg			 ;AN000;
				   ;DEFAULT=NO DATEmsg			 ;AN000;
.XLIST									 ;AN000;
.XCREF									 ;AN000;

 public amis_sign
	even
amis_sign:
	db "ecm"
	db 5 dup (' ')
	db "lDOS"
	db 4 dup (' ')
amis_id:			; must be directly after amis_sign
	dw 0
	dw 0			; sequential number
	db amis_id_msg_end - amis_id_msg
amis_id_msg:
	db "comp"		; our id name
amis_id_msg_end:

AMIS_SIGN_SEGMENT equ CSEG

	   MSG_SERVICES <LOADmsg>					 ;AN000;
	   MSG_SERVICES <GETmsg>					 ;AN000;
	   MSG_SERVICES <DISPLAYmsg,CHARmsg,INPUTmsg,NUMmsg>		 ;AN000;
.LIST									 ;AN000;
.CREF									 ;AN000;
;									 ;AN000;
	   MSG_SERVICES <COMP.CLA,COMP.CL1,COMP.CL2> ;TEXTS OF MESSAGES  ;AN000;
; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =	 ;AN000;
CSEG	   ENDS 							 ;AN000;

	include msgdcl.inc

	   END								 ;AN000;

